/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.it.preprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.datatypes.MaryXML;
import marytts.language.it.preprocess.CompositeEP;
import marytts.language.it.preprocess.NumberEP;
import marytts.language.it.preprocess.SpecialCharEP;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExpansionPattern {
    protected static CompositeEP composite;
    protected static NumberEP number;
    protected static SpecialCharEP specialChar;
    private static List expansionPatterns;
    private static Map patternTable;
    private static Logger logger;

    static {
        expansionPatterns = new ArrayList();
        patternTable = new HashMap();
        composite = new CompositeEP();
        expansionPatterns.add(composite);
        Iterator it = composite.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), composite);
        }
        number = new NumberEP();
        expansionPatterns.add(number);
        it = number.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), number);
        }
        specialChar = new SpecialCharEP();
        expansionPatterns.add(specialChar);
        it = specialChar.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), specialChar);
        }
        logger = MaryUtils.getLogger((String)"ExpansionPattern");
    }

    public static List allPatterns() {
        return expansionPatterns;
    }

    public static ExpansionPattern getPattern(String typeString) {
        return (ExpansionPattern)patternTable.get(typeString);
    }

    public static Pattern reSplitAtChars() {
        return specialChar.getRESplitAtChars();
    }

    public static String getSplitAtChars() {
        return specialChar.splitAtChars();
    }

    protected boolean allowMultipleTokens() {
        return true;
    }

    protected boolean doesFullExpansion() {
        return true;
    }

    public abstract List knownTypes();

    public abstract Pattern reMatchingChars();

    /*
     * Unable to fully structure code
     */
    public boolean process(Element t, List expanded) {
        block10: {
            block11: {
                if (t == null || expanded == null) {
                    throw new NullPointerException("Received null argument");
                }
                if (!t.getTagName().equals("t")) {
                    throw new DOMException(15, "Expected t element");
                }
                if (!expanded.isEmpty()) {
                    throw new IllegalArgumentException("Expected empty list, but list has " + expanded.size() + " elements.");
                }
                sb = new StringBuilder();
                matchedType = -1;
                candidates = new ArrayList<Element>();
                if (!this.allowMultipleTokens()) break block11;
                n = t;
                while (n != null && n.getTagName().equals("t") && !n.hasAttribute("ph") && !n.hasAttribute("sounds_like") && this.isCandidate(n)) {
                    candidates.add(n);
                    n = MaryDomUtils.getNextSiblingElement((Element)n);
                }
                if (!candidates.isEmpty()) ** GOTO lbl29
                return false;
lbl-1000:
                // 1 sources

                {
                    sb.setLength(0);
                    it = candidates.iterator();
                    while (it.hasNext()) {
                        sb.append(MaryDomUtils.tokenText((Element)((Element)it.next())));
                    }
                    matchedType = this.match(sb.toString(), 0);
                    if (matchedType != -1) break block10;
                    candidates.remove(candidates.size() - 1);
lbl29:
                    // 2 sources

                    ** while (!candidates.isEmpty())
                }
lbl30:
                // 1 sources

                break block10;
            }
            if (!t.hasAttribute("ph") && !t.hasAttribute("sounds_like") && this.isCandidate(t)) {
                sb.setLength(0);
                sb.append(MaryDomUtils.tokenText((Element)t));
                matchedType = this.match(sb.toString(), 0);
                candidates.add(t);
            }
        }
        if (matchedType != -1) {
            ExpansionPattern.logger.debug((Object)("Found match, type " + this.knownTypes().get(matchedType) + ": " + sb.toString() + " (" + candidates.size() + " tokens)"));
            expanded.addAll(this.expand(candidates, sb.toString(), matchedType));
            if (expanded.isEmpty() && !this.knownTypes().get(matchedType).equals("specialChar")) {
                ExpansionPattern.logger.info((Object)("Could match, but not expand string \"" + sb + "\" as type " + this.knownTypes().get(matchedType)));
            }
            return expanded.isEmpty() == false && this.doesFullExpansion() != false;
        }
        return false;
    }

    protected boolean isCandidate(Element t) {
        return this.reMatchingChars().matcher(MaryDomUtils.tokenText((Element)t)).find();
    }

    public void match(Element sayas, String typeString) throws DOMException {
        if (!sayas.getTagName().equals("say-as")) {
            throw new DOMException(15, "Expected say-as element, got " + sayas.getTagName());
        }
        List tokens = MaryDomUtils.getNodeListAsList((NodeList)sayas.getElementsByTagName("t"));
        StringBuilder sb = new StringBuilder();
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            sb.append(MaryDomUtils.tokenText((Element)((Element)it.next())));
        }
        int type = this.knownTypes().indexOf(typeString);
        int expandType = this.canDealWith(sb.toString(), type);
        if (expandType != -1) {
            List expanded = this.expand(tokens, sb.toString(), expandType);
            if (expanded.isEmpty()) {
                logger.info((Object)("Failure expanding string \"" + sb + "\" as type \"" + this.knownTypes().get(expandType) + "\""));
            }
        } else {
            logger.info((Object)("Cannot expand string \"" + sb.toString() + "\" as requested type \"" + typeString + "\""));
        }
    }

    protected abstract int canDealWith(String var1, int var2);

    protected abstract int match(String var1, int var2);

    protected abstract List expand(List var1, String var2, int var3);

    protected List makeNewTokens(Document doc, String newText) {
        return this.makeNewTokens(doc, newText, false, null);
    }

    protected List makeNewTokens(Document doc, String newText, boolean createMtu, String origText) {
        return this.makeNewTokens(doc, newText, createMtu, origText, false);
    }

    protected List makeNewTokens(Document doc, String newText, boolean createMtu, String origText, boolean forceAccents) {
        if (newText == null || newText.length() == 0) {
            return null;
        }
        Pattern rePron = Pattern.compile("\\[(.*)\\]");
        StringTokenizer st = new StringTokenizer(newText);
        ArrayList<Element> newTokens = new ArrayList<Element>();
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            Element newT = MaryXML.createElement((Document)doc, (String)"t");
            Matcher remPron = rePron.matcher(text);
            if (remPron.find()) {
                String pron = remPron.group(1);
                text = rePron.matcher(text).replaceFirst("");
                newT.setAttribute("ph", pron);
            }
            MaryDomUtils.setTokenText((Element)newT, (String)text);
            if (forceAccents) {
                newT.setAttribute("accent", "unknown");
            }
            newTokens.add(newT);
        }
        if (createMtu) {
            Element mtu = MaryXML.createElement((Document)doc, (String)"mtu");
            mtu.setAttribute("orig", origText);
            mtu.setAttribute("accent", "last");
            Iterator it = newTokens.iterator();
            while (it.hasNext()) {
                mtu.appendChild((Element)it.next());
            }
            ArrayList<Element> result = new ArrayList<Element>();
            result.add(mtu);
            return result;
        }
        return newTokens;
    }

    /*
     * Unable to fully structure code
     */
    protected void replaceTokens(List oldTokens, List newTokens) {
        block5: {
            if (oldTokens == null || oldTokens.isEmpty() || newTokens == null || newTokens.isEmpty()) {
                throw new NullPointerException("Have received null or empty argument.");
            }
            oldT = null;
            itOld = oldTokens.iterator();
            for (Element newT : newTokens) {
                if (itOld.hasNext()) {
                    oldT = (Element)itOld.next();
                }
                oldT.getParentNode().insertBefore(newT, oldT);
                if (!itOld.hasNext()) continue;
                oldT.getParentNode().removeChild(oldT);
            }
            if (itOld.hasNext()) ** GOTO lbl21
            oldT.getParentNode().removeChild(oldT);
            break block5;
lbl-1000:
            // 1 sources

            {
                oldT = (Element)itOld.next();
                oldT.getParentNode().removeChild(oldT);
lbl21:
                // 2 sources

                ** while (itOld.hasNext())
            }
        }
        for (Element mtu : newTokens) {
            if (!mtu.getTagName().equals("mtu") || !(parent = (Element)mtu.getParentNode()).getTagName().equals("mtu") || MaryDomUtils.getPreviousSiblingElement((Element)mtu) != null || MaryDomUtils.getNextSiblingElement((Element)mtu) != null || !parent.getAttribute("orig").equals(mtu.getAttribute("orig"))) continue;
            grandParent = (Element)parent.getParentNode();
            grandParent.insertBefore(mtu, parent);
            grandParent.removeChild(parent);
        }
    }

    protected void slowDown(Element e) {
        Document doc = e.getOwnerDocument();
        Element whereToInsert = e;
        Element prosody = null;
        Element phonol = null;
        if (whereToInsert.getParentNode().getNodeName().equals("phonology")) {
            phonol = (Element)whereToInsert.getParentNode();
            if (phonol.getParentNode().getNodeName().equals("prosody")) {
                prosody = (Element)phonol.getParentNode();
            }
        } else {
            phonol = MaryXML.createElement((Document)doc, (String)"phonology");
            prosody = MaryXML.createElement((Document)doc, (String)"prosody");
            prosody.appendChild(phonol);
            whereToInsert.getParentNode().insertBefore(prosody, whereToInsert);
            phonol.appendChild(whereToInsert);
        }
        prosody.setAttribute("rate", "-20%");
        phonol.setAttribute("precision", "precise");
    }

    protected void slowDown(Element first, Element last) {
        Element phonol = MaryDomUtils.encloseNodesWithNewElement((Node)first, (Node)last, (String)"phonology");
        phonol.setAttribute("precision", "precise");
        Document doc = phonol.getOwnerDocument();
        Element prosody = MaryXML.createElement((Document)doc, (String)"prosody");
        prosody.setAttribute("rate", "-20%");
        phonol.getParentNode().insertBefore(prosody, phonol);
        prosody.appendChild(phonol);
    }
}

