/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.fr;

import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class Preprocess
extends InternalModule {
    private RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(ULocale.FRENCH, 1);
    protected final String cardinalRule;
    protected final String ordinalRule = Preprocess.getOrdinalRuleName(this.rbnf);

    public Preprocess() {
        super("Preprocess", MaryDataType.TOKENS, MaryDataType.WORDS, Locale.FRENCH);
        this.cardinalRule = "%spellout-numbering";
    }

    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.checkForNumbers(doc);
        MaryData result = new MaryData(this.getOutputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    protected void checkForNumbers(Document doc) {
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
        Element t = null;
        while ((t = (Element)tw.nextNode()) != null) {
            if (MaryDomUtils.hasAncestor((Node)t, (String)"say-as") || t.hasAttribute("ph") || t.hasAttribute("sounds_like")) continue;
            String origText = MaryDomUtils.tokenText((Element)t);
            if (MaryDomUtils.tokenText((Element)t).matches("\\d+(e|er|re|\u00e8re|\u00e8me)")) {
                String matched = MaryDomUtils.tokenText((Element)t).split("e|ere|er|re|\u00e8re|\u00e8me")[0];
                if (matched.equals("1")) {
                    if (MaryDomUtils.tokenText((Element)t).matches("\\d+er")) {
                        MaryDomUtils.setTokenText((Element)t, (String)this.expandOrdinal(Double.parseDouble(matched)));
                    } else {
                        String s = this.expandOrdinal(Double.parseDouble(matched));
                        MaryDomUtils.setTokenText((Element)t, (String)s.replace("ier", "i\u00e8re"));
                    }
                } else {
                    MaryDomUtils.setTokenText((Element)t, (String)this.expandOrdinal(Double.parseDouble(matched)));
                }
            } else if (MaryDomUtils.tokenText((Element)t).matches("\\d+")) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandNumber(Double.parseDouble(MaryDomUtils.tokenText((Element)t))));
            }
            if (origText.equals(MaryDomUtils.tokenText((Element)t))) continue;
            MaryDomUtils.encloseWithMTU((Element)t, (String)origText, null);
        }
    }

    protected String expandNumber(double number) {
        this.rbnf.setDefaultRuleSet(this.cardinalRule);
        return this.rbnf.format(number);
    }

    protected String expandOrdinal(double number) {
        this.rbnf.setDefaultRuleSet(this.ordinalRule);
        return this.rbnf.format(number);
    }

    protected static String getOrdinalRuleName(RuleBasedNumberFormat rbnf) {
        List<String> l = Arrays.asList(rbnf.getRuleSetNames());
        if (l.contains("%spellout-ordinal")) {
            return "%spellout-ordinal";
        }
        if (l.contains("%spellout-ordinal-masculine")) {
            return "%spellout-ordinal-masculine";
        }
        for (String string : l) {
            if (!string.startsWith("%spellout-ordinal")) continue;
            return string;
        }
        throw new UnsupportedOperationException("The locale " + rbnf.getLocale(ULocale.ACTUAL_LOCALE) + " doesn't supports ordinal spelling.");
    }
}

