/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.InternalModule;
import marytts.util.MaryRuntimeUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class Preprocess
extends InternalModule {
    private Map<Object, Object> abbrevMap;
    private static final Map<String, String> symbols;
    private static final Map<String, String[]> contractions;
    private RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(ULocale.ENGLISH, 1);
    protected final String cardinalRule;
    protected final String ordinalRule = Preprocess.getOrdinalRuleName(this.rbnf);
    protected final String yearRule = Preprocess.getYearRuleName(this.rbnf);
    private DateFormat df = DateFormat.getDateInstance((int)1, (ULocale)ULocale.ENGLISH);
    private static final Pattern moneyPattern;
    private static final Pattern timePattern;
    private static final Pattern durationPattern;
    private static final Pattern abbrevPattern;
    private static final Pattern acronymPattern;
    private static final Pattern realNumPattern;
    private static final Pattern numberWordPattern;
    private static final Pattern datePattern;
    private static final Pattern yearPattern;
    private static final Pattern contractPattern;
    private static final Pattern symbolsPattern;
    private static final Pattern URLPattern;
    private static final Pattern rangePattern;
    private static final Pattern consonantPattern;
    private static final Pattern punctuationPattern;
    private static final Pattern myPunctPattern;
    private static final Pattern hashtagPattern;
    private static final Pattern ordinalPattern;
    private static final Pattern currencySymbPattern;
    private static final Pattern numberSPattern;

    static {
        moneyPattern = Pattern.compile("(\\d+)(\\.\\d+)?");
        currencySymbPattern = Pattern.compile("[$\u00a3\u20ac)]");
        timePattern = Pattern.compile("((0?[0-9])|(1[0-1])|(1[2-9])|(2[0-3])):([0-5][0-9])(a\\.m\\.|am|pm|p\\.m\\.|a\\.m|p\\.m)?", 2);
        yearPattern = Pattern.compile("(\\d+)(bc|ad|b\\.c\\.|b\\.c|a\\.d\\.|a\\.d)", 2);
        ordinalPattern = Pattern.compile("\\d+(st|nd|rd|th)", 2);
        durationPattern = Pattern.compile("(\\d+):([0-5][0-9]):([0-5][0-9])(:([0-5][0-9]))?");
        abbrevPattern = Pattern.compile("[a-zA-Z]{2,}\\.");
        acronymPattern = Pattern.compile("([a-zA-Z]\\.[a-zA-Z](\\.)?)+([a-zA-Z](\\.)?)?");
        realNumPattern = Pattern.compile("(-)?(\\d+)?(\\.(\\d+)(%)?)?");
        numberWordPattern = Pattern.compile("([a-zA-Z]+[0-9]+|[0-9]+[a-zA-Z]+)\\w*");
        datePattern = Pattern.compile("(\\d{2})[\\/\\.](\\d{2})[\\/\\.]\\d{4}");
        contractPattern = Pattern.compile("[a-zA-Z]+('[a-zA-Z]+)");
        symbolsPattern = Pattern.compile("[@%#\\/\\+=&><-]");
        rangePattern = Pattern.compile("([0-9]+)-([0-9]+)");
        consonantPattern = Pattern.compile("[b-df-hj-np-tv-z]+", 2);
        punctuationPattern = Pattern.compile("\\p{Punct}");
        numberSPattern = Pattern.compile("([0-9]+)([sS])");
        myPunctPattern = Pattern.compile(",\\.:;?'\"");
        hashtagPattern = Pattern.compile("(#)(\\w+)");
        URLPattern = Pattern.compile("(https?:\\/\\/)?((www\\.)?([-a-zA-Z0-9@:%._\\\\+~#=]{2,256}\\.[a-z]{2,6}\\b([-a-zA-Z0-9@:%_\\\\+.~#?&\\/=]*)))");
        contractions = new HashMap<String, String[]>();
        contractions.put("'s", new String[]{"z", "s"});
        contractions.put("'ll", new String[]{"l"});
        contractions.put("'ve", new String[]{"v"});
        contractions.put("'d", new String[]{"d"});
        contractions.put("'m", new String[]{"m"});
        contractions.put("'re", new String[]{"r"});
        symbols = new HashMap<String, String>();
        symbols.put("@", "at");
        symbols.put("#", "hashtag");
        symbols.put("/", "forward slash");
        symbols.put("%", "per cent");
        symbols.put("+", "plus");
        symbols.put("-", "minus");
        symbols.put("=", "equals");
        symbols.put(">", "greater than");
        symbols.put("<", "less than");
        symbols.put("&", "and");
    }

    public Preprocess() {
        super("Preprocess", MaryDataType.TOKENS, MaryDataType.WORDS, Locale.ENGLISH);
        this.cardinalRule = "%spellout-numbering";
        try {
            this.abbrevMap = Preprocess.loadAbbrevMap();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.expand(doc);
        MaryData result = new MaryData(this.getOutputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    protected void expand(Document doc) throws ParseException, IOException, MaryConfigurationException {
        String whichCurrency = "";
        boolean URLFirst = false;
        boolean isURL = false;
        boolean puncSplit = false;
        boolean dashSplit = false;
        String webEmailTemp = "";
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
        Element t = null;
        while ((t = (Element)tw.nextNode()) != null) {
            if (URLFirst) {
                t = (Element)tw.previousNode();
                URLFirst = false;
            }
            boolean isYear = true;
            boolean splitContraction = false;
            if (MaryDomUtils.hasAncestor((Node)t, (String)"say-as") || t.hasAttribute("ph") || t.hasAttribute("sounds_like")) continue;
            String origText = MaryDomUtils.tokenText((Element)t);
            if (MaryDomUtils.tokenText((Element)t).matches("[\\$|\u00a3|\u20ac]?\\d+,[\\d,]+")) {
                MaryDomUtils.setTokenText((Element)t, (String)MaryDomUtils.tokenText((Element)t).replaceAll(",", ""));
                if (MaryDomUtils.tokenText((Element)t).matches("\\d{4}")) {
                    isYear = false;
                }
            }
            if (MaryDomUtils.tokenText((Element)t).matches("\\d{4}") && !whichCurrency.equals("")) {
                isYear = false;
            }
            if (MaryDomUtils.tokenText((Element)t).matches(currencySymbPattern.pattern())) {
                whichCurrency = MaryDomUtils.tokenText((Element)t);
            }
            if (MaryDomUtils.tokenText((Element)t).matches("(?i)" + ordinalPattern.pattern())) {
                String matched = MaryDomUtils.tokenText((Element)t).split("(?i)st|nd|rd|th")[0];
                MaryDomUtils.setTokenText((Element)t, (String)this.expandOrdinal(Double.parseDouble(matched)));
            } else if (MaryDomUtils.tokenText((Element)t).matches("[aA]")) {
                Element checkNextNode = MaryDomUtils.getNextSiblingElement((Element)t);
                if (checkNextNode == null || MaryDomUtils.tokenText((Element)checkNextNode).matches(myPunctPattern.pattern()) || MaryDomUtils.tokenText((Element)checkNextNode).length() == 1) {
                    MaryDomUtils.setTokenText((Element)t, (String)"_a");
                }
            } else if (MaryDomUtils.tokenText((Element)t).matches(datePattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandDate(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches(numberSPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandNumberS(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches("(?i)" + yearPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandYearBCAD(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches("\\d{4}") && isYear) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandYear(Double.parseDouble(MaryDomUtils.tokenText((Element)t))));
            } else if (MaryDomUtils.tokenText((Element)t).matches(numberWordPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandWordNumber(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches(realNumPattern.pattern())) {
                if (!whichCurrency.equals("")) {
                    MaryDomUtils.setTokenText((Element)t, (String)this.expandMoney(MaryDomUtils.tokenText((Element)t), whichCurrency));
                    whichCurrency = "";
                } else {
                    MaryDomUtils.setTokenText((Element)t, (String)this.expandRealNumber(MaryDomUtils.tokenText((Element)t)));
                }
            } else if (MaryDomUtils.tokenText((Element)t).matches(contractPattern.pattern())) {
                if (MaryRuntimeUtils.checkLexicon((String)"en_US", (String)MaryDomUtils.tokenText((Element)t)).length == 0) {
                    Matcher contractionMatch = contractPattern.matcher(MaryDomUtils.tokenText((Element)t));
                    contractionMatch.find();
                    if (!contractions.containsKey(contractionMatch.group(1))) {
                        MaryDomUtils.setTokenText((Element)t, (String)MaryDomUtils.tokenText((Element)t).replaceAll("'", ""));
                    }
                }
            } else if (MaryDomUtils.tokenText((Element)t).matches(acronymPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandAcronym(MaryDomUtils.tokenText((Element)t)));
            } else if ((MaryDomUtils.tokenText((Element)t).matches(abbrevPattern.pattern()) || this.abbrevMap.containsKey(MaryDomUtils.tokenText((Element)t).toLowerCase())) && !isURL) {
                Element testAbbNode = MaryDomUtils.getNextSiblingElement((Element)t);
                boolean nextTokenIsCapital = false;
                if (testAbbNode != null && Character.isUpperCase(MaryDomUtils.tokenText((Element)testAbbNode).charAt(0))) {
                    nextTokenIsCapital = true;
                }
                MaryDomUtils.setTokenText((Element)t, (String)this.expandAbbreviation(MaryDomUtils.tokenText((Element)t), nextTokenIsCapital));
            } else if (MaryDomUtils.tokenText((Element)t).matches("(?i)" + timePattern.pattern())) {
                Element testTimeNode = MaryDomUtils.getNextSiblingElement((Element)t);
                boolean nextTokenIsTime = false;
                if (testTimeNode != null && MaryDomUtils.tokenText((Element)testTimeNode).matches("a\\.m\\.|AM|PM|am|pm|p\\.m\\.")) {
                    nextTokenIsTime = true;
                }
                MaryDomUtils.setTokenText((Element)t, (String)this.expandTime(MaryDomUtils.tokenText((Element)t), nextTokenIsTime));
            } else if (MaryDomUtils.tokenText((Element)t).matches(durationPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandDuration(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches(hashtagPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandHashtag(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches(URLPattern.pattern())) {
                Matcher urlMatcher = URLPattern.matcher(MaryDomUtils.tokenText((Element)t));
                urlMatcher.find();
                webEmailTemp = MaryDomUtils.tokenText((Element)t);
                isURL = true;
                MaryDomUtils.setTokenText((Element)t, (String)this.expandURL(urlMatcher.group(2)));
            } else if (MaryDomUtils.tokenText((Element)t).equals(".") && isURL) {
                MaryDomUtils.setTokenText((Element)t, (String)"dot");
                webEmailTemp = webEmailTemp.replaceFirst("\\.", "dot");
                if (!webEmailTemp.contains(".")) {
                    isURL = false;
                }
            } else if (MaryDomUtils.tokenText((Element)t).matches(symbolsPattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)symbols.get(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).matches(rangePattern.pattern())) {
                MaryDomUtils.setTokenText((Element)t, (String)this.expandRange(MaryDomUtils.tokenText((Element)t)));
            } else if (MaryDomUtils.tokenText((Element)t).contains("-") || MaryDomUtils.tokenText((Element)t).contains("_")) {
                dashSplit = true;
                Object[] tokens = MaryDomUtils.tokenText((Element)t).split("[-_]");
                int i = 0;
                Object[] objectArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tok = objectArray[n2];
                    if (((String)tok).matches("\\d+")) {
                        String newTok = "";
                        char[] cArray = ((String)tok).toCharArray();
                        int n3 = cArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            char c = cArray[n4];
                            newTok = String.valueOf(newTok) + this.expandNumber(Double.parseDouble(String.valueOf(c))) + " ";
                            ++n4;
                        }
                        tokens[i] = newTok;
                    }
                    ++i;
                    ++n2;
                }
                MaryDomUtils.setTokenText((Element)t, (String)Arrays.toString(tokens).replaceAll("[,\\]\\[]", ""));
            } else if (MaryDomUtils.tokenText((Element)t).matches("(?i)" + consonantPattern.pattern())) {
                if (MaryRuntimeUtils.checkLexicon((String)"en_US", (String)MaryDomUtils.tokenText((Element)t)).length == 0) {
                    MaryDomUtils.setTokenText((Element)t, (String)this.expandConsonants(MaryDomUtils.tokenText((Element)t)));
                }
            } else if (punctuationPattern.matcher(MaryDomUtils.tokenText((Element)t)).find() && MaryDomUtils.tokenText((Element)t).length() > 1) {
                puncSplit = true;
                Object[] puncTokens = MaryDomUtils.tokenText((Element)t).split("((?<=\\p{Punct})|(?=\\p{Punct}))");
                MaryDomUtils.setTokenText((Element)t, (String)Arrays.toString(puncTokens).replaceAll("[,\\]\\[]", ""));
            } else if (!MaryDomUtils.tokenText((Element)t).equals("\"") && MaryDomUtils.tokenText((Element)t).matches(punctuationPattern.pattern())) {
                t.setAttribute("pos", ".");
            }
            if (origText.equals(MaryDomUtils.tokenText((Element)t))) continue;
            MaryDomUtils.encloseWithMTU((Element)t, (String)origText, null);
            String[] newTokens = MaryDomUtils.tokenText((Element)t).replaceAll("-", " ").split("\\s+");
            MaryDomUtils.setTokenText((Element)t, (String)newTokens[0]);
            int i = 1;
            while (i < newTokens.length) {
                MaryDomUtils.appendToken((Element)t, (String)newTokens[i]);
                t = MaryDomUtils.getNextSiblingElement((Element)t);
                if (splitContraction && newTokens.length == 2) {
                    if (newTokens[0].substring(newTokens[0].length() - 1).matches("[cfkpt]") && contractions.get(newTokens[i]).length > 1) {
                        t.setAttribute("ph", contractions.get(newTokens[i])[1]);
                    } else {
                        t.setAttribute("ph", contractions.get(newTokens[i])[0]);
                    }
                }
                ++i;
            }
            if (!(isURL || puncSplit || dashSplit)) {
                tw.setCurrentNode(t);
                continue;
            }
            Node n = tw.previousNode();
            if (n == null) {
                URLFirst = true;
            }
            puncSplit = false;
            dashSplit = false;
        }
    }

    protected String expandNumber(double number) {
        this.rbnf.setDefaultRuleSet(this.cardinalRule);
        return this.rbnf.format(number);
    }

    protected String expandOrdinal(double number) {
        this.rbnf.setDefaultRuleSet(this.ordinalRule);
        return this.rbnf.format(number);
    }

    protected String expandYear(double number) {
        this.rbnf.setDefaultRuleSet(this.yearRule);
        return this.rbnf.format(number);
    }

    protected String expandDuration(String duration) {
        Matcher durMatcher = durationPattern.matcher(duration);
        durMatcher.find();
        String hrs = String.valueOf(this.expandNumber(Double.parseDouble(durMatcher.group(1)))) + " hours ";
        String mins = String.valueOf(this.expandNumber(Double.parseDouble(durMatcher.group(2)))) + " minutes ";
        String secs = String.valueOf(this.expandNumber(Double.parseDouble(durMatcher.group(3)))) + " seconds ";
        String ms = "";
        if (durMatcher.group(4) != null) {
            ms = "and " + this.expandNumber(Double.parseDouble(durMatcher.group(5))) + " milliseconds ";
        } else {
            secs = "and " + secs;
        }
        return String.valueOf(hrs) + mins + secs + ms;
    }

    protected String expandAcronym(String acronym) {
        return acronym.replaceAll("\\.", " ");
    }

    protected String expandURL(String email) {
        Object[] tokens = email.split("((?<=[\\.@\\/])|(?=[\\.@\\/]))");
        return Arrays.toString(tokens).replaceAll("[,\\]\\[]", "");
    }

    protected String expandYearBCAD(String year) {
        String abbrev = "";
        Matcher yearMatcher = yearPattern.matcher(year);
        yearMatcher.find();
        if (yearMatcher.group(2).contains(".")) {
            Object[] abbrevAr = yearMatcher.group(2).split("\\.");
            abbrev = Arrays.toString(abbrevAr).replaceAll("[,\\]\\[]", "");
        } else {
            abbrev = this.expandConsonants(yearMatcher.group(2));
        }
        return String.valueOf(this.expandYear(Double.parseDouble(yearMatcher.group(1)))) + " " + abbrev;
    }

    protected String expandConsonants(String consonants) {
        return Joiner.on((String)" ").join((Iterable)Lists.charactersOf((String)consonants));
    }

    protected String expandHashtag(String hashtag) {
        String tag = "";
        String expandedTag = "";
        Matcher hashTagMatcher = hashtagPattern.matcher(hashtag);
        hashTagMatcher.find();
        tag = hashTagMatcher.group(2);
        if (!tag.matches("[a-z]+") || !tag.matches("[A-Z]+")) {
            String temp = "";
            char[] cArray = tag.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                temp = Character.isDigit(c) && temp.matches("^$|[0-9]+") ? String.valueOf(temp) + c : (Character.isDigit(c) && temp.matches(".+[0-9]") ? String.valueOf(temp) + c : (Character.isDigit(c) ? String.valueOf(temp) + " " + c : (!temp.equals("") && Character.isUpperCase(c) ? (Character.isUpperCase(temp.charAt(temp.length() - 1)) ? String.valueOf(temp) + c : String.valueOf(temp) + " " + c) : (Character.isAlphabetic(c) && temp.length() > 0 ? (Character.isDigit(temp.charAt(temp.length() - 1)) ? String.valueOf(temp) + " " + c : String.valueOf(temp) + c) : String.valueOf(temp) + c))));
                ++n2;
            }
            expandedTag = temp;
        } else {
            expandedTag = tag;
        }
        return String.valueOf(symbols.get(hashTagMatcher.group(1))) + " " + expandedTag;
    }

    protected String expandRange(String range) {
        Matcher rangeMatcher = rangePattern.matcher(range);
        rangeMatcher.find();
        return String.valueOf(this.expandNumber(Double.parseDouble(rangeMatcher.group(1)))) + " to " + this.expandNumber(Double.parseDouble(rangeMatcher.group(2)));
    }

    protected String expandNumberS(String numberS) {
        Matcher numberSMatcher = numberSPattern.matcher(numberS);
        numberSMatcher.find();
        String number = this.expandNumber(Double.parseDouble(numberSMatcher.group(1)));
        number = number.endsWith("x") ? String.valueOf(number) + "es" : (number.endsWith("y") ? number.replace("y", "ies") : String.valueOf(number) + "s");
        return number;
    }

    protected String splitContraction(String contraction) {
        int aposIndex = contraction.indexOf("'");
        String lemma = contraction.substring(0, aposIndex);
        String end = contraction.substring(aposIndex);
        return String.valueOf(lemma) + " " + end;
    }

    protected String expandAbbreviation(String abbrev, boolean isCapital) {
        String expAbb = abbrev.replaceAll("\\.", "").toLowerCase();
        if (!this.abbrevMap.containsKey(expAbb)) {
            this.logger.warn((Object)String.format("Could not expand unknown abbreviation \"%s\", ignoring", abbrev));
            return abbrev;
        }
        String[] multiExp = (expAbb = (String)this.abbrevMap.get(expAbb)).split(",");
        if (multiExp.length > 1) {
            expAbb = isCapital ? multiExp[0] : multiExp[1];
        }
        return expAbb;
    }

    protected String expandDate(String date) throws ParseException {
        Date humanDate = DateFormat.getPatternInstance((String)"MM.dd.yyyy", (ULocale)ULocale.ENGLISH).parse(date);
        Object[] dateParts = this.df.format(humanDate).replaceAll(",", "").split("\\s");
        dateParts[1] = this.expandOrdinal(Double.parseDouble(dateParts[1]));
        dateParts[2] = this.expandYear(Double.parseDouble(dateParts[2]));
        return Arrays.toString(dateParts).replaceAll("[,\\]\\[]", "");
    }

    protected String expandTime(String time, boolean isNextTokenTime) {
        boolean pastNoon = false;
        String theTime = "";
        String hour = "";
        Matcher timeMatch = timePattern.matcher(time);
        timeMatch.find();
        if (timeMatch.group(2) != null || timeMatch.group(3) != null) {
            String string = hour = timeMatch.group(2) != null ? timeMatch.group(2) : timeMatch.group(3);
            if (hour.equals("00")) {
                hour = "12";
            }
            theTime = String.valueOf(theTime) + this.expandNumber(Double.parseDouble(hour));
        } else {
            pastNoon = true;
            hour = timeMatch.group(4) != null ? timeMatch.group(4) : timeMatch.group(5);
            Double pmHour = Double.parseDouble(hour) - 12.0;
            if (pmHour == 0.0) {
                hour = "12";
                theTime = String.valueOf(theTime) + this.expandNumber(Double.parseDouble(hour));
            } else {
                theTime = String.valueOf(theTime) + this.expandNumber(pmHour);
            }
        }
        if (timeMatch.group(7) != null && !isNextTokenTime) {
            if (!timeMatch.group(6).equals("00")) {
                theTime = timeMatch.group(6).matches("0\\d") ? String.valueOf(theTime) + " oh " + this.expandNumber(Double.parseDouble(timeMatch.group(6))) : String.valueOf(theTime) + " " + this.expandNumber(Double.parseDouble(timeMatch.group(6)));
            }
            char[] cArray = timeMatch.group(7).replaceAll("\\.", "").toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                theTime = String.valueOf(theTime) + " " + c;
                ++n2;
            }
        } else if (!isNextTokenTime) {
            if (!timeMatch.group(6).equals("00")) {
                theTime = timeMatch.group(6).matches("0\\d") ? String.valueOf(theTime) + " oh " + this.expandNumber(Double.parseDouble(timeMatch.group(6))) : String.valueOf(theTime) + " " + this.expandNumber(Double.parseDouble(timeMatch.group(6)));
            }
            theTime = String.valueOf(theTime) + (!pastNoon ? " a m" : " p m");
        } else if (!timeMatch.group(6).equals("00")) {
            theTime = timeMatch.group(6).matches("0\\d") ? String.valueOf(theTime) + " oh " + this.expandNumber(Double.parseDouble(timeMatch.group(6))) : String.valueOf(theTime) + " " + this.expandNumber(Double.parseDouble(timeMatch.group(6)));
        }
        return theTime;
    }

    protected String expandRealNumber(String number) {
        Matcher realNumMatch = realNumPattern.matcher(number);
        realNumMatch.find();
        String newTok = "";
        if (realNumMatch.group(1) != null) {
            newTok = String.valueOf(newTok) + "minus ";
        }
        if (realNumMatch.group(2) != null) {
            newTok = String.valueOf(newTok) + this.expandNumber(Double.parseDouble(realNumMatch.group(2))) + " ";
        }
        if (realNumMatch.group(3) != null) {
            newTok = String.valueOf(newTok) + "point ";
            char[] cArray = realNumMatch.group(4).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                newTok = String.valueOf(newTok) + this.expandNumber(Double.parseDouble(String.valueOf(c))) + " ";
                ++n2;
            }
            if (realNumMatch.group(5) != null) {
                newTok = String.valueOf(newTok) + "per cent";
            }
        }
        return newTok.trim();
    }

    protected String expandWordNumber(String wordnumseq) {
        Object[] groups = wordnumseq.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
        int i = 0;
        Object[] objectArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Object g = objectArray[n2];
            if (((String)g).matches("\\d+")) {
                String newTok = "";
                char[] cArray = ((String)g).toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c = cArray[n4];
                    newTok = String.valueOf(newTok) + this.expandNumber(Double.parseDouble(String.valueOf(c))) + " ";
                    ++n4;
                }
                groups[i] = newTok;
            }
            ++i;
            ++n2;
        }
        return Arrays.toString(groups).replaceAll("[,\\]\\[]", "");
    }

    protected String expandMoney(String money, String currency) {
        String origText = money;
        Matcher currencyMatch = moneyPattern.matcher(money);
        currencyMatch.find();
        switch (currency) {
            case "$": {
                money = Double.parseDouble(currencyMatch.group(1)) > 1.0 ? String.valueOf(this.expandNumber(Double.parseDouble(currencyMatch.group(1)))) + " dollars" : String.valueOf(this.expandNumber(Double.parseDouble(currencyMatch.group(1)))) + " dollar";
                if (currencyMatch.group(2) == null) break;
                int dotIndex = origText.indexOf(46);
                money = String.valueOf(money) + " " + this.expandNumber(Double.parseDouble(origText.substring(dotIndex + 1))) + " cents";
                break;
            }
            case "\u00a3": {
                money = String.valueOf(this.expandNumber(Double.parseDouble(currencyMatch.group(1)))) + " pound sterling";
                if (currencyMatch.group(2) == null) break;
                int dotIndex = origText.indexOf(46);
                money = String.valueOf(money) + " " + this.expandNumber(Double.parseDouble(origText.substring(dotIndex + 1))) + " pence";
                break;
            }
            case "\u20ac": {
                money = String.valueOf(this.expandNumber(Double.parseDouble(currencyMatch.group(1)))) + " euro";
                if (currencyMatch.group(2) == null) break;
                int dotIndex = origText.indexOf(46);
                money = String.valueOf(money) + " " + this.expandNumber(Double.parseDouble(origText.substring(dotIndex + 1))) + " cents";
                break;
            }
        }
        return money;
    }

    protected static String getOrdinalRuleName(RuleBasedNumberFormat rbnf) {
        List<String> l = Arrays.asList(rbnf.getRuleSetNames());
        if (l.contains("%spellout-ordinal")) {
            return "%spellout-ordinal";
        }
        if (l.contains("%spellout-ordinal-masculine")) {
            return "%spellout-ordinal-masculine";
        }
        for (String string : l) {
            if (!string.startsWith("%spellout-ordinal")) continue;
            return string;
        }
        throw new UnsupportedOperationException("The locale " + rbnf.getLocale(ULocale.ACTUAL_LOCALE) + " doesn't support ordinal spelling.");
    }

    protected static String getYearRuleName(RuleBasedNumberFormat rbnf) {
        List<String> l = Arrays.asList(rbnf.getRuleSetNames());
        if (l.contains("%spellout-numbering-year")) {
            return "%spellout-numbering-year";
        }
        for (String string : l) {
            if (!string.startsWith("%spellout-numbering-year")) continue;
            return string;
        }
        throw new UnsupportedOperationException("The locale " + rbnf.getLocale(ULocale.ACTUAL_LOCALE) + " doesn't support year spelling.");
    }

    public static Map<Object, Object> loadAbbrevMap() throws IOException {
        Properties abbMap = new Properties();
        abbMap.load(Preprocess.class.getResourceAsStream("preprocess/abbrev.dat"));
        return abbMap;
    }
}

