/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer;

import de.dfki.lt.tools.tokenizer.AbbrevDescription;
import de.dfki.lt.tools.tokenizer.CliticsDescription;
import de.dfki.lt.tools.tokenizer.FileTools;
import de.dfki.lt.tools.tokenizer.NumbersDescription;
import de.dfki.lt.tools.tokenizer.PunctDescription;
import de.dfki.lt.tools.tokenizer.exceptions.InitializationException;
import de.dfki.lt.tools.tokenizer.exceptions.ProcessingException;
import de.dfki.lt.tools.tokenizer.regexp.RegExp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LanguageResource {
    private static final String CLASSES_HIERARCHY = "_classes.xml";
    private static final String PUNCT_DESCR = "_punct.xml";
    private static final String CLITIC_DESCR = "_clitics.xml";
    private static final String ABBREV_DESCR = "_abbrev.xml";
    private static final String NUMB_DESCR = "_numbers.xml";
    private static final String CLASS_TAG = "tag";
    private String language;
    private Element classesRoot;
    private HashMap ancestorsMap;
    private HashMap tagsMap;
    private HashMap classesMap;
    private PunctDescription punctDescr;
    private CliticsDescription clitDescr;
    private AbbrevDescription abbrevDescr;
    private NumbersDescription numbDescr;

    private LanguageResource() {
        this.setClassesRoot(null);
        this.setAncestorsMap(new HashMap());
        this.setTagsMap(new HashMap());
        this.setClassesMap(new HashMap());
        this.setPunctDescr(null);
        this.setClitDescr(null);
        this.setAbbrevDescr(null);
        this.setNumbDescr(null);
    }

    public LanguageResource(String aLanguage, String aResourceDir) {
        this();
        this.setLanguage(aLanguage);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(FileTools.openResourceFileAsStream(aResourceDir + "/" + aLanguage + CLASSES_HIERARCHY));
            this.setClassesRoot(doc.getDocumentElement());
            this.mapSingleClass(this.getClassesRoot());
            this.mapClasses(this.getClassesRoot().getChildNodes());
            doc = builder.parse(FileTools.openResourceFileAsStream(aResourceDir + "/" + aLanguage + PUNCT_DESCR));
            this.setPunctDescr(new PunctDescription(doc, this.getTagsMap().keySet()));
            doc = builder.parse(FileTools.openResourceFileAsStream(aResourceDir + "/" + aLanguage + CLITIC_DESCR));
            this.setClitDescr(new CliticsDescription(doc, this.getTagsMap().keySet()));
            doc = builder.parse(FileTools.openResourceFileAsStream(aResourceDir + "/" + aLanguage + ABBREV_DESCR));
            this.setAbbrevDescr(new AbbrevDescription(doc, this.getTagsMap().keySet(), aResourceDir));
            doc = builder.parse(FileTools.openResourceFileAsStream(aResourceDir + "/" + aLanguage + NUMB_DESCR));
            this.setNumbDescr(new NumbersDescription(doc, this.getTagsMap().keySet()));
        }
        catch (SAXException spe) {
            throw new InitializationException(spe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new InitializationException(pce.getMessage());
        }
        catch (IOException ioe) {
            throw new InitializationException(ioe.getMessage());
        }
    }

    public String getLanguage() {
        return this.language;
    }

    private void setLanguage(String aLanguage) {
        this.language = aLanguage;
    }

    Element getClassesRoot() {
        return this.classesRoot;
    }

    void setClassesRoot(Element aClassesRoot) {
        this.classesRoot = aClassesRoot;
    }

    HashMap getAncestorsMap() {
        return this.ancestorsMap;
    }

    void setAncestorsMap(HashMap anAncestorsMap) {
        this.ancestorsMap = anAncestorsMap;
    }

    public HashMap getTagsMap() {
        return this.tagsMap;
    }

    void setTagsMap(HashMap aTagsMap) {
        this.tagsMap = aTagsMap;
    }

    HashMap getClassesMap() {
        return this.classesMap;
    }

    void setClassesMap(HashMap aClassesMap) {
        this.classesMap = aClassesMap;
    }

    PunctDescription getPunctDescr() {
        return this.punctDescr;
    }

    void setPunctDescr(PunctDescription aPunctDescr) {
        this.punctDescr = aPunctDescr;
    }

    CliticsDescription getClitDescr() {
        return this.clitDescr;
    }

    void setClitDescr(CliticsDescription aClitDescr) {
        this.clitDescr = aClitDescr;
    }

    AbbrevDescription getAbbrevDescr() {
        return this.abbrevDescr;
    }

    void setAbbrevDescr(AbbrevDescription anAbbrevDescr) {
        this.abbrevDescr = anAbbrevDescr;
    }

    NumbersDescription getNumbDescr() {
        return this.numbDescr;
    }

    void setNumbDescr(NumbersDescription aNumbDescr) {
        this.numbDescr = aNumbDescr;
    }

    private void mapClasses(NodeList elementList) {
        int iMax = elementList.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node oneObj = elementList.item(i);
            if (!(oneObj instanceof Element)) continue;
            Element oneEle = (Element)oneObj;
            this.mapSingleClass(oneEle);
            if (oneEle.getChildNodes().getLength() <= 0) continue;
            this.mapClasses(oneEle.getChildNodes());
        }
    }

    private void mapSingleClass(Element oneEle) {
        String key = oneEle.getTagName();
        String tag = oneEle.getAttribute(CLASS_TAG);
        this.getTagsMap().put(key, tag);
        this.getClassesMap().put(tag, key);
        ArrayList<String> ancestors = new ArrayList<String>();
        ancestors.add(oneEle.getTagName());
        for (Node directAncestor = oneEle.getParentNode(); null != directAncestor && directAncestor instanceof Element; directAncestor = directAncestor.getParentNode()) {
            ancestors.add(((Element)directAncestor).getTagName());
        }
        this.getAncestorsMap().put(key, ancestors);
    }

    boolean isAncestor(String class1, String class2) throws ProcessingException {
        List ancestors = (List)this.getAncestorsMap().get(class2);
        if (null == ancestors) {
            throw new ProcessingException("undefined token class " + class2);
        }
        return ancestors.contains(class1);
    }

    RegExp getAllPunctMatcher() {
        return (RegExp)this.getPunctDescr().getRulesMap().get("ALL_PUNCT_RULE");
    }

    RegExp getNbrMatcher() {
        return (RegExp)this.getPunctDescr().getRulesMap().get("NON_BREAKING_RIGHT_PUNCT_RULE");
    }

    RegExp getNblMatcher() {
        return (RegExp)this.getPunctDescr().getRulesMap().get("NON_BREAKING_LEFT_PUNCT_RULE");
    }

    RegExp getInternalMatcher() {
        return (RegExp)this.getPunctDescr().getRulesMap().get("INTERNAL_PUNCT_RULE");
    }

    RegExp getInternalTuMatcher() {
        return (RegExp)this.getPunctDescr().getRulesMap().get("INTERNAL_TU_PUNCT_RULE");
    }

    RegExp getCliticsMatcher() {
        return (RegExp)this.getPunctDescr().getRulesMap().get("CLITIC_PUNCT_RULE");
    }

    RegExp getProcliticsMatcher() {
        return (RegExp)this.getClitDescr().getRulesMap().get("PROCLITIC_RULE");
    }

    RegExp getEncliticsMatcher() {
        return (RegExp)this.getClitDescr().getRulesMap().get("ENCLITIC_RULE");
    }

    HashMap getAbbrevLists() {
        return this.getAbbrevDescr().getListsMap();
    }

    RegExp getAbbrevMatcher() {
        return (RegExp)this.getAbbrevDescr().getRulesMap().get("ABBREV_RULE");
    }

    RegExp getInitialMatcher() {
        return (RegExp)this.getAbbrevDescr().getRulesMap().get("INITIAL_RULE");
    }

    Set<String> getNonCapTerms() {
        return this.getAbbrevDescr().getNonCapTerms();
    }

    RegExp getSimpleDigitsMatcher() {
        return (RegExp)this.getNumbDescr().getRulesMap().get("SIMPLE_DIGITS_RULE");
    }

    RegExp getOrdinalMatcher() {
        return (RegExp)this.getNumbDescr().getRulesMap().get("ORDINAL_RULE");
    }

    RegExp getDigitsMatcher() {
        return (RegExp)this.getNumbDescr().getRulesMap().get("DIGITS_RULE");
    }
}

