/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;
import marytts.cart.CART;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.io.WagonCARTReader;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.select.Target;

public class StringPredictionTree
extends CART {
    public static final String ENC_LINE_START = ";;target={";
    public static final String ENC_LINE_END = "}\n";
    String[] stringIdDecoding;
    Pattern splitPattern = Pattern.compile("'");
    Pattern delimPattern = Pattern.compile(",\\d+:|}$");

    public StringPredictionTree(Node aRootNode, FeatureDefinition aFeatDef, String[] aTargetDecoding) {
        if (!aRootNode.isRoot()) {
            throw new IllegalArgumentException("Tried to set a non-root-node as root of the tree. ");
        }
        this.rootNode = aRootNode;
        this.featDef = aFeatDef;
        this.stringIdDecoding = aTargetDecoding;
    }

    public StringPredictionTree(BufferedReader reader, FeatureDefinition featDefinition) throws IOException {
        String line = reader.readLine();
        if (line.equals("")) {
            line = reader.readLine();
        }
        if (line.startsWith(ENC_LINE_START)) {
            String rawLine = line.substring(";;target={0:'".length());
            String[] splitted = this.splitPattern.split(rawLine);
            this.stringIdDecoding = new String[splitted.length / 2];
            int i = 0;
            while (i < splitted.length / 2) {
                this.stringIdDecoding[i] = splitted[i * 2];
                if (!this.delimPattern.matcher(splitted[i * 2 + 1]).matches()) {
                    throw new IllegalArgumentException("wrong encoding for the mapping of numbers and strings.");
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("First line must be a comment line specifying the target symbols.");
        }
        WagonCARTReader wagonReader = new WagonCARTReader(LeafNode.LeafType.IntAndFloatArrayLeafNode);
        this.setRootNode(wagonReader.load(reader, featDefinition));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ENC_LINE_START);
        int i = 0;
        while (i < this.stringIdDecoding.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(i);
            sb.append(":'");
            sb.append(this.stringIdDecoding[i]);
            sb.append("'");
            ++i;
        }
        sb.append(ENC_LINE_END);
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public Node interpretToNode(FeatureVector featureVector, int minNumberOfData) {
        Node currentNode = this.rootNode;
        Node prevNode = null;
        while (currentNode.getNumberOfData() > minNumberOfData && !(currentNode instanceof LeafNode)) {
            prevNode = currentNode;
            currentNode = ((DecisionNode)currentNode).getNextNode(featureVector);
        }
        if (currentNode.getNumberOfData() < minNumberOfData && prevNode != null) {
            currentNode = prevNode;
        }
        assert (currentNode.getNumberOfData() >= minNumberOfData || currentNode == this.rootNode);
        return currentNode;
    }

    public String getMostProbableString(FeatureVector aFV) {
        LeafNode.IntAndFloatArrayLeafNode predictedNode = (LeafNode.IntAndFloatArrayLeafNode)this.interpretToNode(aFV, -1);
        float[] probs = predictedNode.getFloatData();
        int[] indices = predictedNode.getIntData();
        int bestInd = 0;
        float maxProb = 0.0f;
        int i = 0;
        while (i < indices.length) {
            if (probs[i] > maxProb) {
                maxProb = probs[i];
                bestInd = indices[i];
            }
            ++i;
        }
        if (bestInd >= this.stringIdDecoding.length) {
            this.logger.info("looking up most probable string for feature vector");
            this.logger.error("index bigger than number of targets");
            this.logger.info("biggest index is " + (this.stringIdDecoding.length - 1) + "with the symbol" + this.stringIdDecoding[this.stringIdDecoding.length - 1]);
        }
        return this.stringIdDecoding[bestInd];
    }

    public String getMostProbableString(Target aTarget) {
        return this.getMostProbableString(aTarget.getFeatureVector());
    }
}

