/*
 * Decompiled with CFR 0.152.
 */
package marytts.datatypes;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MaryXML {
    public static final String MARYXML = "maryxml";
    public static final String PARAGRAPH = "p";
    public static final String SENTENCE = "s";
    public static final String VOICE = "voice";
    public static final String PHRASE = "phrase";
    public static final String MARK = "mark";
    public static final String SAYAS = "say-as";
    public static final String PHONOLOGY = "phonology";
    public static final String PROSODY = "prosody";
    public static final String AUDIO = "audio";
    public static final String BOUNDARY = "boundary";
    public static final String MTU = "mtu";
    public static final String TOKEN = "t";
    public static final String SYLLABLE = "syllable";
    public static final String PHONE = "ph";
    public static final String NONVERBAL = "vocalization";
    private static String version = "0.5";
    private static String namespace = "http://mary.dfki.de/2002/MaryXML";
    private static Logger logger = MaryUtils.getLogger("MaryXML");
    private static DocumentBuilder docBuilder = null;

    static {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(true);
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("Cannot start up XML parser", e);
        }
    }

    public static String getVersion() {
        return version;
    }

    public static String getNamespace() {
        return namespace;
    }

    public static String getRootTagname() {
        return MARYXML;
    }

    public static Document newDocument() {
        Document doc = docBuilder.getDOMImplementation().createDocument(MaryXML.getNamespace(), MaryXML.getRootTagname(), null);
        Element root = doc.getDocumentElement();
        root.setAttribute("version", MaryXML.getVersion());
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return doc;
    }

    public static Element createElement(Document doc, String elementName) {
        if (doc == null) {
            throw new NullPointerException("Received null document");
        }
        if (!doc.getDocumentElement().getTagName().equals(MaryXML.getRootTagname())) {
            throw new IllegalArgumentException("Not a maryxml document: " + doc.getDocumentElement().getTagName());
        }
        if (doc.getDocumentElement().getNamespaceURI() == null) {
            throw new IllegalArgumentException("Document has no namespace!");
        }
        if (!doc.getDocumentElement().getNamespaceURI().equals(MaryXML.getNamespace())) {
            throw new IllegalArgumentException("Document has wrong namespace: " + doc.getDocumentElement().getNamespaceURI());
        }
        return doc.createElementNS(MaryXML.getNamespace(), elementName);
    }

    public static Element appendChildElement(Node node, String childName) {
        if (node == null) {
            throw new NullPointerException("Received null node");
        }
        return (Element)node.appendChild(MaryXML.createElement(node.getOwnerDocument(), childName));
    }
}

