/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import marytts.features.ByteValuedFeatureProcessor;
import marytts.features.ContinuousFeatureProcessor;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureVector;
import marytts.features.MaryFeatureProcessor;
import marytts.features.MaryLanguageFeatureProcessors;
import marytts.features.ShortValuedFeatureProcessor;
import marytts.unitselection.select.Target;

public class TargetFeatureComputer {
    protected ByteValuedFeatureProcessor[] byteValuedDiscreteFeatureProcessors;
    protected ShortValuedFeatureProcessor[] shortValuedDiscreteFeatureProcessors;
    protected ContinuousFeatureProcessor[] continuousFeatureProcessors;
    protected String pauseSymbol = null;
    protected FeatureDefinition featureDefinition = null;

    public TargetFeatureComputer(FeatureProcessorManager manager, String featureProcessorNames) {
        ArrayList<MaryFeatureProcessor> byteValuedFeatureProcessors = new ArrayList<MaryFeatureProcessor>();
        ArrayList<MaryFeatureProcessor> shortValuedFeatureProcessors = new ArrayList<MaryFeatureProcessor>();
        ArrayList<MaryFeatureProcessor> continuousValuedFeatureProcessors = new ArrayList<MaryFeatureProcessor>();
        StringTokenizer st = new StringTokenizer(featureProcessorNames);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            MaryFeatureProcessor fp = manager.getFeatureProcessor(name);
            if (fp == null) {
                throw new IllegalArgumentException("Unknown feature processor: " + name);
            }
            if (fp instanceof ByteValuedFeatureProcessor) {
                byteValuedFeatureProcessors.add(fp);
                continue;
            }
            if (fp instanceof ShortValuedFeatureProcessor) {
                shortValuedFeatureProcessors.add(fp);
                continue;
            }
            if (fp instanceof ContinuousFeatureProcessor) {
                continuousValuedFeatureProcessors.add(fp);
                continue;
            }
            throw new IllegalArgumentException("Unknown feature processor type " + fp.getClass() + " for feature processor: " + name);
        }
        this.byteValuedDiscreteFeatureProcessors = byteValuedFeatureProcessors.toArray(new ByteValuedFeatureProcessor[0]);
        this.shortValuedDiscreteFeatureProcessors = shortValuedFeatureProcessors.toArray(new ShortValuedFeatureProcessor[0]);
        this.continuousFeatureProcessors = continuousValuedFeatureProcessors.toArray(new ContinuousFeatureProcessor[0]);
    }

    public FeatureDefinition getFeatureDefinition() {
        if (this.featureDefinition == null) {
            String v;
            int n;
            int n2;
            String[] stringArray;
            String[] values;
            StringBuilder sb = new StringBuilder();
            sb.append("ByteValuedFeatureProcessors").append("\n");
            int i = 0;
            while (i < this.byteValuedDiscreteFeatureProcessors.length) {
                sb.append(this.byteValuedDiscreteFeatureProcessors[i].getName());
                stringArray = values = this.byteValuedDiscreteFeatureProcessors[i].getValues();
                n2 = values.length;
                n = 0;
                while (n < n2) {
                    v = stringArray[n];
                    sb.append(" ").append(v);
                    ++n;
                }
                sb.append("\n");
                ++i;
            }
            sb.append("ShortValuedFeatureProcessors").append("\n");
            i = 0;
            while (i < this.shortValuedDiscreteFeatureProcessors.length) {
                sb.append(this.shortValuedDiscreteFeatureProcessors[i].getName());
                stringArray = values = this.shortValuedDiscreteFeatureProcessors[i].getValues();
                n2 = values.length;
                n = 0;
                while (n < n2) {
                    v = stringArray[n];
                    sb.append(" ").append(v);
                    ++n;
                }
                sb.append("\n");
                ++i;
            }
            sb.append("ContinuousFeatureProcessors").append("\n");
            i = 0;
            while (i < this.continuousFeatureProcessors.length) {
                sb.append(this.continuousFeatureProcessors[i].getName()).append("\n");
                ++i;
            }
            BufferedReader reader = new BufferedReader(new StringReader(sb.toString()));
            try {
                this.featureDefinition = new FeatureDefinition(reader, false);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem creating feature definition", e);
            }
        }
        return this.featureDefinition;
    }

    public FeatureVector computeFeatureVector(Target target) {
        byte[] byteFeatures = new byte[this.byteValuedDiscreteFeatureProcessors.length];
        short[] shortFeatures = new short[this.shortValuedDiscreteFeatureProcessors.length];
        float[] floatFeatures = new float[this.continuousFeatureProcessors.length];
        int i = 0;
        while (i < this.byteValuedDiscreteFeatureProcessors.length) {
            byteFeatures[i] = this.byteValuedDiscreteFeatureProcessors[i].process(target);
            ++i;
        }
        i = 0;
        while (i < this.shortValuedDiscreteFeatureProcessors.length) {
            shortFeatures[i] = this.shortValuedDiscreteFeatureProcessors[i].process(target);
            ++i;
        }
        i = 0;
        while (i < this.continuousFeatureProcessors.length) {
            floatFeatures[i] = this.continuousFeatureProcessors[i].process(target);
            ++i;
        }
        return new FeatureVector(byteFeatures, shortFeatures, floatFeatures, 0);
    }

    public String toStringValues(FeatureVector features) {
        StringBuilder buf = new StringBuilder();
        byte[] bytes = features.getByteValuedDiscreteFeatures();
        short[] shorts = features.getShortValuedDiscreteFeatures();
        float[] floats = features.getContinuousFeatures();
        if (bytes.length != this.byteValuedDiscreteFeatureProcessors.length || shorts.length != this.shortValuedDiscreteFeatureProcessors.length || floats.length != this.continuousFeatureProcessors.length) {
            throw new IllegalArgumentException("Number of features in argument does not match number of feature processors");
        }
        int i = 0;
        while (i < bytes.length) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.byteValuedDiscreteFeatureProcessors[i].getValues()[bytes[i] & 0xFF]);
            ++i;
        }
        i = 0;
        while (i < shorts.length) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.shortValuedDiscreteFeatureProcessors[i].getValues()[shorts[i]]);
            ++i;
        }
        i = 0;
        while (i < floats.length) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(floats[i]);
            ++i;
        }
        return buf.toString();
    }

    public ByteValuedFeatureProcessor[] getByteValuedFeatureProcessors() {
        return this.byteValuedDiscreteFeatureProcessors;
    }

    public ShortValuedFeatureProcessor[] getShortValuedFeatureProcessors() {
        return this.shortValuedDiscreteFeatureProcessors;
    }

    public ContinuousFeatureProcessor[] getContinuousFeatureProcessors() {
        return this.continuousFeatureProcessors;
    }

    public String getAllFeatureProcessorNames() {
        return "ByteValuedFeatureProcessors " + this.getByteValuedFeatureProcessorNames() + "\n" + "ShortValuedFeatureProcessors " + this.getShortValuedFeatureProcessorNames() + "\n" + "ContinuousFeatureProcessors " + this.getContinuousFeatureProcessorNames() + "\n";
    }

    public String getByteValuedFeatureProcessorNames() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.byteValuedDiscreteFeatureProcessors.length) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.byteValuedDiscreteFeatureProcessors[i].getName());
            ++i;
        }
        return buf.toString();
    }

    public String getShortValuedFeatureProcessorNames() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.shortValuedDiscreteFeatureProcessors.length) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.shortValuedDiscreteFeatureProcessors[i].getName());
            ++i;
        }
        return buf.toString();
    }

    public String getContinuousFeatureProcessorNames() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.continuousFeatureProcessors.length) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.continuousFeatureProcessors[i].getName());
            ++i;
        }
        return buf.toString();
    }

    public String getAllFeatureProcessorNamesAndValues() {
        return "ByteValuedFeatureProcessors\n" + this.getByteValuedFeatureProcessorNamesAndValues() + "ShortValuedFeatureProcessors" + "\n" + this.getShortValuedFeatureProcessorNamesAndValues() + "ContinuousFeatureProcessors" + "\n" + this.getContinuousFeatureProcessorNamesAndValues();
    }

    public String getByteValuedFeatureProcessorNamesAndValues() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.byteValuedDiscreteFeatureProcessors.length) {
            buf.append(this.byteValuedDiscreteFeatureProcessors[i].getName());
            String[] values = this.byteValuedDiscreteFeatureProcessors[i].getValues();
            int j = 0;
            while (j < values.length) {
                buf.append(" ");
                buf.append(values[j]);
                ++j;
            }
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public String getShortValuedFeatureProcessorNamesAndValues() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.shortValuedDiscreteFeatureProcessors.length) {
            buf.append(this.shortValuedDiscreteFeatureProcessors[i].getName());
            String[] values = this.shortValuedDiscreteFeatureProcessors[i].getValues();
            int j = 0;
            while (j < values.length) {
                buf.append(" ");
                buf.append(values[j]);
                ++j;
            }
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public String getContinuousFeatureProcessorNamesAndValues() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.continuousFeatureProcessors.length) {
            buf.append(this.continuousFeatureProcessors[i].getName());
            buf.append(" float\n");
            ++i;
        }
        return buf.toString();
    }

    public String getPauseSymbol() {
        if (this.pauseSymbol == null) {
            ByteValuedFeatureProcessor[] byteValuedFeatureProcessorArray = this.byteValuedDiscreteFeatureProcessors;
            int n = this.byteValuedDiscreteFeatureProcessors.length;
            int n2 = 0;
            while (n2 < n) {
                ByteValuedFeatureProcessor fp = byteValuedFeatureProcessorArray[n2];
                if (fp instanceof MaryLanguageFeatureProcessors.Phone) {
                    this.pauseSymbol = ((MaryLanguageFeatureProcessors.Phone)fp).getPauseSymbol();
                    break;
                }
                ++n2;
            }
        }
        return this.pauseSymbol;
    }
}

