/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSParameterGeneration;
import marytts.htsengine.HTSUttModel;
import marytts.htsengine.HTSVocoder;
import marytts.modules.HTSEngine;
import marytts.signalproc.analysis.Mfccs;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.data.text.SnackTextfileDoubleDataSource;
import marytts.util.io.LEDataInputStream;
import org.apache.log4j.BasicConfigurator;

public class HTSEngineTest {
    public void synthesisWithContinuousFeatureProcessors() throws Exception {
        String feaFile = "/project/mary/marcela/f0-hsmm-experiment/THAT_BALL.pfeats";
        HTSEngine hmm_tts = new HTSEngine();
        HMMData htsData = new HMMData();
        String MaryBase = "/project/mary/marcela/openmary/";
        String voiceName = "cmu-slt-hsmm";
        String voiceConfig = "en_US-cmu-slt-hsmm.config";
        String outWavFile = String.valueOf(MaryBase) + "tmp/tmp.wav";
        htsData.initHMMData(voiceName, MaryBase, voiceConfig);
        htsData.setUseAcousticModels(true);
        htsData.setUseGV(true);
        htsData.setUseMixExc(true);
        htsData.setUseFourierMag(true);
        HTSUttModel um = new HTSUttModel();
        HTSParameterGeneration pdf2par = new HTSParameterGeneration();
        HTSVocoder par2speech = new HTSVocoder();
        try {
            um = hmm_tts.processUttFromFile(feaFile, htsData);
            pdf2par.htsMaximumLikelihoodParameterGeneration(um, htsData);
            AudioInputStream ais = par2speech.htsMLSAVocoder(pdf2par, htsData);
            System.out.println("saving to file: " + outWavFile);
            File fileOut = new File(outWavFile);
            if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, ais)) {
                AudioSystem.write(ais, AudioFileFormat.Type.WAVE, fileOut);
            }
            System.out.println("Calling audioplayer:");
            AudioPlayer player = new AudioPlayer(fileOut);
            player.start();
            player.join();
            System.out.println("audioplayer finished...");
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    public void synthesisWithProsodySpecificationInExternalFiles() throws Exception {
        String feaFile = "/project/mary/marcela/openmary/lib/voices/cmu-slt-hsmm/cmu_us_arctic_slt_a0001.pfeats";
        HTSEngine hmm_tts = new HTSEngine();
        HMMData htsData = new HMMData();
        String MaryBase = "/project/mary/marcela/openmary/";
        String voiceName = "cmu-slt-hsmm";
        String voiceConfig = "en_US-cmu-slt-hsmm.config";
        String outWavFile = String.valueOf(MaryBase) + "tmp/tmp.wav";
        htsData.initHMMData(voiceName, MaryBase, voiceConfig);
        htsData.setUseGV(true);
        htsData.setUseMixExc(true);
        htsData.setUseFourierMag(true);
        HTSUttModel um = new HTSUttModel();
        HTSParameterGeneration pdf2par = new HTSParameterGeneration();
        HTSVocoder par2speech = new HTSVocoder();
        String labFile = "/project/mary/marcela/f0-hsmm-experiment/cmu_us_arctic_slt_a0001.lab";
        float fperiodsec = (float)htsData.getFperiod() / (float)htsData.getRate();
        hmm_tts.setPhonemeAlignmentForDurations(true);
        Vector<PhonemeDuration> durations = new Vector<PhonemeDuration>();
        float totalDuration = this.loadDurationsForAlignment(labFile, durations);
        hmm_tts.setAlignDurations(durations);
        int cfr_ignored_0 = (int)(totalDuration / fperiodsec);
        hmm_tts.setNewStateDurationFactor(0.37);
        htsData.setUseAcousticModels(true);
        try {
            um = hmm_tts.processUttFromFile(feaFile, htsData);
            pdf2par.htsMaximumLikelihoodParameterGeneration(um, htsData);
            AudioInputStream ais = par2speech.htsMLSAVocoder(pdf2par, htsData);
            System.out.println("saving to file: " + outWavFile);
            File fileOut = new File(outWavFile);
            if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, ais)) {
                AudioSystem.write(ais, AudioFileFormat.Type.WAVE, fileOut);
            }
            System.out.println("Calling audioplayer:");
            AudioPlayer player = new AudioPlayer(fileOut);
            player.start();
            player.join();
            System.out.println("audioplayer finished...");
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    public float loadDurationsForAlignment(String fileName, Vector<PhonemeDuration> alignDur) {
        Scanner s = null;
        float totalDuration = 0.0f;
        float previous = 0.0f;
        float current = 0.0f;
        try {
            s = new Scanner(new File(fileName));
            int i = 0;
            while (s.hasNext()) {
                String line = s.nextLine();
                if (line.startsWith("#") || line.startsWith("format")) continue;
                String[] val = line.split(" ");
                current = Float.parseFloat(val[0]);
                if (previous == 0.0f) {
                    alignDur.add(new PhonemeDuration(val[2], current));
                } else {
                    alignDur.add(new PhonemeDuration(val[2], current - previous));
                }
                System.out.println("phone = " + alignDur.get(i).getPhoneme() + " dur(" + i + ")=" + alignDur.get(i).getDuration() + " totalDuration=" + (totalDuration += alignDur.get(i).getDuration()));
                ++i;
                previous = current;
            }
            System.out.println();
            s.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return totalDuration;
    }

    /*
     * Unable to fully structure code
     */
    public void loadF0contour(String lf0File, int totalDurationFrames, HTSParameterGeneration pdf2par) throws Exception {
        lf0Pst = null;
        voiced = null;
        lf0Vsize = 3;
        totalFrame = 0;
        lf0VoicedFrame = 0;
        lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
        try {
            while (true) {
                fval = lf0Data.readFloat();
                ++totalFrame;
                if (!(fval > 0.0f)) continue;
                ++lf0VoicedFrame;
            }
        }
        catch (EOFException v0) {
            lf0Data.close();
            if (totalDurationFrames != totalFrame) {
                System.out.println("The total duration in frames " + totalDurationFrames + " is not the same as the number of frames " + totalFrame + " in the lf0 file: " + lf0File);
            } else {
                System.out.println("totalDurationFrames = " + totalDurationFrames + "  totalF0Frames = " + totalFrame);
            }
            voiced = new boolean[totalFrame];
            lf0Pst = new HTSPStream(lf0Vsize, totalFrame, HMMData.FeatureType.LF0, 0);
            lf0VoicedFrame = 0;
            lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
            i = 0;
            ** while (i < totalFrame)
        }
lbl-1000:
        // 1 sources

        {
            fval = lf0Data.readFloat();
            if (fval < 0.0f) {
                voiced[i] = false;
                System.out.println("frame: " + i + " = 0.0");
            } else {
                voiced[i] = true;
                lf0Pst.setPar(lf0VoicedFrame, 0, fval);
                ++lf0VoicedFrame;
                System.out.format("frame: %d = %.2f\n", new Object[]{i, Float.valueOf(fval)});
            }
            ++i;
            continue;
        }
lbl38:
        // 1 sources

        lf0Data.close();
        pdf2par.setlf0Pst(lf0Pst);
        pdf2par.setVoicedArray(voiced);
    }

    public void generateParameters() throws IOException, InterruptedException, Exception {
        String MaryBase = "/project/mary/marcela/openmary/";
        String locale = "english";
        String voice = "hsmm-slt";
        String configFile = String.valueOf(locale) + "-" + voice + ".config";
        String contextFeaDir = "/project/mary/marcela/quality-control-experiment/slt/phonefeatures/";
        String outputDir = "/project/mary/marcela/quality-control-experiment/slt/hmmGenerated/";
        String filesList = "/project/mary/marcela/quality-control-experiment/slt/phonefeatures-list.txt";
        HTSEngine hmm_tts = new HTSEngine();
        HMMData htsData = new HMMData();
        htsData.initHMMData(voice, MaryBase, configFile);
        htsData.getFperiod();
        htsData.getRate();
        float fperiodsec = (float)htsData.getFperiod() / (float)htsData.getRate();
        htsData.setUseGV(true);
        htsData.setUseMixExc(true);
        try {
            Scanner filesScanner = new Scanner(new BufferedReader(new FileReader(filesList)));
            while (filesScanner.hasNext()) {
                String file = filesScanner.nextLine();
                String feaFile = String.valueOf(contextFeaDir) + file + ".pfeats";
                String cfr_ignored_0 = String.valueOf(outputDir) + file;
                String durFile = String.valueOf(outputDir) + file + ".lab";
                String durStateFile = String.valueOf(outputDir) + file + ".slab";
                String outWavFile = String.valueOf(outputDir) + file + ".wav";
                HTSUttModel um = new HTSUttModel();
                HTSParameterGeneration pdf2par = new HTSParameterGeneration();
                HTSVocoder par2speech = new HTSVocoder();
                um = hmm_tts.processUttFromFile(feaFile, htsData);
                FileWriter outputStream = new FileWriter(durFile);
                outputStream.write(hmm_tts.getRealisedDurations());
                outputStream.close();
                float totalDur = 0.0f;
                int numStates = htsData.getCartTreeSet().getNumStates();
                outputStream = new FileWriter(durStateFile);
                outputStream.write("#\n");
                int i = 0;
                while (i < um.getNumModel()) {
                    int j = 0;
                    while (j < numStates) {
                        totalDur += (float)um.getUttModel(i).getDur(j) * fperiodsec;
                        if (j < numStates - 1) {
                            outputStream.write(String.valueOf(totalDur) + " 0 " + um.getUttModel(i).getPhoneName() + "\n");
                        } else {
                            outputStream.write(String.valueOf(totalDur) + " 1 " + um.getUttModel(i).getPhoneName() + "\n");
                        }
                        ++j;
                    }
                    ++i;
                }
                outputStream.close();
                pdf2par.htsMaximumLikelihoodParameterGeneration(um, htsData);
                AudioInputStream ais = par2speech.htsMLSAVocoder(pdf2par, htsData);
                System.out.println("saving to file: " + outWavFile);
                File fileOut = new File(outWavFile);
                if (!AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, ais)) continue;
                AudioSystem.write(ais, AudioFileFormat.Type.WAVE, fileOut);
            }
            filesScanner.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getSptkMfcc() throws IOException, InterruptedException, Exception {
        inFile = "/project/mary/marcela/quality-control-experiment/slt/cmu_us_arctic_slt_a0001.wav";
        outFile = "/project/mary/marcela/quality-control-experiment/slt/cmu_us_arctic_slt_a0001.mfc";
        tmpFile = "/project/mary/marcela/quality-control-experiment/slt/tmp.mfc";
        tmpRawFile = "/project/mary/marcela/quality-control-experiment/slt/tmp.raw";
        fs = 16000;
        frameLength = 400;
        frameLengthOutput = 512;
        framePeriod = 80;
        mgcOrder = 24;
        mgcDimension = 25;
        ws = frameLength / fs;
        ss = framePeriod / fs;
        sox = "/usr/bin/sox";
        x2x = " /project/mary/marcela/sw/SPTK-3.1/bin/x2x";
        frame = " /project/mary/marcela/sw/SPTK-3.1/bin/frame";
        window = " /project/mary/marcela/sw/SPTK-3.1/bin/window";
        mcep = " /project/mary/marcela/sw/SPTK-3.1/bin/mcep";
        swab = "/project/mary/marcela/sw/SPTK-3.1/bin/swab";
        cmd = String.valueOf(sox) + " " + inFile + " " + tmpRawFile;
        this.launchProc(cmd, "sox", inFile);
        System.out.println("Extracting MGC coefficients from " + inFile);
        cmd = String.valueOf(x2x) + " +sf " + tmpRawFile + " | " + frame + " +f -l " + frameLength + " -p " + framePeriod + " | " + window + " -l " + frameLength + " -L " + frameLengthOutput + " -w 1 -n 1 | " + mcep + " -a 0.42 -m " + mgcOrder + "  -l " + frameLengthOutput + " | " + swab + " +f > " + tmpFile;
        System.out.println("cmd=" + cmd);
        this.launchBatchProc(cmd, "getSptkMfcc", inFile);
        mfcData = null;
        mfc = new Vector<Float>();
        mfcData = new DataInputStream(new BufferedInputStream(new FileInputStream(tmpFile)));
        try {
            while (true) {
                mfc.add(Float.valueOf(mfcData.readFloat()));
            }
        }
        catch (EOFException v0) {
            mfcData.close();
            numFrames = mfc.size();
            numVectors = numFrames / mgcDimension;
            mgc = new Mfccs(numVectors, mgcDimension);
            k = 0;
            i = 0;
            ** while (i < numVectors)
        }
lbl-1000:
        // 1 sources

        {
            j = 0;
            while (j < mgcDimension) {
                mgc.mfccs[i][j] = ((Float)mfc.get(k)).floatValue();
                ++k;
                ++j;
            }
            ++i;
            continue;
        }
lbl49:
        // 1 sources

        mgc.params.samplingRate = fs;
        mgc.params.skipsize = (float)ss;
        mgc.params.winsize = (float)ws;
        mgc.writeMfccFile(outFile);
    }

    public void getSptkSnackLf0() throws IOException, InterruptedException, Exception {
        String MINPITCH;
        String MAXPITCH;
        String inFile = "/project/mary/marcela/quality-control-experiment/slt/cmu_us_arctic_slt_a0001.wav";
        String tmpRawFile = "/project/mary/marcela/quality-control-experiment/slt/tmp.raw";
        String tmpRawLongFile = "/project/mary/marcela/quality-control-experiment/slt/tmp_long.raw";
        String scriptFileName = "/project/mary/marcela/quality-control-experiment/slt/lf0.tcl";
        String snackFile = "/project/mary/marcela/quality-control-experiment/slt/tmp.lf0";
        String gender = "female";
        if (gender.contentEquals("female")) {
            MAXPITCH = "500";
            MINPITCH = "100";
        } else {
            MAXPITCH = "300";
            MINPITCH = "75";
        }
        String FRAMELENGTH = "0.005";
        String FRAMERATE = "16000";
        String sox = "/usr/bin/sox";
        String x2x = " /project/mary/marcela/sw/SPTK-3.1/bin/x2x";
        String step2 = "/project/mary/marcela/sw/SPTK-3.1/bin/step";
        String nrand = "/project/mary/marcela/sw/SPTK-3.1/bin/nrand";
        String sopr = "/project/mary/marcela/sw/SPTK-3.1/bin/sopr";
        String vopr = "/project/mary/marcela/sw/SPTK-3.1/bin/vopr";
        String SNACKDIR = "/project/mary/marcela/sw/snack2.2.10/";
        String cmd = String.valueOf(sox) + " " + inFile + " " + tmpRawFile;
        this.launchProc(cmd, "sox", inFile);
        System.out.println("Create temporary raw file" + inFile);
        cmd = String.valueOf(step2) + " -l 80 -v 0.0 | x2x +fs > tmp.head\n" + step2 + " -l 400 -v 0.0 | x2x +fs > tmp.tail\n" + "cat tmp.head " + tmpRawFile + " tmp.tail | x2x +sf > tmp.long\n" + "leng=`x2x +fa tmp.long | /usr/bin/wc -l`\n" + "echo \"leng=$leng\"\n" + nrand + " -l $leng | " + sopr + " -m 50 | " + vopr + " -a tmp.long | " + x2x + " +fs > " + tmpRawLongFile + "\n" + "rm tmp.tail tmp.long tmp.head " + tmpRawFile + "\n";
        System.out.println("cmd=" + cmd);
        this.launchBatchProc(cmd, "getSptkSnackLf0", tmpRawFile);
        System.out.println("scriptFileName = " + scriptFileName);
        File script = new File(scriptFileName);
        System.out.println("Extracting LF0 coefficients from " + inFile);
        if (script.exists()) {
            script.delete();
        }
        PrintWriter toScript = new PrintWriter(new FileWriter(script));
        toScript.println("#!" + SNACKDIR);
        toScript.println("");
        toScript.println("package require snack");
        toScript.println("");
        toScript.println("snack::sound s");
        toScript.println("");
        toScript.println("s read [lindex $argv 0] -fileformat RAW -rate [lindex $argv 1] -encoding Lin16 -byteorder littleEndian");
        toScript.println("");
        toScript.println("set fd [open [lindex $argv 2] w]");
        toScript.println("set tmp [s pitch -method esps -maxpitch [lindex $argv 3] -minpitch [lindex $argv 4] -framelength [lindex $argv 5]]\nforeach line $tmp {\n  set x [lindex $line 0]\n  if { $x == 0 } {\n    puts $fd -1.0e+10\n  } else {\n    puts $fd [expr log($x)]\n  }\n}\n");
        toScript.println("close $fd");
        toScript.println("");
        toScript.println("exit");
        toScript.println("");
        toScript.close();
        cmd = "tcl " + scriptFileName + " " + tmpRawLongFile + " " + FRAMERATE + " " + snackFile + " " + MAXPITCH + " " + MINPITCH + " " + FRAMELENGTH;
        System.out.println("cmd=" + cmd);
        this.launchProc(cmd, "getSptkSnackLf0", tmpRawLongFile);
        double[] f0 = new SnackTextfileDoubleDataSource(new FileReader(snackFile)).getAllData();
        int j = 0;
        while (j < f0.length) {
            System.out.println(String.valueOf(j) + "  f0[" + j + "]= " + f0[j]);
            ++j;
        }
    }

    private void launchProc(String cmdLine, String task, String baseName) {
        Process proc = null;
        BufferedReader procStdout = null;
        String line = null;
        try {
            proc = Runtime.getRuntime().exec(cmdLine);
            procStdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = procStdout.readLine()) != null) {
                System.out.println(line);
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new RuntimeException(String.valueOf(task) + " computation failed on file [" + baseName + "]!\n" + "Command line was: [" + cmdLine + "].");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(task) + " computation provoked an IOException on file [" + baseName + "].", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(String.valueOf(task) + " computation interrupted on file [" + baseName + "].", e);
        }
    }

    private void launchBatchProc(String cmdLine, String task, String baseName) {
        Process proc = null;
        Process proctmp = null;
        BufferedReader procStdout = null;
        String line = null;
        String tmpFile = "./tmp.bat";
        try {
            FileWriter tmp = new FileWriter(tmpFile);
            tmp.write(cmdLine);
            tmp.close();
            proctmp = Runtime.getRuntime().exec("chmod +x " + tmpFile);
            proctmp.waitFor();
            proc = Runtime.getRuntime().exec(tmpFile);
            procStdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = procStdout.readLine()) != null) {
                System.out.println(line);
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new RuntimeException(String.valueOf(task) + " computation failed on file [" + baseName + "]!\n" + "Command line was: [" + cmdLine + "].");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(task) + " computation provoked an IOException on file [" + baseName + "].", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(String.valueOf(task) + " computation interrupted on file [" + baseName + "].", e);
        }
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        HTSEngineTest test = new HTSEngineTest();
        test.synthesisWithContinuousFeatureProcessors();
    }

    public class PhonemeDuration {
        private String phone;
        private float duration;

        public PhonemeDuration(String ph, float dur) {
            this.phone = ph;
            this.duration = dur;
        }

        public void setPhoneme(String str) {
            this.phone = str;
        }

        public void setDuration(float fval) {
            this.duration = fval;
        }

        public String getPhoneme() {
            return this.phone;
        }

        public float getDuration() {
            return this.duration;
        }
    }
}

