/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.awt.Color;
import java.util.Arrays;
import javax.swing.JFrame;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.machinelearning.PolynomialCluster;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.math.MathUtils;
import marytts.util.math.Polynomial;

public class PolynomialKMeansClusteringTrainer {
    public static PolynomialCluster[] train(Polynomial[] polynomials, KMeansClusteringTrainerParams kmeansParams) {
        int t;
        int observations = polynomials.length;
        int polynomialOrder = polynomials[0].getOrder();
        Polynomial[] m_new = new Polynomial[kmeansParams.numClusters];
        boolean[][] b = new boolean[observations][kmeansParams.numClusters];
        boolean[][] b_old = new boolean[observations][kmeansParams.numClusters];
        Polynomial[] clusterMeans = new Polynomial[kmeansParams.numClusters];
        int k = 0;
        while (k < kmeansParams.numClusters) {
            clusterMeans[k] = new Polynomial(polynomialOrder);
            ++k;
        }
        int t2 = 1;
        while (t2 <= observations) {
            Arrays.fill(b[t2 - 1], false);
            ++t2;
        }
        Polynomial mAll = Polynomial.mean(polynomials);
        double[] dists = new double[observations];
        double[] tmp = new double[kmeansParams.numClusters + 1];
        int k2 = 1;
        while (k2 <= kmeansParams.numClusters) {
            int t3 = 1;
            while (t3 <= observations) {
                if (k2 > 1) {
                    int i = 1;
                    while (i <= k2 - 1) {
                        tmp[i - 1] = clusterMeans[i - 1].polynomialDistance(polynomials[t3 - 1]);
                        ++i;
                    }
                    tmp[k2 - 1] = mAll.polynomialDistance(polynomials[t3 - 1]);
                    dists[t3 - 1] = MathUtils.mean(tmp, 0, k2 - 1);
                } else {
                    dists[t3 - 1] = mAll.polynomialDistance(polynomials[t3 - 1]);
                }
                ++t3;
            }
            double maxD = Double.MIN_VALUE;
            int maxInd = -1;
            int t4 = 1;
            while (t4 <= observations) {
                if (dists[t4 - 1] > maxD) {
                    maxD = dists[t4 - 1];
                    maxInd = t4;
                }
                ++t4;
            }
            clusterMeans[k2 - 1].copyCoeffs(polynomials[maxInd - 1]);
            ++k2;
        }
        int[] tinyClusterInds = new int[kmeansParams.numClusters];
        int[] totalObservationsInClusters = new int[kmeansParams.numClusters];
        int[] clusterIndices = new int[observations];
        int iter = 0;
        boolean bCont = true;
        while (bCont) {
            int t5 = 1;
            while (t5 <= observations) {
                double minDist = Double.MAX_VALUE;
                int ind = -1;
                int i = 1;
                while (i <= kmeansParams.numClusters) {
                    double tmpDist = clusterMeans[i - 1].polynomialDistance(polynomials[t5 - 1]);
                    b[t5 - 1][i - 1] = false;
                    if (tmpDist < minDist) {
                        minDist = tmpDist;
                        ind = i;
                    }
                    ++i;
                }
                b[t5 - 1][ind - 1] = true;
                ++t5;
            }
            int i = 1;
            while (i <= kmeansParams.numClusters) {
                totalObservationsInClusters[i - 1] = 0;
                tinyClusterInds[i - 1] = 0;
                ++i;
            }
            int c = 1;
            int i2 = 1;
            while (i2 <= kmeansParams.numClusters) {
                m_new[i2 - 1] = new Polynomial(polynomialOrder);
                int t6 = 1;
                while (t6 <= observations) {
                    if (b[t6 - 1][i2 - 1]) {
                        int d = 0;
                        while (d <= polynomialOrder) {
                            int n = d;
                            m_new[i2 - 1].coeffs[n] = m_new[i2 - 1].coeffs[n] + polynomials[t6 - 1].coeffs[d];
                            ++d;
                        }
                        clusterIndices[t6 - 1] = i2 - 1;
                        int n = i2 - 1;
                        totalObservationsInClusters[n] = totalObservationsInClusters[n] + 1;
                    }
                    ++t6;
                }
                if ((double)totalObservationsInClusters[i2 - 1] < (double)kmeansParams.minSamplesInOneCluster) {
                    tinyClusterInds[c - 1] = i2;
                    ++c;
                }
                ++i2;
            }
            c = 0;
            double[] tmps = new double[totalObservationsInClusters.length];
            int a = 0;
            while (a < tmps.length) {
                tmps[a] = totalObservationsInClusters[a];
                ++a;
            }
            int[] inds = MathUtils.quickSort(tmps, 0, kmeansParams.numClusters - 1);
            int i3 = 1;
            while (i3 <= kmeansParams.numClusters) {
                int d;
                if (totalObservationsInClusters[i3 - 1] >= kmeansParams.minSamplesInOneCluster) {
                    d = 0;
                    while (d <= polynomialOrder) {
                        clusterMeans[i3 - 1].coeffs[d] = m_new[i3 - 1].coeffs[d] / (double)totalObservationsInClusters[i3 - 1];
                        ++d;
                    }
                } else {
                    d = 0;
                    while (d <= polynomialOrder) {
                        double rnd = 2.0 * (Math.random() - 0.5) * clusterMeans[inds[kmeansParams.numClusters - c - 1]].coeffs[d] * 0.01;
                        clusterMeans[i3 - 1].coeffs[d] = clusterMeans[inds[kmeansParams.numClusters - c - 1]].coeffs[d] + rnd;
                        ++d;
                    }
                    ++c;
                }
                ++i3;
            }
            int[] cfr_ignored_0 = (int[])totalObservationsInClusters.clone();
            int totChanged = 0;
            if (++iter > 1) {
                if (iter >= kmeansParams.maxIterations) {
                    bCont = false;
                }
                t = 1;
                while (t <= observations) {
                    int i4 = 1;
                    while (i4 <= kmeansParams.numClusters) {
                        if (b_old[t - 1][i4 - 1] != b[t - 1][i4 - 1]) {
                            ++totChanged;
                            break;
                        }
                        ++i4;
                    }
                    ++t;
                }
                double changedPerc = (double)totChanged / (double)observations * 100.0;
                if (changedPerc < kmeansParams.minClusterChangePercent) {
                    bCont = false;
                }
            }
            t = 1;
            while (t <= observations) {
                System.arraycopy(b[t - 1], 0, b_old[t - 1], 0, b[t - 1].length);
                ++t;
            }
        }
        PolynomialCluster[] clusters = new PolynomialCluster[kmeansParams.numClusters];
        int i = 1;
        while (i <= kmeansParams.numClusters) {
            Polynomial[] members = new Polynomial[totalObservationsInClusters[i - 1]];
            int m = 0;
            t = 1;
            while (t <= observations) {
                if (b[t - 1][i - 1]) {
                    members[m] = polynomials[t - 1];
                    ++m;
                }
                ++t;
            }
            assert (m == members.length);
            clusters[i - 1] = new PolynomialCluster(clusterMeans[i - 1], members);
            ++i;
        }
        return clusters;
    }

    public static void main(String[] args) {
        int order = 3;
        int numPolynomials = 1000;
        int numClusters = 50;
        Polynomial[] ps = new Polynomial[numPolynomials];
        int i = 0;
        while (i < numPolynomials) {
            double[] coeffs = new double[order + 1];
            int c = 0;
            while (c < coeffs.length) {
                coeffs[c] = Math.random();
                ++c;
            }
            ps[i] = new Polynomial(coeffs);
            ++i;
        }
        KMeansClusteringTrainerParams params = new KMeansClusteringTrainerParams();
        params.numClusters = numClusters;
        PolynomialCluster[] clusters = PolynomialKMeansClusteringTrainer.train(ps, params);
        FunctionGraph clusterGraph = new FunctionGraph(0.0, 1.0, new double[1]);
        clusterGraph.setYMinMax(0.0, 5.0);
        clusterGraph.setPrimaryDataSeriesStyle(Color.BLUE, 2, 1);
        JFrame jf = clusterGraph.showInJFrame("", false, true);
        int i2 = 0;
        while (i2 < clusters.length) {
            double[] meanValues = clusters[i2].getMeanPolynomial().generatePolynomialValues(100, 0.0, 1.0);
            clusterGraph.updateData(0.0, 1.0 / (double)meanValues.length, meanValues);
            Polynomial[] members = clusters[i2].getClusterMembers();
            int m = 0;
            while (m < members.length) {
                double[] pred = members[m].generatePolynomialValues(meanValues.length, 0.0, 1.0);
                clusterGraph.addDataSeries(pred, Color.GRAY, 1, -1);
                jf.repaint();
                ++m;
            }
            jf.setTitle("Cluster " + (i2 + 1) + " of " + clusters.length + ": " + members.length + " members");
            jf.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            ++i2;
        }
        System.exit(0);
    }
}

