/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.util.data.text.PraatInterval;
import marytts.util.data.text.PraatIntervalTier;
import marytts.util.data.text.PraatTextGrid;
import marytts.util.dom.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class PraatTextGridGenerator
extends InternalModule {
    public PraatTextGridGenerator() {
        super("Praat TextGrid generator", MaryDataType.REALISED_ACOUSTPARAMS, MaryDataType.PRAAT_TEXTGRID, null);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Element element;
        Document doc = d.getDocument();
        Double duration = 0.0;
        String phone = null;
        PraatIntervalTier phoneTier = new PraatIntervalTier("phones");
        Double basenameDuration = 0.0;
        int prevUnitIndex = Integer.MIN_VALUE;
        int numberOfConsecutiveUnits = 0;
        PraatInterval sourceInterval = new PraatInterval(basenameDuration);
        PraatIntervalTier unitTier = new PraatIntervalTier("units");
        PraatIntervalTier sourceTier = new PraatIntervalTier("sources");
        NodeIterator ni = DomUtils.createNodeIterator((Node)doc, "ph", "boundary");
        while ((element = (Element)ni.nextNode()) != null) {
            switch (element.getTagName()) {
                case "ph": {
                    phone = element.getAttribute("p");
                    duration = (double)Integer.parseInt(element.getAttribute("d")) / 1000.0;
                    break;
                }
                case "boundary": {
                    phone = "_";
                    if (element.hasAttribute("duration")) {
                        duration = Double.parseDouble(element.getAttribute("duration")) / 1000.0;
                        break;
                    }
                    duration = 0.0;
                    break;
                }
                default: {
                    this.logger.error("NodeIterator should not find an element of type " + element.getTagName() + " here!");
                }
            }
            PraatInterval phoneInterval = new PraatInterval((double)duration, phone);
            if (element.hasAttribute("units")) {
                String units = element.getAttribute("units");
                String[] unitStrings = units.split("; ");
                boolean differentSource = false;
                String basename = null;
                String unitRange = null;
                String[] stringArray = unitStrings;
                int n = unitStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String unitString = stringArray[n2];
                    String[] unitFields = unitString.split(" ");
                    String cfr_ignored_0 = unitFields[0];
                    basename = unitFields[1];
                    int unitIndex = Integer.parseInt(unitFields[2]);
                    Double unitDuration = Double.parseDouble(unitFields[3]);
                    unitTier.appendInterval(new PraatInterval((double)unitDuration, unitString));
                    boolean bl = differentSource = unitIndex != prevUnitIndex + 1;
                    if (differentSource) {
                        numberOfConsecutiveUnits = 0;
                        basenameDuration = 0.0;
                    }
                    basenameDuration = basenameDuration + unitDuration;
                    unitRange = Integer.toString(unitIndex - ++numberOfConsecutiveUnits + 1);
                    if (numberOfConsecutiveUnits > 1) {
                        unitRange = String.valueOf(unitRange) + "-" + unitIndex;
                    }
                    if (differentSource) {
                        sourceInterval = new PraatInterval((double)basenameDuration, String.valueOf(basename) + ": " + unitRange);
                        sourceTier.appendInterval(sourceInterval);
                    } else {
                        sourceInterval.setDuration(basenameDuration);
                        sourceInterval.setText(String.valueOf(basename) + ": " + unitRange);
                    }
                    prevUnitIndex = unitIndex;
                    ++n2;
                }
            } else if (duration > 10.0) {
                phoneInterval.setDuration(duration / 1000.0);
            }
            phoneTier.appendInterval(phoneInterval);
        }
        PraatTextGrid textGrid = new PraatTextGrid();
        phoneTier.updateBoundaries();
        textGrid.appendTier(phoneTier);
        if (unitTier.getNumberOfIntervals() > 0) {
            unitTier.updateBoundaries();
            textGrid.appendTier(unitTier);
            sourceTier.updateBoundaries();
            textGrid.appendTier(sourceTier);
        }
        MaryData result = new MaryData(this.getOutputType(), d.getLocale());
        result.setPlainText(textGrid.toString());
        return result;
    }
}

