/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.phonemiser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.phonemiser.Allophone;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;

public class AllophoneSet {
    private static Map<String, AllophoneSet> allophoneSets = new HashMap<String, AllophoneSet>();
    private String name;
    private Locale locale;
    private Map<String, Allophone> allophones = new TreeMap<String, Allophone>();
    private Map<String, String[]> featureValueMap = null;
    private Allophone silence = null;
    private String ignore_chars = null;
    private int maxAllophoneSymbolLength = 1;

    public static AllophoneSet getAllophoneSet(String filename) throws MaryConfigurationException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
        }
        catch (IOException e) {
            throw new MaryConfigurationException("Problem reading allophone file " + filename, e);
        }
        assert (fis != null);
        return AllophoneSet.getAllophoneSet(fis, filename);
    }

    public static boolean hasAllophoneSet(String identifier) {
        return allophoneSets.containsKey(identifier);
    }

    public static AllophoneSet getAllophoneSetById(String identifier) {
        return allophoneSets.get(identifier);
    }

    public static AllophoneSet getAllophoneSet(InputStream inStream, String identifier) throws MaryConfigurationException {
        AllophoneSet as = allophoneSets.get(identifier);
        if (as == null) {
            try {
                as = new AllophoneSet(inStream);
            }
            catch (MaryConfigurationException e) {
                throw new MaryConfigurationException("Problem loading allophone set from " + identifier, e);
            }
            allophoneSets.put(identifier, as);
        } else {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
        assert (as != null);
        return as;
    }

    private AllophoneSet(InputStream inputStream) throws MaryConfigurationException {
        Element a;
        Document document;
        try {
            try {
                document = DomUtils.parseDocument(inputStream);
            }
            catch (Exception e) {
                throw new MaryConfigurationException("Cannot parse allophone file", e);
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        Element root = document.getDocumentElement();
        this.name = root.getAttribute("name");
        String xmlLang = root.getAttribute("xml:lang");
        this.locale = MaryUtils.string2locale(xmlLang);
        String[] featureNames = root.getAttribute("features").split(" ");
        if (root.hasAttribute("ignore_chars")) {
            this.ignore_chars = root.getAttribute("ignore_chars");
        }
        NodeIterator ni = DomUtils.createNodeIterator(document, root, "vowel", "consonant", "silence", "tone");
        while ((a = (Element)ni.nextNode()) != null) {
            int len;
            Allophone ap = new Allophone(a, featureNames);
            if (this.allophones.containsKey(ap.name())) {
                throw new MaryConfigurationException("File contains duplicate definition of allophone '" + ap.name() + "'!");
            }
            this.allophones.put(ap.name(), ap);
            if (ap.isPause()) {
                if (this.silence != null) {
                    throw new MaryConfigurationException("File contains more than one silence symbol: '" + this.silence.name() + "' and '" + ap.name() + "'!");
                }
                this.silence = ap;
            }
            if ((len = ap.name().length()) <= this.maxAllophoneSymbolLength) continue;
            this.maxAllophoneSymbolLength = len;
        }
        if (this.silence == null) {
            throw new MaryConfigurationException("File does not contain a silence symbol");
        }
        this.featureValueMap = new TreeMap<String, String[]>();
        String[] stringArray = featureNames;
        int n = featureNames.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            TreeSet<String> featureValueSet = new TreeSet<String>();
            for (Allophone ap : this.allophones.values()) {
                featureValueSet.add(ap.getFeature(feature));
            }
            if (featureValueSet.contains("0")) {
                featureValueSet.remove("0");
            }
            String[] featureValues = new String[featureValueSet.size() + 1];
            featureValues[0] = "0";
            int i = 1;
            for (String f : featureValueSet) {
                featureValues[i++] = f;
            }
            this.featureValueMap.put(feature, featureValues);
            ++n2;
        }
        this.featureValueMap.put("vc", new String[]{"0", "+", "-"});
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Allophone getAllophone(String ph) {
        Allophone allophone = this.allophones.get(ph);
        if (allophone == null) {
            throw new IllegalArgumentException(String.format("Allophone `%s' could not be found in AllophoneSet `%s' (Locale: %s)", ph, this.name, this.locale));
        }
        return allophone;
    }

    public Allophone getSilence() {
        return this.silence;
    }

    public String getIgnoreChars() {
        if (this.ignore_chars == null) {
            return "',-";
        }
        return this.ignore_chars;
    }

    public String getPhoneFeature(String ph, String featureName) {
        if (ph == null) {
            return null;
        }
        Allophone a = this.allophones.get(ph);
        if (a == null) {
            return null;
        }
        return a.getFeature(featureName);
    }

    public Set<String> getPhoneFeatures() {
        return Collections.unmodifiableSet(this.featureValueMap.keySet());
    }

    public String[] getPossibleFeatureValues(String featureName) {
        String[] vals = this.featureValueMap.get(featureName);
        if (vals == null) {
            throw new IllegalArgumentException("No such feature: " + featureName);
        }
        return vals;
    }

    public Set<String> getAllophoneNames() {
        Iterator<String> it = this.allophones.keySet().iterator();
        TreeSet<String> allophoneKeySet = new TreeSet<String>();
        while (it.hasNext()) {
            String keyString = it.next();
            if (this.allophones.get(keyString).isTone()) continue;
            allophoneKeySet.add(keyString);
        }
        return allophoneKeySet;
    }

    public Allophone[] splitIntoAllophones(String allophoneString) {
        List<String> phones = this.splitIntoAllophoneList(allophoneString, false);
        Allophone[] allos = new Allophone[phones.size()];
        int i = 0;
        while (i < phones.size()) {
            allos[i] = this.getAllophone(phones.get(i));
            ++i;
        }
        return allos;
    }

    public String splitAllophoneString(String allophoneString) {
        List<String> phones = this.splitIntoAllophoneList(allophoneString, true);
        StringBuilder pronunciation = new StringBuilder();
        for (String a : phones) {
            if (pronunciation.length() > 0) {
                pronunciation.append(" ");
            }
            pronunciation.append(a);
        }
        return pronunciation.toString();
    }

    public List<String> splitIntoAllophoneList(String allophonesString) {
        return this.splitIntoAllophoneList(allophonesString, true);
    }

    private List<String> splitIntoAllophoneList(String allophoneString, boolean includeStressAndSyllableMarkers) {
        ArrayList<String> phones = new ArrayList<String>();
        int i = 0;
        while (i < allophoneString.length()) {
            block20: {
                String ph;
                block21: {
                    String one;
                    block19: {
                        one = allophoneString.substring(i, i + 1);
                        if (!this.getIgnoreChars().contains(one)) break block19;
                        if (includeStressAndSyllableMarkers) {
                            phones.add(one);
                        }
                        break block20;
                    }
                    if (one.equals(" ")) break block20;
                    ph = null;
                    int l = this.maxAllophoneSymbolLength;
                    while (l >= 1) {
                        if (i + l <= allophoneString.length() && this.allophones.containsKey(ph = allophoneString.substring(i, i + l))) {
                            i += l - 1;
                            break;
                        }
                        --l;
                    }
                    if (ph == null || !this.allophones.containsKey(ph)) break block21;
                    phones.add(ph);
                    break block20;
                }
                String stress = null;
                switch (ph) {
                    case "1": {
                        stress = "'";
                        break;
                    }
                    case "2": {
                        stress = ",";
                        break;
                    }
                    case "0": {
                        stress = "";
                    }
                }
                if (stress != null && phones.size() > 0) {
                    phones.add(phones.size() - 1, stress);
                } else {
                    throw new IllegalArgumentException("Found unknown symbol `" + allophoneString.charAt(i) + "' in phonetic string `" + allophoneString + "' -- ignoring.");
                }
            }
            ++i;
        }
        return phones;
    }

    public boolean checkAllophoneSyntax(String allophoneString) {
        try {
            this.splitIntoAllophoneList(allophoneString, false);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String syllabify(String phoneString) throws IllegalArgumentException {
        if (phoneString.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot syllabify empty phone string");
        }
        List<String> allophoneStrings = this.splitIntoAllophoneList(phoneString, true);
        ArrayList<String> phonesAndSyllables = new ArrayList<String>(allophoneStrings);
        ListIterator<Syllable> iterator = phonesAndSyllables.listIterator();
        Syllable currentSyllable = null;
        while (iterator.hasNext()) {
            String phone = (String)iterator.next();
            try {
                Object previousPhoneOrSyllable;
                Allophone allophone = this.getAllophone(phone);
                if (!allophone.isSyllabic()) continue;
                boolean appendR = false;
                if (allophone.getFeature("ctype").equals("r") && iterator.previousIndex() > 1 && (previousPhoneOrSyllable = phonesAndSyllables.get(iterator.previousIndex() - 1)) == currentSyllable && !currentSyllable.getLastAllophone().isDiphthong()) {
                    appendR = true;
                }
                if (appendR) {
                    iterator.remove();
                    currentSyllable.appendAllophone(allophone);
                    continue;
                }
                currentSyllable = new Syllable(allophone);
                iterator.set(currentSyllable);
            }
            catch (IllegalArgumentException e) {
                if (this.getIgnoreChars().contains(phone)) continue;
                throw e;
            }
        }
        currentSyllable = null;
        boolean foundPrimaryStress = false;
        iterator = phonesAndSyllables.listIterator(phonesAndSyllables.size());
        while (iterator.hasPrevious()) {
            Object phoneOrSyllable = iterator.previous();
            if (phoneOrSyllable instanceof Syllable) {
                currentSyllable = (Syllable)phoneOrSyllable;
                continue;
            }
            if (currentSyllable == null) continue;
            String phone = (String)phoneOrSyllable;
            try {
                Allophone allophone = this.getAllophone(phone);
                if (allophone.sonority() >= currentSyllable.getFirstAllophone().sonority()) continue;
                iterator.remove();
                currentSyllable.prependAllophone(allophone);
            }
            catch (IllegalArgumentException e) {
                switch (phone) {
                    case "'": {
                        iterator.remove();
                        currentSyllable.setStress("'");
                        foundPrimaryStress = true;
                        break;
                    }
                    case ",": {
                        iterator.remove();
                        currentSyllable.setStress(",");
                        break;
                    }
                    case "-": {
                        iterator.remove();
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        }
        Syllable initialSyllable = currentSyllable;
        currentSyllable = null;
        iterator = phonesAndSyllables.listIterator();
        while (iterator.hasNext()) {
            Allophone allophone;
            Object phoneOrSyllable = iterator.next();
            if (phoneOrSyllable instanceof Syllable) {
                currentSyllable = (Syllable)phoneOrSyllable;
                continue;
            }
            String phone = (String)phoneOrSyllable;
            try {
                allophone = this.getAllophone(phone);
            }
            catch (IllegalArgumentException e) {
                if (this.getIgnoreChars().contains(phone)) {
                    iterator.remove();
                    continue;
                }
                throw e;
            }
            if (currentSyllable == null) {
                iterator.remove();
                if (initialSyllable == null) {
                    initialSyllable = new Syllable(allophone);
                    iterator.add(initialSyllable);
                    continue;
                }
                initialSyllable.prependAllophone(allophone);
                continue;
            }
            iterator.remove();
            currentSyllable.appendAllophone(allophone);
        }
        if (!foundPrimaryStress) {
            initialSyllable.setStress("'");
        }
        return StringUtils.join(phonesAndSyllables, " - ");
    }

    public static interface Stress {
        public static final String NONE = "";
        public static final String PRIMARY = "'";
        public static final String SECONDARY = ",";
    }

    private class Syllable {
        private List<Allophone> allophones = new ArrayList<Allophone>();
        private String stress = "";

        public Syllable(Allophone ... allophones) {
            Collections.addAll(this.allophones, allophones);
        }

        public Allophone getFirstAllophone() {
            return this.allophones.get(0);
        }

        public void prependAllophone(Allophone allophone) {
            this.allophones.add(0, allophone);
        }

        public Allophone getLastAllophone() {
            return this.allophones.get(this.allophones.size() - 1);
        }

        public void appendAllophone(Allophone allophone) {
            this.allophones.add(allophone);
        }

        public void setStress(String stress) {
            this.stress = stress;
        }

        public String toString() {
            return String.format("%s %s", this.stress, StringUtils.join(this.allophones, " ")).trim();
        }
    }
}

