/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureRegistry;
import marytts.features.TargetFeatureComputer;
import marytts.htsengine.HMMVoice;
import marytts.modules.HTSEngine;
import marytts.modules.ModuleRegistry;
import marytts.modules.TargetFeatureLister;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.unitselection.select.Target;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class HMMSynthesizer
implements WaveformSynthesizer {
    private TargetFeatureLister targetFeatureLister;
    private HTSEngine htsEngine;
    private Logger logger;

    @Override
    public void startup() throws Exception {
        this.logger = MaryUtils.getLogger(this.toString());
        try {
            this.targetFeatureLister = (TargetFeatureLister)ModuleRegistry.getModule(TargetFeatureLister.class);
        }
        catch (NullPointerException nullPointerException) {
            this.targetFeatureLister = null;
        }
        if (this.targetFeatureLister == null) {
            this.logger.info("Starting my own TargetFeatureLister");
            this.targetFeatureLister = new TargetFeatureLister();
            this.targetFeatureLister.startup();
        } else if (this.targetFeatureLister.getState() == 0) {
            this.targetFeatureLister.startup();
        }
        try {
            this.htsEngine = (HTSEngine)ModuleRegistry.getModule(HTSEngine.class);
        }
        catch (NullPointerException nullPointerException) {
            this.htsEngine = null;
        }
        if (this.htsEngine == null) {
            this.logger.info("Starting my own HTSEngine");
            this.htsEngine = new HTSEngine();
            this.htsEngine.startup();
        } else if (this.htsEngine.getState() == 0) {
            this.htsEngine.startup();
        }
        List<String> voiceNames = MaryProperties.getList("hmm.voices.list");
        for (String voiceName : voiceNames) {
            this.logger.debug("Voice '" + voiceName + "'");
            HMMVoice v = new HMMVoice(voiceName, this);
            Voice.registerVoice(v);
        }
        this.logger.info("started.");
    }

    @Override
    public synchronized void powerOnSelfTest() throws Error {
        this.logger.info("Starting power-on self test.");
        try {
            Collection<Voice> myVoices = Voice.getAvailableVoices(this);
            if (myVoices.size() == 0) {
                return;
            }
            Voice v = myVoices.iterator().next();
            MaryData in = new MaryData(MaryDataType.ACOUSTPARAMS, v.getLocale());
            String exampleText = MaryDataType.ACOUSTPARAMS.exampleText(v.getLocale());
            if (exampleText != null) {
                Element e;
                in.readFrom(new StringReader(exampleText));
                in.setDefaultVoice(v);
                assert (v instanceof HMMVoice) : "Expected voice to be a HMMVoice, but it is a " + v.getClass().toString();
                String features = ((HMMVoice)v).getHMMData().getFeatureDefinition().getFeatureNames();
                TargetFeatureComputer comp = FeatureRegistry.getTargetFeatureComputer(v, features);
                in.setOutputParams(features);
                Document doc = in.getDocument();
                TreeWalker tw = MaryDomUtils.createTreeWalker(doc, doc, "ph", "boundary");
                ArrayList<Element> segmentsAndBoundaries = new ArrayList<Element>();
                while ((e = (Element)tw.nextNode()) != null) {
                    segmentsAndBoundaries.add(e);
                }
                List<Target> targetFeaturesList = this.targetFeatureLister.getListTargetFeatures(comp, segmentsAndBoundaries);
                MaryData audio = this.htsEngine.process(in, targetFeaturesList, segmentsAndBoundaries, null);
                assert (audio.getAudio() != null);
            } else {
                this.logger.debug("No example text -- no power-on self test!");
            }
        }
        catch (Throwable t) {
            throw new Error("Module " + this.toString() + ": Power-on self test failed.", t);
        }
        this.logger.info("Power-on self test complete.");
    }

    public String toString() {
        return "HMMSynthesizer";
    }

    @Override
    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, Voice voice, String outputParams) throws SynthesisException {
        if (!voice.synthesizer().equals(this)) {
            throw new IllegalArgumentException("Voice " + voice.getName() + " is not an HMM voice.");
        }
        this.logger.info("Synthesizing one sentence.");
        ArrayList<Element> segmentsAndBoundaries = new ArrayList<Element>();
        Document doc = null;
        for (Element tOrB : tokensAndBoundaries) {
            Element s;
            if (tOrB.getTagName().equals("boundary")) {
                segmentsAndBoundaries.add(tOrB);
                continue;
            }
            if (doc == null) {
                doc = tOrB.getOwnerDocument();
            }
            NodeIterator ni = MaryDomUtils.createNodeIterator(doc, tOrB, "ph");
            while ((s = (Element)ni.nextNode()) != null) {
                segmentsAndBoundaries.add(s);
            }
        }
        try {
            assert (voice instanceof HMMVoice) : "Expected voice to be a HMMVoice, but it is a " + voice.getClass().toString();
            String features = ((HMMVoice)voice).getHMMData().getFeatureDefinition().getFeatureNames();
            TargetFeatureComputer comp = FeatureRegistry.getTargetFeatureComputer(voice, features);
            MaryData d = new MaryData(this.targetFeatureLister.outputType(), voice.getLocale());
            d.setDefaultVoice(voice);
            List<Target> targetFeaturesList = this.targetFeatureLister.getListTargetFeatures(comp, segmentsAndBoundaries);
            MaryData audio = this.htsEngine.process(d, targetFeaturesList, segmentsAndBoundaries, tokensAndBoundaries);
            return audio.getAudio();
        }
        catch (Exception e) {
            throw new SynthesisException("HMM Synthesiser could not synthesise: ", e);
        }
    }
}

