/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.outlier;

import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.adaptation.OutlierStatus;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFile;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.signalproc.adaptation.outlier.GaussianOutlierEliminatorParams;
import marytts.signalproc.analysis.distance.DistanceComputer;
import marytts.util.math.MathUtils;

public class GaussianOutlierEliminator {
    public void eliminate(GaussianOutlierEliminatorParams params, String codebookFileIn, String codebookFileOut) {
        WeightedCodebookFile fileIn = new WeightedCodebookFile(codebookFileIn, WeightedCodebookFile.OPEN_FOR_READ);
        WeightedCodebook codebookIn = null;
        try {
            codebookIn = fileIn.readCodebookFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (codebookIn != null) {
            int[] acceptanceStatus = new int[codebookIn.header.totalEntries];
            double[] lsfDistances = null;
            if (params.isCheckLsfOutliers) {
                lsfDistances = new double[codebookIn.header.totalEntries];
            }
            double[] f0Distances = null;
            int[] voicedInds = null;
            if (params.isCheckF0Outliers) {
                f0Distances = new double[codebookIn.header.totalEntries];
                voicedInds = new int[codebookIn.header.totalEntries];
                Arrays.fill(voicedInds, -1);
            }
            double[] durationDistances = null;
            if (params.isCheckDurationOutliers) {
                durationDistances = new double[codebookIn.header.totalEntries];
            }
            double[] energyDistances = null;
            if (params.isCheckEnergyOutliers) {
                energyDistances = new double[codebookIn.header.totalEntries];
            }
            Arrays.fill(acceptanceStatus, OutlierStatus.NON_OUTLIER);
            double lsfDistanceMean = 0.0;
            double lsfDistanceStdDev = 0.0;
            double f0DistanceMean = 0.0;
            double f0DistanceStdDev = 0.0;
            int totalVoiced = 0;
            double durationDistanceMean = 0.0;
            double durationDistanceStdDev = 0.0;
            double energyDistanceMean = 0.0;
            double energyDistanceStdDev = 0.0;
            int i = 0;
            while (i < codebookIn.header.totalEntries) {
                if (params.isCheckLsfOutliers) {
                    lsfDistances[i] = DistanceComputer.getLsfInverseHarmonicDistance(codebookIn.entries[i].sourceItem.lsfs, codebookIn.entries[i].targetItem.lsfs, 5000.0);
                }
                if (params.isCheckF0Outliers && codebookIn.entries[i].sourceItem.f0 > 10.0 && codebookIn.entries[i].targetItem.f0 > 10.0) {
                    f0Distances[totalVoiced] = codebookIn.entries[i].sourceItem.f0 - codebookIn.entries[i].targetItem.f0;
                    voicedInds[totalVoiced] = i;
                    ++totalVoiced;
                }
                if (params.isCheckDurationOutliers) {
                    durationDistances[i] = codebookIn.entries[i].sourceItem.duration - codebookIn.entries[i].targetItem.duration;
                }
                if (params.isCheckEnergyOutliers) {
                    energyDistances[i] = codebookIn.entries[i].sourceItem.energy - codebookIn.entries[i].targetItem.energy;
                }
                ++i;
            }
            if (params.isCheckLsfOutliers) {
                lsfDistanceMean = MathUtils.mean(lsfDistances);
            }
            if (params.isCheckF0Outliers) {
                f0DistanceMean = MathUtils.mean(f0Distances, 0, totalVoiced - 1);
            }
            if (params.isCheckDurationOutliers) {
                durationDistanceMean = MathUtils.mean(durationDistances);
            }
            if (params.isCheckEnergyOutliers) {
                energyDistanceMean = MathUtils.mean(energyDistances);
            }
            lsfDistanceStdDev = 8.988465674311579E307;
            durationDistanceStdDev = 8.988465674311579E307;
            energyDistanceStdDev = 8.988465674311579E307;
            f0DistanceStdDev = 8.988465674311579E307;
            if (codebookIn.header.totalEntries > 1) {
                if (params.isCheckLsfOutliers) {
                    lsfDistanceStdDev = MathUtils.standardDeviation(lsfDistances, lsfDistanceMean);
                }
                if (params.isCheckDurationOutliers) {
                    durationDistanceStdDev = MathUtils.standardDeviation(durationDistances, durationDistanceMean);
                }
                if (params.isCheckEnergyOutliers) {
                    energyDistanceStdDev = MathUtils.standardDeviation(energyDistances, energyDistanceMean);
                }
            }
            if (params.isCheckF0Outliers && totalVoiced > 1) {
                f0DistanceStdDev = MathUtils.standardDeviation(f0Distances, f0DistanceMean, 0, totalVoiced - 1);
            }
            int totalLsfOutliers = 0;
            int totalDurationOutliers = 0;
            int totalF0Outliers = 0;
            int totalEnergyOutliers = 0;
            i = 0;
            while (i < codebookIn.header.totalEntries) {
                if (params.isCheckLsfOutliers && (lsfDistances[i] > lsfDistanceMean + params.totalStandardDeviations.lsf * lsfDistanceStdDev || params.isEliminateTooSimilarLsf && lsfDistances[i] < lsfDistanceMean - params.totalStandardDeviations.lsf * lsfDistanceStdDev)) {
                    int n = i;
                    acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.LSF_OUTLIER;
                    ++totalLsfOutliers;
                }
                if (params.isCheckDurationOutliers && durationDistances[i] > durationDistanceMean + params.totalStandardDeviations.duration * durationDistanceStdDev) {
                    int n = i;
                    acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.DURATION_OUTLIER;
                    ++totalDurationOutliers;
                }
                if (params.isCheckEnergyOutliers && energyDistances[i] > energyDistanceMean + params.totalStandardDeviations.energy * energyDistanceStdDev) {
                    int n = i;
                    acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.ENERGY_OUTLIER;
                    ++totalEnergyOutliers;
                }
                ++i;
            }
            if (params.isCheckF0Outliers) {
                i = 0;
                while (i < totalVoiced) {
                    if (f0Distances[i] > f0DistanceMean + params.totalStandardDeviations.f0 * f0DistanceStdDev) {
                        int n = voicedInds[i];
                        acceptanceStatus[n] = acceptanceStatus[n] + OutlierStatus.F0_OUTLIER;
                        ++totalF0Outliers;
                    }
                    ++i;
                }
            }
            int newTotalEntries = 0;
            i = 0;
            while (i < codebookIn.header.totalEntries) {
                if (acceptanceStatus[i] == OutlierStatus.NON_OUTLIER) {
                    ++newTotalEntries;
                }
                ++i;
            }
            WeightedCodebookFile codebookOut = new WeightedCodebookFile(codebookFileOut, WeightedCodebookFile.OPEN_FOR_WRITE);
            WeightedCodebookFileHeader headerOut = new WeightedCodebookFileHeader(codebookIn.header);
            headerOut.resetTotalEntries();
            codebookOut.writeCodebookHeader(headerOut);
            i = 0;
            while (i < codebookIn.header.totalEntries) {
                if (acceptanceStatus[i] == OutlierStatus.NON_OUTLIER) {
                    codebookOut.writeEntry(codebookIn.entries[i]);
                }
                ++i;
            }
            codebookOut.close();
            System.out.println("Outliers detected = " + String.valueOf(codebookIn.header.totalEntries - newTotalEntries) + " of " + String.valueOf(codebookIn.header.totalEntries));
            System.out.println("Total lsf outliers = " + String.valueOf(totalLsfOutliers));
            System.out.println("Total f0 outliers = " + String.valueOf(totalF0Outliers));
            System.out.println("Total duration outliers = " + String.valueOf(totalDurationOutliers));
            System.out.println("Total energy outliers = " + String.valueOf(totalEnergyOutliers));
        }
    }
}

