/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePart;
import marytts.util.math.ArrayUtils;

public class FrameNoisePartLpc
implements FrameNoisePart {
    public float[] lpCoeffs;
    public float lpGain;
    public float origAverageSampleEnergy;
    public float origNoiseStd;

    public FrameNoisePartLpc() {
        this.lpCoeffs = null;
        this.lpGain = 0.0f;
        this.origAverageSampleEnergy = 0.0f;
        this.origNoiseStd = 1.0f;
    }

    public FrameNoisePartLpc(FrameNoisePartLpc existing) {
        this.origAverageSampleEnergy = existing.origAverageSampleEnergy;
        this.origNoiseStd = existing.origNoiseStd;
        this.setLpCoeffs(existing.lpCoeffs, existing.lpGain);
    }

    public FrameNoisePartLpc(DataInputStream dis, int numLpcs) {
        this();
        if (numLpcs > 0) {
            this.lpCoeffs = new float[numLpcs];
            int i = 0;
            while (i < numLpcs) {
                try {
                    this.lpCoeffs[i] = dis.readFloat();
                }
                catch (IOException iOException) {
                    System.out.println("Error! At least " + String.valueOf(numLpcs) + " LP coefficients required!");
                }
                ++i;
            }
            try {
                this.lpGain = dis.readFloat();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.origAverageSampleEnergy = dis.readFloat();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.origNoiseStd = dis.readFloat();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public FrameNoisePartLpc(ByteBuffer bb, int numLpcs) {
        this();
        if (numLpcs > 0) {
            this.lpCoeffs = new float[numLpcs];
            int i = 0;
            while (i < numLpcs) {
                try {
                    this.lpCoeffs[i] = bb.getFloat();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("At least " + String.valueOf(numLpcs) + " LP coefficients required!", e);
                }
                ++i;
            }
            this.lpGain = bb.getFloat();
            this.origAverageSampleEnergy = bb.getFloat();
            this.origNoiseStd = bb.getFloat();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int numLpcs = 0;
        if (this.lpCoeffs != null && this.lpCoeffs.length > 0) {
            numLpcs = this.lpCoeffs.length;
        }
        out.writeInt(numLpcs);
        if (numLpcs > 0) {
            int i = 0;
            while (i < this.lpCoeffs.length) {
                out.writeFloat(this.lpCoeffs[i]);
                ++i;
            }
            out.writeFloat(this.lpGain);
            out.writeFloat(this.origAverageSampleEnergy);
            out.writeFloat(this.origNoiseStd);
        }
    }

    public boolean equals(FrameNoisePartLpc other) {
        if (this.lpGain != other.lpGain) {
            return false;
        }
        if (this.origAverageSampleEnergy != other.origAverageSampleEnergy) {
            return false;
        }
        if (this.origNoiseStd != other.origNoiseStd) {
            return false;
        }
        if (this.lpCoeffs != null || other.lpCoeffs != null) {
            if (this.lpCoeffs != null && other.lpCoeffs == null) {
                return false;
            }
            if (this.lpCoeffs == null && other.lpCoeffs != null) {
                return false;
            }
            if (this.lpCoeffs.length != other.lpCoeffs.length) {
                return false;
            }
            int i = 0;
            while (i < this.lpCoeffs.length) {
                if (this.lpCoeffs[i] != other.lpCoeffs[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public int getVectorSize() {
        int lpLen = 0;
        if (this.lpCoeffs != null && this.lpCoeffs.length > 0) {
            lpLen = this.lpCoeffs.length;
        }
        return lpLen;
    }

    @Override
    public int getLength() {
        return 4 * (this.getVectorSize() + 3);
    }

    public void setLpCoeffs(float[] lpCoeffsIn, float gainIn) {
        this.lpCoeffs = ArrayUtils.copy(lpCoeffsIn);
        this.lpGain = gainIn;
    }

    public void setLpCoeffs(double[] lpCoeffsIn, float gainIn) {
        this.lpCoeffs = ArrayUtils.copyDouble2Float(lpCoeffsIn);
        this.lpGain = gainIn;
    }
}

