/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public class LicenseRegistry {
    private static Map<URL, String> remote2local = null;

    public static URL getLicense(URL licenseURL) {
        long startT = System.currentTimeMillis();
        if (remote2local == null) {
            LicenseRegistry.loadLocalLicenses();
        }
        assert (remote2local != null);
        if (!remote2local.containsKey(licenseURL)) {
            LicenseRegistry.downloadLicense(licenseURL);
        }
        String localFilename = remote2local.get(licenseURL);
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        File localFile = new File(downloadDir, localFilename);
        try {
            URL localURL = localFile.toURI().toURL();
            System.out.println("Lookup took " + (System.currentTimeMillis() - startT) + " ms");
            return localURL;
        }
        catch (MalformedURLException e) {
            System.err.println("Cannot create URL from local file " + localFile.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }

    private static void loadLocalLicenses() {
        remote2local = new HashMap<URL, String>();
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        File licenseIndexFile = new File(downloadDir, "license-index.txt");
        if (!licenseIndexFile.canRead()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(licenseIndexFile), "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line = line.trim(), "|");
                    if (!st.hasMoreTokens()) continue;
                    String localFilename = st.nextToken().trim();
                    if (!st.hasMoreTokens()) continue;
                    String remoteURLString = st.nextToken().trim();
                    File localLicenseFile = new File(downloadDir, localFilename);
                    if (!localLicenseFile.canRead()) {
                        System.err.println("License index file " + licenseIndexFile.getAbsolutePath() + " refers to license file " + localLicenseFile.getAbsolutePath() + ", but that file cannot be read. Skipping.");
                        continue;
                    }
                    URL remoteURL = new URL(remoteURLString);
                    remote2local.put(remoteURL, localFilename);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Problem reading local license index file " + licenseIndexFile.getAbsolutePath() + ":");
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void downloadLicense(URL licenseURL) {
        String filename;
        block16: {
            assert (remote2local != null);
            File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
            filename = licenseURL.toString().replace('/', '_').replace(':', '_');
            File licenseFile = new File(downloadDir, filename);
            System.out.println("Downloading license from " + licenseURL.toString());
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileOutputStream out = new FileOutputStream(licenseFile);
                    try {
                        try (InputStream in = licenseURL.openStream();){
                            IOUtils.copy(in, (OutputStream)out);
                        }
                        if (out == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    out.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.err.println("Cannot download license from " + licenseURL.toString());
                e.printStackTrace();
            }
        }
        remote2local.put(licenseURL, filename);
        LicenseRegistry.saveIndex();
    }

    private static void saveIndex() {
        assert (remote2local != null);
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        File licenseIndexFile = new File(downloadDir, "license-index.txt");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(licenseIndexFile), "UTF-8"));){
                for (URL remote : remote2local.keySet()) {
                    pw.println(String.valueOf(remote2local.get(remote)) + "|" + remote.toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Problem updating the index file " + licenseIndexFile.getAbsolutePath());
            e.printStackTrace();
        }
    }
}

