/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.analysis;

import java.util.Arrays;
import marytts.modules.phonemiser.Allophone;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.SelectedUnit;
import marytts.util.data.Datagram;
import marytts.util.math.MathUtils;
import org.apache.commons.lang.ArrayUtils;
import org.w3c.dom.Element;

public class Phone {
    private HalfPhoneTarget leftTarget;
    private HalfPhoneTarget rightTarget;
    private SelectedUnit leftUnit;
    private SelectedUnit rightUnit;
    private double sampleRate;
    private double[] leftF0Targets;
    private double[] rightF0Targets;

    public Phone(SelectedUnit leftUnit, SelectedUnit rightUnit, int sampleRate) throws IllegalArgumentException {
        block4: {
            this.leftUnit = leftUnit;
            this.rightUnit = rightUnit;
            this.sampleRate = sampleRate;
            try {
                this.leftTarget = (HalfPhoneTarget)leftUnit.getTarget();
            }
            catch (NullPointerException nullPointerException) {}
            try {
                this.rightTarget = (HalfPhoneTarget)rightUnit.getTarget();
            }
            catch (NullPointerException nullPointerException) {
                if (this.leftTarget != null) break block4;
                throw new IllegalArgumentException("A phone's left and right halves cannot both be null!");
            }
        }
    }

    public SelectedUnit getLeftUnit() {
        return this.leftUnit;
    }

    public SelectedUnit getRightUnit() {
        return this.rightUnit;
    }

    public HalfPhoneTarget getLeftTarget() {
        return this.leftTarget;
    }

    public HalfPhoneTarget getRightTarget() {
        return this.rightTarget;
    }

    private Datagram[] getUnitFrames(SelectedUnit unit) {
        BaseUnitConcatenator.UnitData unitData = this.getUnitData(unit);
        Datagram[] frames = null;
        try {
            frames = unitData.getFrames();
        }
        catch (NullPointerException nullPointerException) {}
        return frames;
    }

    public Datagram[] getLeftUnitFrames() {
        return this.getUnitFrames(this.leftUnit);
    }

    public Datagram[] getRightUnitFrames() {
        return this.getUnitFrames(this.rightUnit);
    }

    public Datagram[] getUnitDataFrames() {
        Object[] leftUnitFrames = this.getLeftUnitFrames();
        Object[] rightUnitFrames = this.getRightUnitFrames();
        Datagram[] frames = (Datagram[])ArrayUtils.addAll(leftUnitFrames, rightUnitFrames);
        return frames;
    }

    private int getNumberOfUnitFrames(SelectedUnit unit) {
        int numberOfFrames = 0;
        try {
            Datagram[] frames = this.getUnitData(unit).getFrames();
            numberOfFrames = frames.length;
        }
        catch (NullPointerException nullPointerException) {}
        return numberOfFrames;
    }

    public int getNumberOfLeftUnitFrames() {
        return this.getNumberOfUnitFrames(this.leftUnit);
    }

    public int getNumberOfRightUnitFrames() {
        return this.getNumberOfUnitFrames(this.rightUnit);
    }

    public int getNumberOfFrames() {
        return this.getNumberOfLeftUnitFrames() + this.getNumberOfRightUnitFrames();
    }

    public double[] getFrameDurations() {
        Datagram[] frames = this.getUnitDataFrames();
        double[] durations = new double[frames.length];
        int f = 0;
        while (f < frames.length) {
            durations[f] = (double)frames[f].getDuration() / this.sampleRate;
            ++f;
        }
        return durations;
    }

    private double getTargetDuration(HalfPhoneTarget target) {
        double duration = 0.0;
        try {
            duration = target.getTargetDurationInSeconds();
        }
        catch (NullPointerException nullPointerException) {}
        return duration;
    }

    public double getLeftTargetDuration() {
        return this.getTargetDuration(this.leftTarget);
    }

    public double getRightTargetDuration() {
        return this.getTargetDuration(this.rightTarget);
    }

    public double getPredictedDuration() {
        return this.getLeftTargetDuration() + this.getRightTargetDuration();
    }

    private BaseUnitConcatenator.UnitData getUnitData(SelectedUnit unit) {
        BaseUnitConcatenator.UnitData unitData = null;
        try {
            unitData = (BaseUnitConcatenator.UnitData)unit.getConcatenationData();
        }
        catch (NullPointerException nullPointerException) {}
        return unitData;
    }

    public BaseUnitConcatenator.UnitData getLeftUnitData() {
        return this.getUnitData(this.leftUnit);
    }

    public BaseUnitConcatenator.UnitData getRightUnitData() {
        return this.getUnitData(this.rightUnit);
    }

    private double getUnitDuration(SelectedUnit unit) {
        int durationInSamples = 0;
        try {
            durationInSamples = this.getUnitData(unit).getUnitDuration();
        }
        catch (NullPointerException nullPointerException) {}
        double duration = (double)durationInSamples / this.sampleRate;
        return duration;
    }

    public double getLeftUnitDuration() {
        return this.getUnitDuration(this.leftUnit);
    }

    public double getRightUnitDuration() {
        return this.getUnitDuration(this.rightUnit);
    }

    public double getRealizedDuration() {
        return this.getLeftUnitDuration() + this.getRightUnitDuration();
    }

    private double getDurationFactor(SelectedUnit unit, HalfPhoneTarget target) {
        double unitDuration = this.getUnitDuration(unit);
        if (unitDuration <= 0.0) {
            return 0.0;
        }
        double targetDuration = this.getTargetDuration(target);
        double durationFactor = targetDuration / unitDuration;
        return durationFactor;
    }

    public double getLeftDurationFactor() {
        return this.getDurationFactor(this.leftUnit, this.leftTarget);
    }

    public double getRightDurationFactor() {
        return this.getDurationFactor(this.rightUnit, this.rightTarget);
    }

    public double[] getFramewiseDurationFactors() {
        double[] durationFactors = new double[this.getNumberOfFrames()];
        int numberOfLeftUnitFrames = this.getNumberOfLeftUnitFrames();
        double leftDurationFactor = this.getLeftDurationFactor();
        Arrays.fill(durationFactors, 0, numberOfLeftUnitFrames, leftDurationFactor);
        double rightDurationFactor = this.getRightDurationFactor();
        Arrays.fill(durationFactors, numberOfLeftUnitFrames, this.getNumberOfFrames(), rightDurationFactor);
        return durationFactors;
    }

    public void setLeftTargetF0Values(double[] f0TargetValues) throws IllegalArgumentException {
        int numberOfLeftUnitFrames = this.getNumberOfLeftUnitFrames();
        if (f0TargetValues.length != numberOfLeftUnitFrames) {
            throw new IllegalArgumentException("Wrong number of F0 targets (" + f0TargetValues.length + ") for number of frames (" + numberOfLeftUnitFrames + " in halfphone: '" + this.leftUnit.toString() + "'");
        }
        this.leftF0Targets = f0TargetValues;
    }

    public void setRightTargetF0Values(double[] f0TargetValues) {
        if (f0TargetValues.length != this.getNumberOfRightUnitFrames()) {
            throw new IllegalArgumentException("Wrong number of F0 targets (" + f0TargetValues.length + ") for number of frames (" + this.getNumberOfRightUnitFrames() + " in halfphone: '" + this.rightUnit.toString() + "'");
        }
        this.rightF0Targets = f0TargetValues;
    }

    public double[] getLeftTargetF0Values() throws NullPointerException {
        if (this.leftF0Targets == null) {
            throw new NullPointerException("The left target F0 values have not been assigned!");
        }
        return this.leftF0Targets;
    }

    public double[] getRightTargetF0Values() throws NullPointerException {
        if (this.rightF0Targets == null) {
            throw new NullPointerException("The right target F0 values have not been assigned!");
        }
        return this.rightF0Targets;
    }

    public double[] getTargetF0Values() {
        double[] f0Targets = ArrayUtils.addAll(this.leftF0Targets, this.rightF0Targets);
        return f0Targets;
    }

    public double getPredictedF0() {
        double meanF0 = MathUtils.mean(this.getTargetF0Values());
        return meanF0;
    }

    private double[] getUnitFrameDurations(SelectedUnit unit) {
        Datagram[] frames = null;
        try {
            frames = this.getUnitData(unit).getFrames();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        assert (frames != null);
        double[] frameDurations = new double[frames.length];
        int f = 0;
        while (f < frames.length) {
            long frameDuration = frames[f].getDuration();
            frameDurations[f] = (double)frameDuration / this.sampleRate;
            ++f;
        }
        return frameDurations;
    }

    public double[] getLeftUnitFrameDurations() {
        return this.getUnitFrameDurations(this.leftUnit);
    }

    public double[] getRightUnitFrameDurations() {
        return this.getUnitFrameDurations(this.rightUnit);
    }

    public double[] getRealizedFrameDurations() {
        return ArrayUtils.addAll(this.getLeftUnitFrameDurations(), this.getRightUnitFrameDurations());
    }

    private double[] getUnitF0Values(SelectedUnit unit) {
        double[] f0Values = null;
        try {
            double[] durations = this.getUnitFrameDurations(unit);
            if (!ArrayUtils.contains(durations, 0.0)) {
                f0Values = MathUtils.invert(durations);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return f0Values;
    }

    public double[] getLeftUnitFrameF0s() {
        return this.getUnitF0Values(this.leftUnit);
    }

    public double[] getRightUnitFrameF0s() {
        return this.getUnitF0Values(this.rightUnit);
    }

    public double[] getUnitFrameF0s() {
        double[] leftUnitFrameF0s = this.getLeftUnitFrameF0s();
        double[] rightUnitFrameF0s = this.getRightUnitFrameF0s();
        double[] unitFrameF0s = ArrayUtils.addAll(leftUnitFrameF0s, rightUnitFrameF0s);
        return unitFrameF0s;
    }

    public double getRealizedF0() {
        double meanF0 = MathUtils.mean(this.getUnitFrameF0s());
        return meanF0;
    }

    private double[] getUnitF0Factors(SelectedUnit unit, HalfPhoneTarget target) throws ArithmeticException {
        double[] unitF0Values = this.getUnitF0Values(unit);
        if (ArrayUtils.contains(unitF0Values, 0.0)) {
            throw new ArithmeticException("Unit frames must not have F0 of 0!");
        }
        double[] targetF0Values = target == null || target.isLeftHalf() ? this.getLeftTargetF0Values() : this.getRightTargetF0Values();
        double[] f0Factors = null;
        try {
            f0Factors = MathUtils.divide(targetF0Values, unitF0Values);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return f0Factors;
    }

    public double[] getLeftF0Factors() {
        return this.getUnitF0Factors(this.leftUnit, this.leftTarget);
    }

    public double[] getRightF0Factors() {
        return this.getUnitF0Factors(this.rightUnit, this.rightTarget);
    }

    public double[] getF0Factors() {
        return ArrayUtils.addAll(this.getLeftF0Factors(), this.getRightF0Factors());
    }

    private Allophone getAllophone() {
        if (this.leftTarget != null) {
            return this.leftTarget.getAllophone();
        }
        if (this.rightTarget != null) {
            return this.rightTarget.getAllophone();
        }
        return null;
    }

    public boolean isTransient() {
        Allophone allophone = this.getAllophone();
        return allophone.isPlosive() || allophone.isAffricate();
    }

    public boolean isVoiced() {
        Allophone allophone = this.getAllophone();
        return allophone.isVoiced();
    }

    public Element getMaryXMLElement() {
        if (this.leftTarget != null) {
            return this.leftTarget.getMaryxmlElement();
        }
        if (this.rightTarget != null) {
            return this.rightTarget.getMaryxmlElement();
        }
        return null;
    }

    public String toString() {
        String string = "";
        if (this.leftTarget != null) {
            string = String.valueOf(string) + " " + this.leftTarget.getName();
        }
        if (this.rightTarget != null) {
            string = String.valueOf(string) + " " + this.rightTarget.getName();
        }
        return string;
    }
}

