/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.HalfPhoneFeatureFileReader;
import marytts.unitselection.data.Unit;
import marytts.util.data.MaryHeader;

public class FeatureFileReader {
    protected MaryHeader hdr;
    protected FeatureDefinition featureDefinition;
    protected FeatureVector[] featureVectors;

    public static FeatureFileReader getFeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        int fileType = MaryHeader.peekFileType(fileName);
        if (fileType == 300) {
            return new FeatureFileReader(fileName);
        }
        if (fileType == 301) {
            return new HalfPhoneFeatureFileReader(fileName);
        }
        throw new MaryConfigurationException("File " + fileName + ": Type " + fileType + " is not a known unit feature file type");
    }

    public FeatureFileReader() {
    }

    public FeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    public void load(String fileName) throws IOException, MaryConfigurationException {
        this.loadFromByteBuffer(fileName);
    }

    protected void loadFromStream(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.hdr = new MaryHeader(dis);
        if (this.hdr.getType() != 300 && this.hdr.getType() != 301) {
            throw new IOException("File [" + fileName + "] is not a valid Mary feature file.");
        }
        this.featureDefinition = new FeatureDefinition(dis);
        int numberOfUnits = dis.readInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        int i = 0;
        while (i < numberOfUnits) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, dis);
            ++i;
        }
    }

    protected void loadFromByteBuffer(String fileName) throws IOException, MaryConfigurationException {
        FileInputStream fis = new FileInputStream(fileName);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        fis.close();
        this.hdr = new MaryHeader(bb);
        if (this.hdr.getType() != 300 && this.hdr.getType() != 301) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary feature file.");
        }
        this.featureDefinition = new FeatureDefinition(bb);
        int numberOfUnits = bb.getInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        int i = 0;
        while (i < numberOfUnits) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, bb);
            ++i;
        }
    }

    public FeatureVector getFeatureVector(int unitIndex) {
        return this.featureVectors[unitIndex];
    }

    public FeatureVector[] getCopyOfFeatureVectors() {
        return (FeatureVector[])this.featureVectors.clone();
    }

    public FeatureVector[] getFeatureVectors() {
        return this.featureVectors;
    }

    public FeatureVector[] featureVectorMapping(FeatureDefinition newFeatureDefinition) {
        int noContiniousFeatures;
        int noShortFeatures;
        int noByteFeatures;
        if (!this.featureDefinition.contains(newFeatureDefinition)) {
            throw new RuntimeException("the new feature definition is not a subset of original feature definition");
        }
        int numberOfFeatures = newFeatureDefinition.getNumberOfFeatures();
        if (numberOfFeatures != (noByteFeatures = newFeatureDefinition.getNumberOfByteFeatures()) + (noShortFeatures = newFeatureDefinition.getNumberOfShortFeatures()) + (noContiniousFeatures = newFeatureDefinition.getNumberOfContinuousFeatures())) {
            throw new RuntimeException("The sum of byte, short and continious features are not equal to number of features");
        }
        String[] featureNames = new String[numberOfFeatures];
        int j = 0;
        while (j < numberOfFeatures) {
            featureNames[j] = newFeatureDefinition.getFeatureName(j);
            ++j;
        }
        int[] featureIndexes = this.featureDefinition.getFeatureIndexArray(featureNames);
        FeatureVector[] newFV = new FeatureVector[this.getNumberOfUnits()];
        int i = 0;
        while (i < this.getNumberOfUnits()) {
            byte[] byteFeatures = new byte[noByteFeatures];
            short[] shortFeatures = new short[noShortFeatures];
            float[] continiousFeatures = new float[noContiniousFeatures];
            int countByteFeatures = 0;
            int countShortFeatures = 0;
            int countFloatFeatures = 0;
            int j2 = 0;
            while (j2 < featureIndexes.length) {
                if (newFeatureDefinition.isByteFeature(j2)) {
                    byteFeatures[countByteFeatures++] = this.featureVectors[i].getByteFeature(featureIndexes[j2]);
                } else if (newFeatureDefinition.isShortFeature(j2)) {
                    shortFeatures[countShortFeatures++] = this.featureVectors[i].getShortFeature(featureIndexes[j2]);
                } else if (newFeatureDefinition.isContinuousFeature(j2)) {
                    continiousFeatures[countFloatFeatures++] = this.featureVectors[i].getContinuousFeature(featureIndexes[j2]);
                }
                ++j2;
            }
            newFV[i] = newFeatureDefinition.toFeatureVector(i, byteFeatures, shortFeatures, continiousFeatures);
            ++i;
        }
        return newFV;
    }

    public FeatureVector getFeatureVector(Unit unit) {
        return this.featureVectors[unit.index];
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featureDefinition;
    }

    public int getNumberOfUnits() {
        return this.featureVectors.length;
    }
}

