/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import marytts.util.data.Datagram;
import marytts.util.io.General;

public class LPCDatagram
extends Datagram {
    protected short[] quantizedCoeffs;
    protected byte[] quantizedResidual;

    public LPCDatagram(long setDuration, short[] quantizedCoeffs, byte[] quantizedResidual) {
        super(setDuration);
        this.quantizedCoeffs = quantizedCoeffs;
        this.quantizedResidual = quantizedResidual;
    }

    public LPCDatagram(long setDuration, float[] coeffs, short[] residual, float lpcMin, float lpcRange) {
        super(setDuration);
        this.quantizedCoeffs = General.quantize(coeffs, lpcMin, lpcRange);
        this.quantizedResidual = General.shortToUlaw(residual);
    }

    public LPCDatagram(RandomAccessFile raf, int lpcOrder) throws IOException, EOFException {
        super(raf.readLong());
        int len = raf.readInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        if (len < 2 * lpcOrder) {
            throw new IOException("LPC datagram too short (len=" + len + "): cannot be shorter than the space needed for lpc coefficients (2*" + lpcOrder + ")");
        }
        byte[] buf = new byte[len];
        raf.readFully(buf);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        int residualLength = len - 2 * lpcOrder;
        this.quantizedCoeffs = new short[lpcOrder];
        this.quantizedResidual = new byte[residualLength];
        int i = 0;
        while (i < lpcOrder) {
            this.quantizedCoeffs[i] = dis.readShort();
            ++i;
        }
        System.arraycopy(buf, 2 * lpcOrder, this.quantizedResidual, 0, residualLength);
    }

    public LPCDatagram(ByteBuffer bb, int lpcOrder) throws IOException, EOFException {
        super(bb.getLong());
        int len = bb.getInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        if (len < 2 * lpcOrder) {
            throw new IOException("LPC datagram too short (len=" + len + "): cannot be shorter than the space needed for lpc coefficients (2*" + lpcOrder + ")");
        }
        int residualLength = len - 2 * lpcOrder;
        this.quantizedCoeffs = new short[lpcOrder];
        this.quantizedResidual = new byte[residualLength];
        int i = 0;
        while (i < lpcOrder) {
            this.quantizedCoeffs[i] = bb.getShort();
            ++i;
        }
        bb.get(this.quantizedResidual);
    }

    @Override
    public int getLength() {
        return 2 * this.quantizedCoeffs.length + this.quantizedResidual.length;
    }

    public int lpcOrder() {
        return this.quantizedCoeffs.length;
    }

    public short[] getQuantizedCoeffs() {
        return this.quantizedCoeffs;
    }

    public byte[] getQuantizedResidual() {
        return this.quantizedResidual;
    }

    public float[] getCoeffs(float lpcMin, float lpcRange) {
        return General.unQuantize(this.quantizedCoeffs, lpcMin, lpcRange);
    }

    public short[] getResidual() {
        return General.ulawToShort(this.quantizedResidual);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.duration);
        out.writeInt(this.getLength());
        int i = 0;
        while (i < this.quantizedCoeffs.length) {
            out.writeShort(this.quantizedCoeffs[i]);
            ++i;
        }
        out.write(this.quantizedResidual);
    }

    public boolean equals(Datagram other) {
        if (!(other instanceof LPCDatagram)) {
            return false;
        }
        LPCDatagram otherLPC = (LPCDatagram)other;
        if (this.duration != otherLPC.duration) {
            return false;
        }
        if (this.quantizedCoeffs.length != otherLPC.quantizedCoeffs.length) {
            return false;
        }
        if (this.quantizedResidual.length != otherLPC.quantizedResidual.length) {
            return false;
        }
        int i = 0;
        while (i < this.quantizedCoeffs.length) {
            if (this.quantizedCoeffs[i] != otherLPC.quantizedCoeffs[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.quantizedResidual.length) {
            if (this.quantizedResidual[i] != otherLPC.quantizedResidual[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

