/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import marytts.exceptions.MaryConfigurationException;
import marytts.unitselection.data.Unit;
import marytts.util.data.MaryHeader;

public class UnitFileReader {
    private MaryHeader hdr = null;
    private int numberOfUnits = 0;
    private int sampleRate = 0;
    Unit[] units;

    public UnitFileReader() {
    }

    public UnitFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    public void load(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.hdr = new MaryHeader(dis);
        if (this.hdr.getType() != 200) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary Units file.");
        }
        this.numberOfUnits = dis.readInt();
        if (this.numberOfUnits < 0) {
            throw new MaryConfigurationException("File [" + fileName + "] has a negative number of units. Aborting.");
        }
        this.sampleRate = dis.readInt();
        if (this.sampleRate < 0) {
            throw new MaryConfigurationException("File [" + fileName + "] has a negative number sample rate. Aborting.");
        }
        this.units = new Unit[this.numberOfUnits];
        int i = 0;
        while (i < this.numberOfUnits) {
            long startTime = dis.readLong();
            int duration = dis.readInt();
            this.units[i] = new Unit(startTime, duration, i);
            ++i;
        }
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public Unit getUnit(int i) {
        return this.units[i];
    }

    public Unit[] getUnit(int[] i) {
        Unit[] ret = new Unit[i.length];
        int k = 0;
        while (k < i.length) {
            ret[k] = this.getUnit(i[k]);
            ++k;
        }
        return ret;
    }

    public Unit getNextUnit(Unit u) {
        if (u == null || u.index >= this.units.length - 1 || u.index < 0) {
            return null;
        }
        return this.units[u.index + 1];
    }

    public Unit getPreviousUnit(Unit u) {
        if (u == null || u.index >= this.units.length || u.index <= 0) {
            return null;
        }
        return this.units[u.index - 1];
    }

    public boolean isEdgeUnit(int i) {
        return this.units[i].isEdgeUnit();
    }
}

