/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import marytts.exceptions.MaryConfigurationException;
import marytts.server.MaryProperties;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.JoinCostFunction;
import marytts.unitselection.select.Target;
import marytts.util.data.MaryHeader;

public class PrecompiledJoinCostReader
implements JoinCostFunction {
    private MaryHeader hdr = null;
    protected Map left;

    public PrecompiledJoinCostReader() {
    }

    public PrecompiledJoinCostReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName, null, null, 0.0f);
    }

    @Override
    public void init(String configPrefix) throws MaryConfigurationException {
        String precomputedJoinCostFileName = MaryProperties.getFilename(String.valueOf(configPrefix) + ".precomputedJoinCostFile");
        try {
            this.load(precomputedJoinCostFileName, null, null, 0.0f);
        }
        catch (IOException ioe) {
            throw new MaryConfigurationException("Problem loading join file " + precomputedJoinCostFileName, ioe);
        }
    }

    @Override
    public void load(String fileName, InputStream dummy, String dummy2, float dummy3) throws IOException, MaryConfigurationException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.hdr = new MaryHeader(dis);
        if (this.hdr.getType() != 450) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary precompiled join costs file.");
        }
        int numberOfLeftUnits = dis.readInt();
        if (numberOfLeftUnits < 0) {
            throw new MaryConfigurationException("File [" + fileName + "] has a negative number of units. Aborting.");
        }
        this.left = new HashMap();
        int i = 0;
        while (i < numberOfLeftUnits) {
            int leftIndex = dis.readInt();
            int numberOfRightUnits = dis.readInt();
            HashMap<Integer, Float> right = new HashMap<Integer, Float>();
            this.left.put(new Integer(leftIndex), right);
            int j = 0;
            while (j < numberOfRightUnits) {
                int rightIndex = dis.readInt();
                float cost = dis.readFloat();
                right.put(new Integer(rightIndex), new Float(cost));
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double cost(Target t1, Unit uleft, Target t2, Unit uright) {
        Integer leftIndex = new Integer(uleft.index);
        Map rightUnitsMap = (Map)this.left.get(leftIndex);
        if (rightUnitsMap == null) {
            return Double.POSITIVE_INFINITY;
        }
        Integer rightIndex = new Integer(uright.index);
        Float cost = (Float)rightUnitsMap.get(rightIndex);
        if (cost == null) {
            return Double.POSITIVE_INFINITY;
        }
        return cost.doubleValue();
    }
}

