/*
 * Decompiled with CFR 0.152.
 */
package marytts.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import marytts.Version;
import marytts.config.LanguageConfig;
import marytts.config.MaryConfig;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.fst.FSTLookup;
import marytts.htsengine.HMMVoice;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.Mary;
import marytts.server.MaryProperties;
import marytts.signalproc.effects.AudioEffect;
import marytts.signalproc.effects.AudioEffects;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.interpolation.InterpolatingVoice;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AudioDestination;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.string.StringUtils;
import marytts.vocalizations.VocalizationSynthesizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MaryRuntimeUtils {
    private static long lowMemoryThreshold = -1L;
    private static final String audiostoreProperty = MaryProperties.getProperty("synthesis.audiostore", "ram");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureMaryStarted() throws Exception {
        MaryConfig maryConfig = MaryConfig.getMainConfig();
        synchronized (maryConfig) {
            if (Mary.currentState() == 0) {
                Mary.startup();
            }
        }
    }

    public static Object instantiateObject(String objectInitInfo) throws MaryConfigurationException {
        Object obj = null;
        String[] args = null;
        String className = null;
        try {
            if (objectInitInfo.contains("(")) {
                int firstOpenBracket = objectInitInfo.indexOf(40);
                className = objectInitInfo.substring(0, firstOpenBracket);
                int lastCloseBracket = objectInitInfo.lastIndexOf(41);
                args = objectInitInfo.substring(firstOpenBracket + 1, lastCloseBracket).split(",");
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("$")) {
                        args[i] = MaryProperties.getProperty(args[i].substring(1));
                    }
                    args[i] = args[i].trim();
                    ++i;
                }
            } else {
                className = objectInitInfo;
            }
            Class<Object> theClass = Class.forName(className).asSubclass(Object.class);
            if (args != null) {
                Class[] constructorArgTypes = new Class[args.length];
                Object[] constructorArgs = new Object[args.length];
                int i = 0;
                while (i < args.length) {
                    constructorArgTypes[i] = String.class;
                    constructorArgs[i] = args[i];
                    ++i;
                }
                Constructor<Object> constructor = theClass.getConstructor(constructorArgTypes);
                obj = constructor.newInstance(constructorArgs);
            } else {
                obj = theClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Cannot instantiate object from '" + objectInitInfo + "': " + MaryUtils.getFirstMeaningfulMessage(e), e);
        }
        return obj;
    }

    public static boolean lowMemoryCondition() {
        return MaryUtils.availableMemory() < MaryRuntimeUtils.lowMemoryThreshold();
    }

    public static boolean veryLowMemoryCondition() {
        return MaryUtils.availableMemory() < MaryRuntimeUtils.lowMemoryThreshold() / 2L;
    }

    private static long lowMemoryThreshold() {
        if (lowMemoryThreshold < 0L) {
            lowMemoryThreshold = MaryProperties.getInteger("mary.lowmemory", 10000000);
        }
        return lowMemoryThreshold;
    }

    public static String getAudioFileFormatTypes() {
        StringBuilder output = new StringBuilder();
        AudioFileFormat.Type[] audioTypes = AudioSystem.getAudioFileTypes();
        int t = 0;
        while (t < audioTypes.length) {
            AudioFileFormat.Type audioType = audioTypes[t];
            String typeName = audioType.toString();
            boolean isSupported = true;
            if (typeName.equals("MP3")) {
                isSupported = MaryRuntimeUtils.canCreateMP3();
            } else if (typeName.equals("Vorbis")) {
                isSupported = MaryRuntimeUtils.canCreateOgg();
            }
            audioType = MaryAudioUtils.getAudioFileFormatType(typeName);
            if (audioType == null) {
                isSupported = false;
            }
            if (isSupported && AudioSystem.isFileTypeSupported(audioType)) {
                output.append(typeName).append("_FILE\n");
                if (typeName.equals("MP3") || typeName.equals("Vorbis")) {
                    output.append(typeName).append("_STREAM\n");
                }
            }
            ++t;
        }
        return output.toString();
    }

    public static boolean canCreateMP3() {
        return AudioSystem.isConversionSupported(MaryRuntimeUtils.getMP3AudioFormat(), Voice.AF22050);
    }

    public static AudioFormat getMP3AudioFormat() {
        return new AudioFormat(new AudioFormat.Encoding("MPEG1L3"), -1.0f, -1, 1, -1, -1.0f, false);
    }

    public static boolean canCreateOgg() {
        return AudioSystem.isConversionSupported(MaryRuntimeUtils.getOggAudioFormat(), Voice.AF22050);
    }

    public static AudioFormat getOggAudioFormat() {
        return new AudioFormat(new AudioFormat.Encoding("VORBIS"), -1.0f, -1, 1, -1, -1.0f, false);
    }

    public static AllophoneSet determineAllophoneSet(Element e) throws MaryConfigurationException {
        Locale locale;
        AllophoneSet allophoneSet = null;
        Element voice = (Element)MaryDomUtils.getAncestor((Node)e, "voice");
        Voice maryVoice = Voice.getVoice(voice);
        if (maryVoice == null) {
            locale = MaryUtils.string2locale(e.getOwnerDocument().getDocumentElement().getAttribute("xml:lang"));
            maryVoice = Voice.getDefaultVoice(locale);
        }
        if (maryVoice != null) {
            allophoneSet = maryVoice.getAllophoneSet();
        } else {
            locale = MaryUtils.string2locale(e.getOwnerDocument().getDocumentElement().getAttribute("xml:lang"));
            allophoneSet = MaryRuntimeUtils.determineAllophoneSet(locale);
        }
        return allophoneSet;
    }

    public static AllophoneSet determineAllophoneSet(Locale locale) throws MaryConfigurationException {
        AllophoneSet allophoneSet = null;
        String propertyPrefix = MaryProperties.localePrefix(locale);
        if (propertyPrefix != null) {
            String propertyName = String.valueOf(propertyPrefix) + ".allophoneset";
            allophoneSet = MaryRuntimeUtils.needAllophoneSet(propertyName);
        }
        return allophoneSet;
    }

    public static AudioDestination createAudioDestination() throws IOException {
        boolean ram = false;
        ram = audiostoreProperty.equals("ram") ? true : (audiostoreProperty.equals("file") ? false : !MaryRuntimeUtils.lowMemoryCondition());
        return new AudioDestination(ram);
    }

    public static AllophoneSet needAllophoneSet(String propertyName) throws MaryConfigurationException {
        InputStream alloStream;
        String propertyValue = MaryProperties.getProperty(propertyName);
        if (propertyValue == null) {
            throw new MaryConfigurationException("No such property: " + propertyName);
        }
        if (AllophoneSet.hasAllophoneSet(propertyValue)) {
            return AllophoneSet.getAllophoneSetById(propertyValue);
        }
        try {
            alloStream = MaryProperties.needStream(propertyName);
        }
        catch (FileNotFoundException e) {
            throw new MaryConfigurationException("Cannot open allophone stream for property " + propertyName, e);
        }
        assert (alloStream != null);
        return AllophoneSet.getAllophoneSet(alloStream, propertyValue);
    }

    public static String[] checkLexicon(String propertyName, String token) throws IOException, MaryConfigurationException {
        String lexiconProperty = String.valueOf(propertyName) + ".lexicon";
        InputStream lexiconStream = MaryProperties.needStream(lexiconProperty);
        FSTLookup lexicon = new FSTLookup(lexiconStream, lexiconProperty);
        return lexicon.lookup(token.toLowerCase());
    }

    public static String getMaryVersion() {
        String output = "Mary TTS server " + Version.specificationVersion() + " (impl. " + Version.implementationVersion() + ")";
        return output;
    }

    public static String getDataTypes() {
        String output = "";
        List<MaryDataType> allTypes = MaryDataType.getDataTypes();
        for (MaryDataType t : allTypes) {
            output = String.valueOf(output) + t.name();
            if (t.isInputType()) {
                output = String.valueOf(output) + " INPUT";
            }
            if (t.isOutputType()) {
                output = String.valueOf(output) + " OUTPUT";
            }
            output = String.valueOf(output) + System.getProperty("line.separator");
        }
        return output;
    }

    public static String getLocales() {
        StringBuilder out = new StringBuilder();
        for (LanguageConfig conf : MaryConfig.getLanguageConfigs()) {
            for (Locale locale : conf.getLocales()) {
                out.append(locale).append('\n');
            }
        }
        return out.toString();
    }

    public static String getVoices() {
        String output = "";
        Collection<Voice> voices = Voice.getAvailableVoices();
        for (Voice v : voices) {
            if (v instanceof InterpolatingVoice) continue;
            output = v instanceof UnitSelectionVoice ? String.valueOf(output) + v.getName() + " " + v.getLocale() + " " + v.gender().toString() + " " + "unitselection" + " " + ((UnitSelectionVoice)v).getDomain() + System.getProperty("line.separator") : (v instanceof HMMVoice ? String.valueOf(output) + v.getName() + " " + v.getLocale() + " " + v.gender().toString() + " " + "hmm" + System.getProperty("line.separator") : String.valueOf(output) + v.getName() + " " + v.getLocale() + " " + v.gender().toString() + " " + "other" + System.getProperty("line.separator"));
        }
        return output;
    }

    public static String getDefaultVoiceName() {
        StringTokenizer tt2;
        StringTokenizer tt;
        String defaultVoiceName = "";
        String allVoices = MaryRuntimeUtils.getVoices();
        if (allVoices != null && allVoices.length() > 0 && (tt = new StringTokenizer(allVoices, System.getProperty("line.separator"))).hasMoreTokens() && (tt2 = new StringTokenizer(defaultVoiceName = tt.nextToken(), " ")).hasMoreTokens()) {
            defaultVoiceName = tt2.nextToken();
        }
        return defaultVoiceName;
    }

    public static String getExampleText(String datatype, Locale locale) {
        MaryDataType type = MaryDataType.get(datatype);
        String exampleText = type.exampleText(locale);
        if (exampleText != null) {
            return String.valueOf(exampleText.trim()) + System.getProperty("line.separator");
        }
        return "";
    }

    public static Vector<String> getDefaultVoiceExampleTexts() {
        String str;
        String defaultVoiceName = MaryRuntimeUtils.getDefaultVoiceName();
        Vector<String> defaultVoiceExampleTexts = null;
        defaultVoiceExampleTexts = StringUtils.processVoiceExampleText(MaryRuntimeUtils.getVoiceExampleText(defaultVoiceName));
        if (defaultVoiceExampleTexts == null && (str = MaryRuntimeUtils.getExampleText("TEXT", Voice.getVoice(defaultVoiceName).getLocale())) != null && str.length() > 0) {
            defaultVoiceExampleTexts = new Vector();
            defaultVoiceExampleTexts.add(str);
        }
        return defaultVoiceExampleTexts;
    }

    public static String getVoiceExampleText(String voiceName) {
        Voice v = Voice.getVoice(voiceName);
        if (v instanceof UnitSelectionVoice) {
            return ((UnitSelectionVoice)v).getExampleText();
        }
        return "";
    }

    public static String getVocalizations(String voiceName) {
        Voice v = Voice.getVoice(voiceName);
        if (v == null || !v.hasVocalizationSupport()) {
            return "";
        }
        VocalizationSynthesizer vs = v.getVocalizationSynthesizer();
        assert (vs != null);
        String[] vocalizations = vs.listAvailableVocalizations();
        assert (vocalizations != null);
        return StringUtils.toString(vocalizations);
    }

    public static String getStyles(String voiceName) {
        Voice v = Voice.getVoice(voiceName);
        String[] styles = null;
        if (v != null) {
            styles = v.getStyles();
        }
        if (styles != null) {
            return StringUtils.toString(styles);
        }
        return "";
    }

    public static String getDefaultAudioEffects() {
        StringBuilder sb = new StringBuilder();
        for (AudioEffect effect : AudioEffects.getEffects()) {
            sb.append(effect.getName()).append(" ").append(effect.getExampleParameters()).append("\n");
        }
        return sb.toString();
    }

    public static String getAudioEffectDefaultParam(String effectName) {
        AudioEffect effect = AudioEffects.getEffect(effectName);
        if (effect == null) {
            return "";
        }
        return effect.getExampleParameters().trim();
    }

    public static String getFullAudioEffect(String effectName, String currentEffectParams) {
        AudioEffect effect = AudioEffects.getEffect(effectName);
        if (effect == null) {
            return "";
        }
        effect.setParams(currentEffectParams);
        return effect.getFullEffectAsString();
    }

    public static String getAudioEffectHelpText(String effectName) {
        AudioEffect effect = AudioEffects.getEffect(effectName);
        if (effect == null) {
            return "";
        }
        return effect.getHelpText().trim();
    }

    public static String isHmmAudioEffect(String effectName) {
        AudioEffect effect = AudioEffects.getEffect(effectName);
        if (effect == null) {
            return "";
        }
        return effect.isHMMEffect() ? "yes" : "no";
    }
}

