/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.string;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class StringUtils {
    public static String deblank(String str) {
        StringTokenizer s = new StringTokenizer(str, " ", false);
        StringBuilder strRet = new StringBuilder();
        while (s.hasMoreElements()) {
            strRet.append(s.nextElement());
        }
        return strRet.toString();
    }

    public static String join(String glue, String[] items) {
        if (glue == null || items == null) {
            throw new NullPointerException("Null args");
        }
        if (items.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(items[0]);
        int i = 1;
        while (i < items.length) {
            sb.append(glue).append(items[i]);
            ++i;
        }
        return sb.toString();
    }

    public static float string2float(String str) {
        return Float.valueOf(str).floatValue();
    }

    public static double string2double(String str) {
        return Double.valueOf(str);
    }

    public static int string2int(String str) {
        return Integer.valueOf(str);
    }

    public static float[] string2float(String[] strs) {
        float[] values = null;
        if (strs != null && strs.length > 0) {
            values = new float[strs.length];
            int i = 0;
            while (i < strs.length) {
                values[i] = StringUtils.string2float(strs[i]);
                ++i;
            }
        }
        return values;
    }

    public static double[] string2double(String[] strs) {
        double[] values = null;
        if (strs != null && strs.length > 0) {
            values = new double[strs.length];
            int i = 0;
            while (i < strs.length) {
                values[i] = StringUtils.string2double(strs[i]);
                ++i;
            }
        }
        return values;
    }

    public static int[] string2int(String[] strs) {
        int[] values = null;
        if (strs != null && strs.length > 0) {
            values = new int[strs.length];
            int i = 0;
            while (i < strs.length) {
                values[i] = StringUtils.string2int(strs[i]);
                ++i;
            }
        }
        return values;
    }

    public static int[] find(String str, char ch, int stInd, int enInd) {
        int[] indices = null;
        int count = 0;
        if (stInd < 0) {
            stInd = 0;
        }
        if (stInd > str.length() - 1) {
            stInd = str.length() - 1;
        }
        if (enInd < stInd) {
            enInd = stInd;
        }
        if (enInd > str.length() - 1) {
            enInd = str.length() - 1;
        }
        int i = stInd;
        while (i <= enInd) {
            if (str.charAt(i) == ch) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            indices = new int[count];
        }
        int total = 0;
        i = stInd;
        while (i <= enInd) {
            if (str.charAt(i) == ch && total < count) {
                indices[total++] = i;
            }
            ++i;
        }
        return indices;
    }

    public static int[] find(String str, char ch, int stInd) {
        return StringUtils.find(str, ch, stInd, str.length() - 1);
    }

    public static int[] find(String str, char ch) {
        if (str.length() == 0) {
            return null;
        }
        return StringUtils.find(str, ch, 0, str.length() - 1);
    }

    public static String checkLastSlash(String strIn) {
        String strOut = strIn;
        char last = strIn.charAt(strIn.length() - 1);
        if (last != File.separatorChar && last != '\\' && last != '/') {
            strOut = String.valueOf(strOut) + "/";
        }
        return strOut;
    }

    public static String removeLastSlash(String strIn) {
        char last;
        String strOut = strIn;
        while ((last = strOut.charAt(strOut.length() - 1)) == File.separatorChar || last == '\\' || last == '/') {
            strOut = strOut.substring(0, strOut.length() - 1);
        }
        return strOut;
    }

    public static String purgeNonBreakingSpaces(String input) {
        String output = input.replaceAll("\\xA0", " ");
        return output;
    }

    public static String checkFirstDot(String strIn) {
        String strOut = strIn;
        char extensionSeparator = '.';
        char first = strIn.charAt(0);
        if (first != extensionSeparator) {
            strOut = String.valueOf(extensionSeparator) + strOut;
        }
        return strOut;
    }

    public static String[] indexedNameGenerator(String preName, int numFiles) {
        return StringUtils.indexedNameGenerator(preName, numFiles, 1);
    }

    public static String[] indexedNameGenerator(String preName, int numFiles, int startIndex) {
        return StringUtils.indexedNameGenerator(preName, numFiles, startIndex, "");
    }

    public static String[] indexedNameGenerator(String preName, int numFiles, int startIndex, String postName) {
        return StringUtils.indexedNameGenerator(preName, numFiles, startIndex, postName, ".tmp");
    }

    public static String[] indexedNameGenerator(String preName, int numFiles, int startIndex, String postName, String extension) {
        int numDigits = 0;
        if (numFiles > 0) {
            numDigits = (int)Math.floor(Math.log10(startIndex + numFiles - 1));
        }
        return StringUtils.indexedNameGenerator(preName, numFiles, startIndex, postName, extension, numDigits);
    }

    public static String[] indexedNameGenerator(String preName, int numFiles, int startIndex, String postName, String extension, int numDigits) {
        String[] fileList = null;
        if (numFiles > 0) {
            int tmpDigits;
            if (startIndex < 0) {
                startIndex = 0;
            }
            if ((tmpDigits = (int)Math.floor(Math.log10(startIndex + numFiles - 1))) > numDigits) {
                numDigits = tmpDigits;
            }
            fileList = new String[numFiles];
            int i = startIndex;
            while (i < startIndex + numFiles) {
                String strNum = String.valueOf(i);
                while (strNum.length() < numDigits) {
                    strNum = "0" + strNum;
                }
                fileList[i - startIndex] = String.valueOf(preName) + strNum + postName + extension;
                ++i;
            }
        }
        return fileList;
    }

    public static String modifyExtension(String strFilename, String desiredExtension) {
        String strNewname = strFilename;
        String desiredExtension2 = StringUtils.checkFirstDot(desiredExtension);
        int lastDotIndex = strNewname.lastIndexOf(46);
        strNewname = String.valueOf(strNewname.substring(0, lastDotIndex)) + desiredExtension2;
        return strNewname;
    }

    @Deprecated
    public static String getFileExtension(String strFilename, boolean isIncludeDot) {
        int lastDotIndex = strFilename.lastIndexOf(46);
        String strExtension = "";
        if (lastDotIndex > -1) {
            strExtension = isIncludeDot ? strFilename.substring(lastDotIndex, strFilename.length()) : strFilename.substring(lastDotIndex + 1, strFilename.length());
        }
        return strExtension;
    }

    public static int findInMap(int[][] map, int ind0) {
        int i = 0;
        while (i < map.length) {
            if (map[i][0] == ind0) {
                return map[i][1];
            }
            ++i;
        }
        return -1;
    }

    public static int findInMapReverse(int[][] map, int ind1) {
        int i = 0;
        while (i < map.length) {
            if (map[i][1] == ind1) {
                return map[i][0];
            }
            ++i;
        }
        return -1;
    }

    public static boolean isNumeric(String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!Character.isDigit(ch) && ch != '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getFileName(String fullpathFilename, boolean bRemoveExtension) {
        String filename = "";
        int ind1 = fullpathFilename.lastIndexOf(92);
        int ind2 = fullpathFilename.lastIndexOf(47);
        if ((ind1 = Math.max(ind1, ind2)) < 0) {
            ind1 = -1;
        }
        if (ind1 < fullpathFilename.length() - 2) {
            filename = fullpathFilename.substring(ind1 + 1);
        }
        if (bRemoveExtension && (ind1 = filename.lastIndexOf(46)) >= 1) {
            filename = filename.substring(0, ind1);
        }
        return filename;
    }

    public static String getFileName(String fullpathFilename) {
        return StringUtils.getFileName(fullpathFilename, true);
    }

    @Deprecated
    public static String getFolderName(String fullpathFilename) {
        String foldername = "";
        int ind1 = fullpathFilename.lastIndexOf(92);
        int ind2 = fullpathFilename.lastIndexOf(47);
        if ((ind1 = Math.max(ind1, ind2)) >= 0 && ind1 < fullpathFilename.length() - 2) {
            foldername = fullpathFilename.substring(0, ind1 + 1);
        }
        return foldername;
    }

    public static String[] readTextFile(String textFile) throws IOException {
        return StringUtils.readTextFile(textFile, "ASCII");
    }

    public static String[] readTextFile(String textFile, String encoding) throws IOException {
        String[][] tmp = StringUtils.readTextFileInRows(textFile, encoding, 1);
        String[] strRet = new String[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            strRet[i] = tmp[i][0];
            ++i;
        }
        return strRet;
    }

    public static String[][] readTextFileInRows(String textFile, String encoding, int minimumItemsInOneLine) throws IOException {
        String[][] entries = null;
        String allText = FileUtils.readFileToString(new File(textFile), encoding);
        if (allText != null) {
            String[] lines = allText.split("\n");
            entries = StringUtils.parseFromLines(lines, minimumItemsInOneLine, 0, lines.length - 1);
        }
        return entries;
    }

    public static String[][] parseFromLines(String[] lines, int minimumItemsInOneLine, int startLine, int endLine) {
        String[][] labels = null;
        String[][] labelsRet = null;
        if (startLine <= endLine) {
            int j;
            int count = 0;
            int i = startLine;
            while (i <= endLine) {
                String[] labelInfos = null;
                labelInfos = minimumItemsInOneLine > 1 ? lines[i].split(" ") : new String[]{lines[i]};
                boolean isNotEmpty = false;
                j = 0;
                while (j < labelInfos.length) {
                    labelInfos[j] = labelInfos[j].trim();
                    if (labelInfos[j].length() != 0) {
                        isNotEmpty = true;
                    }
                    ++j;
                }
                if (labelInfos.length > 0 && isNotEmpty) {
                    ++count;
                }
                ++i;
            }
            int tmpCount = 0;
            if (count > 0) {
                labels = new String[count][];
                i = startLine;
                while (i <= endLine) {
                    if (tmpCount > count - 1) break;
                    String[] labelInfos = null;
                    labelInfos = minimumItemsInOneLine > 1 ? lines[i].split(" ") : new String[]{lines[i]};
                    boolean isNotEmpty = false;
                    j = 0;
                    while (j < labelInfos.length) {
                        labelInfos[j] = labelInfos[j].trim();
                        if (labelInfos[j].length() != 0) {
                            isNotEmpty = true;
                        }
                        ++j;
                    }
                    if (labelInfos.length > 0 && isNotEmpty) {
                        labels[tmpCount] = new String[minimumItemsInOneLine];
                        j = 0;
                        while (j < Math.min(labelInfos.length, minimumItemsInOneLine)) {
                            labels[tmpCount][j] = labelInfos[j].trim();
                            ++j;
                        }
                        ++tmpCount;
                    }
                    ++i;
                }
                labelsRet = new String[tmpCount][];
                i = 0;
                while (i < tmpCount) {
                    labelsRet[i] = new String[minimumItemsInOneLine];
                    j = 0;
                    while (j < minimumItemsInOneLine) {
                        labelsRet[i][j] = labels[i][j];
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return labelsRet;
    }

    public static int[] getDifferentItemsList(int[] items) {
        int[] differentItems = null;
        int[] indices = StringUtils.getDifferentItemsIndices(items);
        if (indices != null) {
            differentItems = new int[indices.length];
            int i = 0;
            while (i < indices.length) {
                differentItems[i] = items[indices[i]];
                ++i;
            }
        }
        return differentItems;
    }

    public static int[] getDifferentItemsIndices(int[] items) {
        String[] strItems = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strItems[i] = String.valueOf(items[i]);
            ++i;
        }
        return StringUtils.getDifferentItemsIndices(strItems);
    }

    public static String[] getDifferentItemsList(String[] items) {
        String[] differentItems = null;
        int[] indices = StringUtils.getDifferentItemsIndices(items);
        if (indices != null) {
            differentItems = new String[indices.length];
            int i = 0;
            while (i < indices.length) {
                differentItems[i] = items[indices[i]];
                ++i;
            }
        }
        return differentItems;
    }

    public static int[] getDifferentItemsIndices(String[] items) {
        int[] differentItemIndices = null;
        if (items != null) {
            int[] tmpDifferentItemIndices = new int[items.length];
            int differentCount = 1;
            tmpDifferentItemIndices[0] = 0;
            int i = 1;
            while (i < items.length) {
                boolean bDifferent = true;
                int j = 0;
                while (j < differentCount) {
                    if (items[i].compareTo(items[tmpDifferentItemIndices[j]]) == 0) {
                        bDifferent = false;
                        break;
                    }
                    ++j;
                }
                if (bDifferent) {
                    tmpDifferentItemIndices[differentCount] = i;
                    if (++differentCount >= items.length) break;
                }
                ++i;
            }
            differentItemIndices = new int[differentCount];
            System.arraycopy(tmpDifferentItemIndices, 0, differentItemIndices, 0, differentCount);
        }
        return differentItemIndices;
    }

    public static boolean isDesired(int currentFeature, int desiredFeatures) {
        return StringUtils.isDesired(currentFeature, desiredFeatures, 0);
    }

    public static boolean isDesired(int currentFeature, int desiredFeatures, int maxFeatureStringLen) {
        String str1 = Integer.toBinaryString(desiredFeatures);
        String str2 = Integer.toBinaryString(currentFeature);
        if (maxFeatureStringLen < str1.length()) {
            maxFeatureStringLen = str1.length();
        }
        if (maxFeatureStringLen < str2.length()) {
            maxFeatureStringLen = str2.length();
        }
        while (str1.length() < maxFeatureStringLen) {
            str1 = "0" + str1;
        }
        while (str2.length() < maxFeatureStringLen) {
            str2 = "0" + str2;
        }
        boolean bRet = false;
        int i = 0;
        while (i < str1.length()) {
            if (Integer.valueOf(String.valueOf(str1.charAt(i))) == 1 && Integer.valueOf(String.valueOf(str2.charAt(i))) == 1) {
                bRet = true;
                break;
            }
            ++i;
        }
        return bRet;
    }

    public static String getRandomName(int randomNameLength) {
        return StringUtils.getRandomName(null, randomNameLength);
    }

    public static String getRandomName(String preName, int randomNameLength) {
        return StringUtils.getRandomName(preName, randomNameLength, null);
    }

    public static String getRandomName(String preName, int randomNameLength, String postName) {
        String randomName = "";
        while (randomName.length() < randomNameLength) {
            randomName = String.valueOf(randomName) + String.valueOf((int)(10.0 * Math.random()));
        }
        if (preName != null) {
            randomName = String.valueOf(preName) + randomName;
        }
        if (postName != null) {
            randomName = String.valueOf(randomName) + postName;
        }
        return randomName;
    }

    public static String getRandomFileName(String preName, int randomNameLength, String fileExtension) {
        if (fileExtension.charAt(0) != '.') {
            fileExtension = "." + fileExtension;
        }
        return StringUtils.getRandomName(preName, randomNameLength, fileExtension);
    }

    public static boolean isOneOf(String item, String[] list) {
        boolean isFound = false;
        int i = 0;
        while (i < list.length) {
            if (item.compareTo(list[i]) == 0) {
                isFound = true;
                break;
            }
            ++i;
        }
        return isFound;
    }

    @Deprecated
    public static String[] toStringArray(String allInOneLine) {
        if (allInOneLine != "") {
            Vector<String> result = new Vector<String>();
            StringTokenizer s = new StringTokenizer(allInOneLine, System.getProperty("line.separator"));
            String line = null;
            while (s.hasMoreTokens() && (line = s.nextToken()) != null && !line.equals("")) {
                result.add(line);
            }
            return result.toArray(new String[0]);
        }
        return null;
    }

    public static InputStream toInputStream(String str) {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return stream;
    }

    public static InputStream toInputStream(String[] stringArray) {
        return StringUtils.toInputStream(stringArray, 0);
    }

    public static InputStream toInputStream(String[] stringArray, int startIndex) {
        return StringUtils.toInputStream(stringArray, startIndex, stringArray.length);
    }

    public static InputStream toInputStream(String[] stringArray, int startIndex, int endIndex) {
        String str = StringUtils.toString(stringArray, startIndex, endIndex);
        return StringUtils.toInputStream(str);
    }

    public static String toString(String[] stringArray) {
        return StringUtils.toString(stringArray, 0);
    }

    public static String toString(String[] stringArray, int startIndex) {
        return StringUtils.toString(stringArray, startIndex, stringArray.length - 1);
    }

    public static String toString(String[] stringArray, int startIndex, int endIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex > stringArray.length - 1) {
            startIndex = stringArray.length - 1;
        }
        if (endIndex < startIndex) {
            endIndex = startIndex;
        }
        if (endIndex > stringArray.length - 1) {
            endIndex = stringArray.length - 1;
        }
        StringBuilder str = new StringBuilder();
        int i = startIndex;
        while (i <= endIndex) {
            str.append(stringArray[i]).append(System.getProperty("line.separator"));
            ++i;
        }
        return str.toString();
    }

    public static String replace(String str, String pattern, String replacement) {
        int s = 0;
        int e = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replacement);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String urlEncode(String strRequest) {
        String encoded = strRequest;
        try {
            encoded = URLEncoder.encode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encoded;
    }

    public static String urlDecode(String strRequest) {
        String decoded = strRequest;
        try {
            decoded = URLDecoder.decode(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return decoded;
    }

    public static Vector<String> processVoiceExampleText(String text) {
        StringTokenizer st = new StringTokenizer(text, "#");
        Vector<String> sentences = null;
        while (st.hasMoreTokens()) {
            if (sentences == null) {
                sentences = new Vector<String>();
            }
            sentences.add(st.nextToken());
        }
        return sentences;
    }

    public static String toString(double[][] array) {
        String str = "";
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                str = String.valueOf(str) + String.valueOf(array[i][j]);
                if (j < array[i].length - 1) {
                    str = String.valueOf(str) + " ";
                }
                ++j;
            }
            str = String.valueOf(str) + System.getProperty("line.separator");
            ++i;
        }
        str = String.valueOf(str) + System.getProperty("line.separator");
        return str;
    }

    public static boolean isLetterOrModifier(int codePoint) {
        int type = Character.getType(codePoint);
        return type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 6 || type == 8 || type == 7;
    }

    public static String[] toStringLines(double[] x) {
        String[] y = null;
        if (x != null && x.length > 0) {
            y = new String[x.length];
            int i = 0;
            while (i < x.length) {
                y[i] = String.valueOf(x[i]);
                ++i;
            }
        }
        return y;
    }

    public static String[] toStringLines(float[] x) {
        String[] y = null;
        if (x != null && x.length > 0) {
            y = new String[x.length];
            int i = 0;
            while (i < x.length) {
                y[i] = String.valueOf(x[i]);
                ++i;
            }
        }
        return y;
    }

    public static String[] toStringLines(int[] x) {
        String[] y = null;
        if (x != null && x.length > 0) {
            y = new String[x.length];
            int i = 0;
            while (i < x.length) {
                y[i] = String.valueOf(x[i]);
                ++i;
            }
        }
        return y;
    }

    public static int[] parseIntPairs(String attribute) {
        if (attribute == null) {
            throw new NullPointerException("Received null argument");
        }
        Pattern p = Pattern.compile("(\\d+,\\d+)");
        int[] temp = new int[attribute.length() / 2];
        Matcher m = p.matcher(attribute);
        int i = 0;
        while (m.find()) {
            String[] f0Values = m.group().trim().split(",");
            temp[2 * i] = Integer.parseInt(f0Values[0]);
            temp[2 * i + 1] = Integer.parseInt(f0Values[1]);
            ++i;
        }
        int[] result = new int[2 * i];
        System.arraycopy(temp, 0, result, 0, result.length);
        return result;
    }

    public static void main(String[] args) throws Exception {
        String[] items1 = StringUtils.readTextFile("D:\\items.txt", "ASCII");
        StringUtils.getDifferentItemsIndices(items1);
        StringUtils.getDifferentItemsList(items1);
        int[] items2 = new int[]{1, 2, 3, 4, 1, 1, 2, 2, 4, 4, 10};
        StringUtils.getDifferentItemsIndices(items2);
        StringUtils.getDifferentItemsList(items2);
        System.out.println("Test completed....");
    }
}

