/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryXML;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureDefinition;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.data.Unit;
import marytts.util.MaryUtils;
import marytts.vocalizations.FDPSOLASynthesisTechnology;
import marytts.vocalizations.HNMSynthesisTechnology;
import marytts.vocalizations.MLSASynthesisTechnology;
import marytts.vocalizations.SourceTargetPair;
import marytts.vocalizations.VocalizationSelector;
import marytts.vocalizations.VocalizationSynthesisTechnology;
import marytts.vocalizations.VocalizationUnit;
import marytts.vocalizations.VocalizationUnitFileReader;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class VocalizationSynthesizer {
    protected VocalizationSynthesisTechnology vSynthesizer;
    protected VocalizationSelector vSelector;
    protected VocalizationUnitFileReader unitFileReader;
    protected boolean f0ContourImposeSupport;
    protected Logger logger = MaryUtils.getLogger("Vocalization Synthesizer");

    public VocalizationSynthesizer(Voice voice) throws MaryConfigurationException {
        if (!voice.hasVocalizationSupport()) {
            throw new MaryConfigurationException("This voice " + voice.toString() + " doesn't support synthesis of vocalizations");
        }
        String unitFileName = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.unitfile");
        try {
            this.unitFileReader = new VocalizationUnitFileReader(unitFileName);
        }
        catch (IOException iOException) {
            throw new MaryConfigurationException("can't read unit file");
        }
        String intonationFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.intonationfile");
        String technology = MaryProperties.getProperty("voice." + voice.getName() + ".vocalization.synthesisTechnology", "fdpsola");
        this.f0ContourImposeSupport = MaryProperties.getBoolean("voice." + voice.getName() + ".f0ContourImposeSupport", false);
        if ("fdpsola".equals(technology)) {
            String timelineFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.timeline");
            this.vSynthesizer = new FDPSOLASynthesisTechnology(timelineFile, unitFileName, intonationFile, this.f0ContourImposeSupport);
        } else if ("mlsa".equals(technology)) {
            boolean imposePolynomialContour = MaryProperties.getBoolean("voice." + voice.getName() + ".vocalization.imposePolynomialContour", true);
            String mlsaFeatureFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.mlsafeaturefile");
            String mixedExcitationFilter = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.mixedexcitationfilter");
            this.vSynthesizer = new MLSASynthesisTechnology(mlsaFeatureFile, intonationFile, mixedExcitationFilter, imposePolynomialContour);
        } else if ("hnm".equals(technology)) {
            String timelineFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.timeline");
            String hnmFeatureFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.hnmfeaturefile");
            this.vSynthesizer = new HNMSynthesisTechnology(timelineFile, unitFileName, hnmFeatureFile, intonationFile, this.f0ContourImposeSupport);
        } else {
            throw new MaryConfigurationException("the property 'voice." + voice.getName() + ".vocalization.synthesisTechnology' should be one among 'hnm', 'mlsa' and 'fdpsola'");
        }
        this.vSelector = new VocalizationSelector(voice);
    }

    public AudioInputStream synthesize(Voice voice, AudioFileFormat aft, Element domElement) throws Exception {
        if (!voice.hasVocalizationSupport()) {
            return null;
        }
        if (domElement.hasAttribute("variant")) {
            return this.synthesizeVariant(aft, domElement);
        }
        if (this.f0ContourImposeSupport) {
            return this.synthesizeImposedIntonation(aft, domElement);
        }
        return this.synthesizeVocalization(aft, domElement);
    }

    private AudioInputStream synthesizeVariant(AudioFileFormat aft, Element domElement) throws SynthesisException {
        int numberOfBackChannels = this.unitFileReader.getNumberOfUnits();
        int backchannelNumber = 0;
        if (domElement.hasAttribute("variant")) {
            backchannelNumber = Integer.parseInt(domElement.getAttribute("variant"));
        }
        if (backchannelNumber >= numberOfBackChannels) {
            throw new IllegalArgumentException("This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + backchannelNumber);
        }
        return this.synthesizeSelectedVocalization(backchannelNumber, aft, domElement);
    }

    private AudioInputStream synthesizeVocalization(AudioFileFormat aft, Element domElement) throws SynthesisException {
        int numberOfBackChannels = this.unitFileReader.getNumberOfUnits();
        int backchannelNumber = this.vSelector.getBestMatchingCandidate(domElement);
        assert (backchannelNumber < numberOfBackChannels) : "This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + backchannelNumber;
        return this.synthesizeSelectedVocalization(backchannelNumber, aft, domElement);
    }

    private AudioInputStream synthesizeImposedIntonation(AudioFileFormat aft, Element domElement) throws SynthesisException {
        SourceTargetPair imposeF0Data = this.vSelector.getBestCandidatePairtoImposeF0(domElement);
        int targetIndex = imposeF0Data.getTargetUnitIndex();
        int sourceIndex = imposeF0Data.getSourceUnitIndex();
        this.logger.debug("Synthesizing candidate " + sourceIndex + " with intonation contour " + targetIndex);
        if (targetIndex == sourceIndex) {
            return this.synthesizeSelectedVocalization(sourceIndex, aft, domElement);
        }
        return this.imposeF0ContourOnVocalization(sourceIndex, targetIndex, aft, domElement);
    }

    private AudioInputStream imposeF0ContourOnVocalization(int sourceIndex, int targetIndex, AudioFileFormat aft, Element domElement) throws SynthesisException {
        int numberOfBackChannels = this.unitFileReader.getNumberOfUnits();
        if (targetIndex >= numberOfBackChannels) {
            throw new IllegalArgumentException("This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + targetIndex);
        }
        if (sourceIndex >= numberOfBackChannels) {
            throw new IllegalArgumentException("This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + sourceIndex);
        }
        VocalizationUnit bUnit = this.unitFileReader.getUnit(sourceIndex);
        Unit[] units = bUnit.getUnits();
        String[] unitNames = bUnit.getUnitNames();
        long endTime = 0L;
        int i = 0;
        while (i < units.length) {
            int unitDuration = units[i].duration * 1000 / this.unitFileReader.getSampleRate();
            Element element = MaryXML.createElement(domElement.getOwnerDocument(), "ph");
            element.setAttribute("d", Integer.toString(unitDuration));
            element.setAttribute("end", Long.toString(endTime += (long)unitDuration));
            element.setAttribute("p", unitNames[i]);
            domElement.appendChild(element);
            ++i;
        }
        return this.vSynthesizer.synthesizeUsingImposedF0(sourceIndex, targetIndex, aft);
    }

    private AudioInputStream synthesizeSelectedVocalization(int backchannelNumber, AudioFileFormat aft, Element domElement) throws SynthesisException {
        int numberOfBackChannels = this.unitFileReader.getNumberOfUnits();
        if (backchannelNumber >= numberOfBackChannels) {
            throw new IllegalArgumentException("This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + backchannelNumber);
        }
        VocalizationUnit bUnit = this.unitFileReader.getUnit(backchannelNumber);
        Unit[] units = bUnit.getUnits();
        String[] unitNames = bUnit.getUnitNames();
        long endTime = 0L;
        int i = 0;
        while (i < units.length) {
            int unitDuration = units[i].duration * 1000 / this.unitFileReader.getSampleRate();
            Element element = MaryXML.createElement(domElement.getOwnerDocument(), "ph");
            element.setAttribute("d", Integer.toString(unitDuration));
            element.setAttribute("end", Long.toString(endTime += (long)unitDuration));
            element.setAttribute("p", unitNames[i]);
            domElement.appendChild(element);
            ++i;
        }
        return this.vSynthesizer.synthesize(backchannelNumber, aft);
    }

    public String[] listAvailableVocalizations() {
        FeatureDefinition featureDefinition = this.vSelector.getFeatureDefinition();
        assert (featureDefinition.hasFeature("name"));
        int nameIndex = featureDefinition.getFeatureIndex("name");
        return featureDefinition.getPossibleValues(nameIndex);
    }
}

