/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import marytts.client.AudioEffectControlData;
import marytts.client.AudioEffectsBoxGUI;
import marytts.client.MaryClient;
import marytts.client.http.MaryHttpClient;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.http.Address;
import marytts.util.io.SimpleFileFilter;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

public class MaryGUIClient
extends JPanel {
    private Dimension paneDimension;
    private JPanel inputTypePanel;
    private JComboBox cbInputType;
    private JPanel inputPanel;
    private JScrollPane inputScrollPane;
    private JTextPane inputText;
    private JPanel voicePanel;
    private JComboBox cbDefaultVoice;
    private JComboBox cbVoiceExampleText;
    private boolean doReplaceInput = true;
    private boolean showingTextOutput = true;
    private JPanel outputTypePanel;
    private JComboBox cbOutputType;
    private JButton bSaveOutput;
    private JTextPane outputText;
    private JScrollPane outputScrollPane;
    private JPanel audioPanel;
    private JButton bPlay;
    private JPanel savePanel;
    private boolean isButtonHide = true;
    private boolean showingAudioEffects = false;
    private JPanel showHidePanel;
    private JButton showHideEffects;
    private JList effectsList;
    private AudioEffectsBoxGUI effectsBox;
    private String[] effectNames;
    private String[] exampleParams;
    private String[] helpTexts;
    private JPanel buttonPanel;
    private JButton bProcess;
    private JButton bEdit;
    private JButton bCompare;
    static JFrame mainFrame;
    static JApplet mainApplet;
    private MaryClient processor;
    private AudioPlayer audioPlayer = null;
    private boolean allowSave;
    private boolean streamMp3 = false;
    private MaryClient.Voice prevVoice = null;
    private Map<String, Vector<String>> limDomVoices = new HashMap<String, Vector<String>>();
    private GridBagLayout gridBagLayout;
    private GridBagConstraints gridC;
    static FocusTraversalPolicy maryGUITraversal;
    private File lastDirectory = null;
    private String lastExtension = null;

    public MaryGUIClient() throws Exception {
        try {
            this.processor = MaryClient.getMaryClient();
            this.streamMp3 = Boolean.getBoolean("stream.mp3");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Cannot connect to server", 0);
            System.exit(1);
        }
        this.allowSave = true;
        this.init();
    }

    public MaryGUIClient(Address hostAddress, JApplet applet) throws IOException {
        try {
            this.processor = new MaryHttpClient(hostAddress, false, false);
        }
        catch (Exception e) {
            System.out.println("Problem creating mary client");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Cannot connect to server", 0);
            System.exit(1);
        }
        mainApplet = applet;
        this.allowSave = false;
        this.init();
    }

    public void init() throws IOException {
        maryGUITraversal = new MaryGUIFocusTraversalPolicy();
        if (mainFrame != null) {
            mainFrame.setFocusTraversalPolicy(maryGUITraversal);
        } else {
            mainApplet.setFocusTraversalPolicy(maryGUITraversal);
        }
        this.paneDimension = new Dimension(250, 400);
        this.gridBagLayout = new GridBagLayout();
        this.gridC = new GridBagConstraints();
        this.gridC.insets = new Insets(2, 2, 2, 2);
        this.gridC.weightx = 0.1;
        this.gridC.weighty = 0.1;
        this.setLayout(this.gridBagLayout);
        this.inputTypePanel = new JPanel();
        this.inputTypePanel.setLayout(new FlowLayout(3));
        this.gridC.gridx = 0;
        this.gridC.gridy = 0;
        this.gridC.gridwidth = 3;
        this.gridC.fill = 2;
        this.gridBagLayout.setConstraints(this.inputTypePanel, this.gridC);
        this.add(this.inputTypePanel);
        this.gridC.gridwidth = 1;
        JLabel inputTypeLabel = new JLabel("Input Type: ");
        this.inputTypePanel.add(inputTypeLabel);
        assert (this.processor.getInputDataTypes().size() > 0);
        assert (this.processor.getOutputDataTypes().size() > 0);
        this.cbInputType = new JComboBox<MaryClient.DataType>(this.processor.getInputDataTypes());
        this.cbInputType.setName("Input Type");
        this.cbInputType.getAccessibleContext().setAccessibleName("Input Type selection");
        this.cbInputType.setToolTipText("Specify the type of data contained in the input text area below.");
        this.cbInputType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MaryGUIClient.this.verifyExamplesVisible();
                    if (MaryGUIClient.this.doReplaceInput) {
                        MaryGUIClient.this.setExampleInputText();
                    } else {
                        MaryGUIClient.this.doReplaceInput = true;
                    }
                }
            }
        });
        this.inputTypePanel.add(this.cbInputType);
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 1));
        this.inputPanel.setMinimumSize(this.paneDimension);
        this.inputPanel.setPreferredSize(this.paneDimension);
        this.gridC.gridx = 0;
        this.gridC.gridy = 1;
        this.gridC.gridwidth = 3;
        this.gridC.gridheight = 3;
        this.gridC.weightx = 0.4;
        this.gridC.weighty = 0.8;
        this.gridC.fill = 1;
        this.gridBagLayout.setConstraints(this.inputPanel, this.gridC);
        this.add(this.inputPanel);
        this.gridC.gridwidth = 1;
        this.gridC.gridheight = 1;
        this.gridC.weightx = 0.1;
        this.gridC.weighty = 0.1;
        this.gridC.ipadx = 0;
        this.gridC.ipady = 0;
        this.gridC.fill = 0;
        this.inputText = new JTextPane();
        this.inputText.getAccessibleContext().setAccessibleName("Input Text Area");
        HashSet<KeyStroke> forwardKeys = new HashSet<KeyStroke>();
        forwardKeys.add(KeyStroke.getKeyStroke(9, 0, false));
        this.inputText.setFocusTraversalKeys(0, forwardKeys);
        HashSet<KeyStroke> backwardKeys = new HashSet<KeyStroke>();
        backwardKeys.add(KeyStroke.getKeyStroke(9, 65, false));
        this.inputText.setFocusTraversalKeys(1, backwardKeys);
        this.inputScrollPane = new JScrollPane(this.inputText);
        this.inputPanel.add(this.inputScrollPane);
        this.inputScrollPane.setPreferredSize(new Dimension(this.inputPanel.getPreferredSize().width, 1000));
        this.cbVoiceExampleText = new JComboBox();
        this.cbVoiceExampleText.setName("Example Text");
        this.cbVoiceExampleText.getAccessibleContext().setAccessibleName("Example text selection");
        this.cbVoiceExampleText.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && MaryGUIClient.this.doReplaceInput && ((MaryClient.DataType)MaryGUIClient.this.cbInputType.getSelectedItem()).name().startsWith("TEXT")) {
                    MaryGUIClient.this.setInputText((String)MaryGUIClient.this.cbVoiceExampleText.getSelectedItem());
                }
            }
        });
        this.cbVoiceExampleText.setPreferredSize(new Dimension(this.inputPanel.getPreferredSize().width, 25));
        this.inputPanel.add(this.cbVoiceExampleText);
        this.voicePanel = new JPanel();
        this.voicePanel.setLayout(new FlowLayout(3));
        this.gridC.gridx = 0;
        this.gridC.gridy = 4;
        this.gridC.gridwidth = 4;
        this.gridC.gridheight = 2;
        this.gridC.fill = 2;
        this.gridBagLayout.setConstraints(this.voicePanel, this.gridC);
        this.add(this.voicePanel);
        this.gridC.gridwidth = 1;
        this.gridC.gridheight = 1;
        JLabel voiceLabel = new JLabel("Voice:");
        this.voicePanel.add(voiceLabel);
        this.cbDefaultVoice = new JComboBox();
        this.cbDefaultVoice.setName("Voice selection");
        this.cbDefaultVoice.getAccessibleContext().setAccessibleName("Voice selection");
        this.voicePanel.add(this.cbDefaultVoice);
        this.cbDefaultVoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MaryGUIClient.this.fillExampleTexts();
                    MaryGUIClient.this.verifyExamplesVisible();
                    MaryClient.Voice voice = (MaryClient.Voice)MaryGUIClient.this.cbDefaultVoice.getSelectedItem();
                    MaryClient.DataType dataType = (MaryClient.DataType)MaryGUIClient.this.cbInputType.getSelectedItem();
                    if (MaryGUIClient.this.doReplaceInput && (voice.isLimitedDomain() && dataType.name().startsWith("TEXT") || MaryGUIClient.this.getPrevVoice() == null || !MaryGUIClient.this.getPrevVoice().getLocale().equals(voice.getLocale()))) {
                        MaryGUIClient.this.setExampleInputText();
                    }
                    MaryGUIClient.this.setPrevVoice(voice);
                    MaryGUIClient.this.updateAudioEffects();
                }
            }
        });
        Vector<MaryClient.Voice> voices = this.processor.getVoices();
        if (voices != null) {
            for (MaryClient.Voice v : voices) {
                if (!v.isLimitedDomain()) continue;
                this.limDomVoices.put(v.name(), this.processor.getVoiceExampleTextsLimitedDomain(v.name()));
            }
        }
        this.verifyDefaultVoices();
        this.fillExampleTexts();
        this.verifyExamplesVisible();
        this.setExampleInputText();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.gridC.gridx = 3;
        this.gridC.gridy = 1;
        this.gridC.gridheight = 3;
        this.gridC.fill = 1;
        this.gridBagLayout.setConstraints(this.buttonPanel, this.gridC);
        this.add(this.buttonPanel);
        this.bProcess = new JButton("Process ->");
        this.bProcess.setToolTipText("Call the Mary Server.The input will be transformed into the specified output type.");
        this.bProcess.getAccessibleContext().setAccessibleName("Process button");
        this.bProcess.setActionCommand("process");
        this.bProcess.setMnemonic('P');
        this.bProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaryGUIClient.this.processInput();
                MaryGUIClient.this.verifyEnableButtons();
            }
        });
        this.buttonPanel.add(Box.createVerticalGlue());
        this.buttonPanel.add(this.bProcess);
        this.bProcess.setAlignmentX(0.5f);
        this.buttonPanel.add(Box.createVerticalGlue());
        this.bEdit = new JButton("<- Edit");
        this.bEdit.setToolTipText("Edit the content of the output text area as the new input. The current content of the input text area will be discarded.");
        this.bEdit.getAccessibleContext().setAccessibleName("Edit button");
        this.bEdit.setActionCommand("edit");
        this.bEdit.setMnemonic('E');
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaryGUIClient.this.editOutput();
                MaryGUIClient.this.verifyEnableButtons();
            }
        });
        this.buttonPanel.add(this.bEdit);
        this.bEdit.setAlignmentX(0.5f);
        this.buttonPanel.add(Box.createVerticalGlue());
        this.bCompare = new JButton("<- Compare ->");
        this.bCompare.setToolTipText("Compare input and output(available only if both are MaryXML types).");
        this.bCompare.getAccessibleContext().setAccessibleName("Compare button");
        this.bCompare.setActionCommand("compare");
        this.bCompare.setMnemonic('C');
        this.bCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaryGUIClient.this.compareTexts();
                MaryGUIClient.this.verifyEnableButtons();
            }
        });
        this.buttonPanel.add(this.bCompare);
        this.bCompare.setAlignmentX(0.5f);
        this.buttonPanel.add(Box.createVerticalGlue());
        this.buttonPanel.setPreferredSize(new Dimension(this.buttonPanel.getPreferredSize().width, this.paneDimension.height));
        this.outputTypePanel = new JPanel();
        this.outputTypePanel.setLayout(new FlowLayout(4));
        this.gridC.gridx = 4;
        this.gridC.gridy = 0;
        this.gridC.gridwidth = 3;
        this.gridC.gridheight = 1;
        this.gridC.ipady = 10;
        this.gridC.fill = 2;
        this.gridBagLayout.setConstraints(this.outputTypePanel, this.gridC);
        this.add(this.outputTypePanel);
        this.gridC.ipady = 0;
        this.gridC.gridwidth = 1;
        JLabel outputTypeLabel = new JLabel("Output Type: ");
        this.outputTypePanel.add(outputTypeLabel);
        this.cbOutputType = new JComboBox();
        this.cbOutputType.setName("Output type");
        this.cbOutputType.getAccessibleContext().setAccessibleName("Output type selection");
        this.setOutputTypeItems();
        this.cbOutputType.setSelectedIndex(this.cbOutputType.getItemCount() - 1);
        this.cbOutputType.setToolTipText("Specify the output type for the next processing action (Process button).");
        this.cbOutputType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MaryGUIClient.this.verifyOutputDisplay();
                    MaryGUIClient.this.verifyEnableButtons();
                    MaryGUIClient.this.revalidate();
                }
            }
        });
        this.outputTypePanel.add(this.cbOutputType);
        this.showingTextOutput = ((MaryClient.DataType)this.cbOutputType.getSelectedItem()).isTextType();
        this.outputText = new JTextPane();
        this.outputText.getAccessibleContext().setAccessibleName("Output text");
        this.outputText.setFocusTraversalKeys(0, forwardKeys);
        this.outputText.setFocusTraversalKeys(1, backwardKeys);
        this.outputText.setEditable(false);
        this.outputScrollPane = new JScrollPane(this.outputText);
        this.outputScrollPane.setMinimumSize(this.paneDimension);
        this.outputScrollPane.setPreferredSize(this.paneDimension);
        this.gridC.gridx = 4;
        this.gridC.gridy = 1;
        this.gridC.gridwidth = 3;
        this.gridC.gridheight = 3;
        this.gridC.weightx = 0.4;
        this.gridC.weighty = 0.8;
        this.gridC.fill = 1;
        this.gridBagLayout.setConstraints(this.outputScrollPane, this.gridC);
        if (!this.showingTextOutput) {
            this.outputScrollPane.setVisible(false);
        }
        this.add(this.outputScrollPane);
        this.setAudioEffects();
        this.isButtonHide = false;
        if (this.effectsBox.hasEffects()) {
            this.gridC.gridx = 4;
            this.gridC.gridy = 1;
            this.gridC.gridwidth = 3;
            this.gridC.gridheight = 3;
            this.gridC.weightx = 0.1;
            this.gridC.weighty = 0.1;
            this.gridC.ipadx = 0;
            this.gridC.ipady = 0;
            this.gridC.fill = 1;
            this.gridBagLayout.setConstraints(this.effectsBox.mainPanel, this.gridC);
            this.add(this.effectsBox.mainPanel);
            this.updateAudioEffects();
            if (this.effectsBox != null && this.effectsBox.mainPanel != null) {
                this.showHidePanel = new JPanel();
                this.showHidePanel.setPreferredSize(this.paneDimension);
                this.showHidePanel.setLayout(new BoxLayout(this.showHidePanel, 1));
                if (!this.showingTextOutput) {
                    this.showHideEffects = new JButton("Hide Effects");
                    this.isButtonHide = true;
                } else {
                    this.showHideEffects = new JButton("Show Effects");
                    this.isButtonHide = false;
                }
                this.showHideEffects.setToolTipText("Hide or show available audio effects for post-processing the TTS output");
                this.showHideEffects.getAccessibleContext().setAccessibleName("Hide/Show audio effects button");
                this.showHideEffects.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MaryGUIClient.this.showHideEffectAction();
                    }
                });
                this.showHidePanel.add(Box.createVerticalGlue());
                this.showHidePanel.add(this.showHideEffects);
                this.showHidePanel.add(Box.createVerticalGlue());
                this.showHideEffects.setAlignmentX(0.5f);
                this.gridC.gridx = 4;
                this.gridC.gridy = !this.showingTextOutput ? 4 : 3;
                this.gridC.gridwidth = 3;
                this.gridC.gridheight = 1;
                this.gridC.ipady = 10;
                this.gridC.fill = 1;
                this.gridBagLayout.setConstraints(this.showHidePanel, this.gridC);
                this.add(this.showHidePanel);
                this.gridC.ipady = 0;
                if (this.effectsBox.mainPanel != null) {
                    if (!this.showingTextOutput && this.isButtonHide) {
                        this.effectsBox.mainPanel.setVisible(true);
                        this.showingAudioEffects = true;
                    } else {
                        this.effectsBox.mainPanel.setVisible(false);
                        this.showingAudioEffects = false;
                    }
                }
            }
        }
        this.gridC.gridwidth = 1;
        this.gridC.gridheight = 1;
        this.gridC.weightx = 0.1;
        this.gridC.weighty = 0.1;
        this.gridC.ipadx = 0;
        this.gridC.ipady = 0;
        this.gridC.fill = 0;
        this.audioPanel = new JPanel();
        this.audioPanel.setPreferredSize(this.paneDimension);
        this.audioPanel.setLayout(new BoxLayout(this.audioPanel, 1));
        this.bPlay = new JButton("Play");
        this.bPlay.setToolTipText("Synthesize and play the resulting audio stream.");
        this.bPlay.getAccessibleContext().setAccessibleName("Play button");
        this.bPlay.setActionCommand("play");
        this.bPlay.setMnemonic('P');
        this.bPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaryGUIClient.this.audioPlayer != null) {
                    MaryGUIClient.this.audioPlayer.cancel();
                    MaryGUIClient.this.audioPlayer = null;
                    MaryGUIClient.this.bPlay.setText("Play");
                } else {
                    MaryGUIClient.this.processInput();
                }
            }
        });
        this.audioPanel.add(Box.createVerticalGlue());
        this.audioPanel.add(this.bPlay);
        this.audioPanel.add(Box.createVerticalGlue());
        this.bPlay.setAlignmentX(0.5f);
        if (this.showingTextOutput) {
            this.audioPanel.setVisible(false);
        }
        this.gridC.gridx = 4;
        this.gridC.gridy = this.showingAudioEffects ? 5 : 4;
        this.gridC.gridwidth = 3;
        this.gridC.gridheight = 1;
        this.gridC.ipady = 10;
        this.gridC.fill = 1;
        this.gridBagLayout.setConstraints(this.audioPanel, this.gridC);
        this.add(this.audioPanel);
        this.gridC.gridwidth = 1;
        this.gridC.ipady = 0;
        if (this.allowSave) {
            this.savePanel = new JPanel();
            this.savePanel.setLayout(new FlowLayout(4));
            this.gridC.gridx = 4;
            this.gridC.ipady = 10;
            this.gridC.gridy = this.showingAudioEffects ? 6 : 5;
            this.gridC.fill = 2;
            this.gridBagLayout.setConstraints(this.savePanel, this.gridC);
            this.add(this.savePanel);
            ImageIcon saveIcon = new ImageIcon("save.gif");
            this.bSaveOutput = new JButton("Save...", saveIcon);
            this.bSaveOutput.setToolTipText("Save the output as a file.");
            this.bSaveOutput.getAccessibleContext().setAccessibleName("Save Output button");
            this.bSaveOutput.setActionCommand("saveOutput");
            this.bSaveOutput.setMnemonic('S');
            this.bSaveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MaryGUIClient.this.saveOutput();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            this.savePanel.add(this.bSaveOutput);
            this.gridC.ipady = 0;
        }
        this.setPreferredSize(new Dimension(720, 480));
        this.verifyEnableButtons();
        this.cbInputType.requestFocusInWindow();
        this.showHideEffectAction();
    }

    private void setAudioEffects() {
        String availableAudioEffects = "";
        try {
            availableAudioEffects = this.processor.getAudioEffects();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.effectsBox = new AudioEffectsBoxGUI(availableAudioEffects);
        int i = 0;
        while (i < this.effectsBox.getData().getTotalEffects()) {
            AudioEffectControlData eff = this.effectsBox.getData().getControlData(i);
            try {
                eff.setHelpText(this.processor.requestEffectHelpText(eff.getEffectName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void showHideEffectAction() {
        if (this.isButtonHide) {
            if (this.effectsBox != null && this.effectsBox.mainPanel != null) {
                this.effectsBox.mainPanel.setVisible(false);
            }
            if (this.showHideEffects != null) {
                this.showHideEffects.setText("Show Effects");
            }
            this.isButtonHide = false;
            this.showingAudioEffects = false;
        } else {
            if (this.effectsBox != null && this.effectsBox.mainPanel != null) {
                this.effectsBox.mainPanel.setVisible(true);
            }
            if (this.showHideEffects != null) {
                this.showHideEffects.setText("Hide Effects");
            }
            this.isButtonHide = true;
            this.showingAudioEffects = true;
        }
    }

    private void updateAudioEffects() {
        if (this.effectsBox != null && this.effectsBox.hasEffects() && this.effectsBox.getData().getTotalEffects() > 0) {
            MaryClient.Voice voice = (MaryClient.Voice)this.cbDefaultVoice.getSelectedItem();
            if (voice == null) {
                return;
            }
            int i = 0;
            while (i < this.effectsBox.getData().getTotalEffects()) {
                String effectName = this.effectsBox.getData().getControlData(i).getEffectName();
                this.effectsBox.effectControls[i].setVisible(true);
                if (!voice.isHMMVoice()) {
                    try {
                        if (this.processor.isHMMEffect(effectName)) {
                            this.effectsBox.effectControls[i].setVisible(false);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            this.effectsBox.show();
        }
    }

    private String getAudioEffectsString() {
        StringBuilder effects = new StringBuilder();
        if (this.effectsBox != null && this.isButtonHide) {
            int i = 0;
            while (i < this.effectsBox.getData().getTotalEffects()) {
                if (this.effectsBox.effectControls[i].chkEnabled.isSelected()) {
                    String name = this.effectsBox.getData().getControlData(i).getEffectName();
                    String params = this.effectsBox.effectControls[i].txtParams.getText().trim();
                    if (effects.length() > 0) {
                        effects.append("+");
                    }
                    effects.append(name);
                    if (params != null && params.length() > 0) {
                        effects.append("(").append(params).append(")");
                    }
                }
                ++i;
            }
        }
        return effects.toString();
    }

    private void setExampleInputText() {
        MaryClient.Voice defaultVoice = (MaryClient.Voice)this.cbDefaultVoice.getSelectedItem();
        if (defaultVoice == null) {
            return;
        }
        MaryClient.DataType inputType = (MaryClient.DataType)this.cbInputType.getSelectedItem();
        if (defaultVoice.isLimitedDomain() && inputType.name().startsWith("TEXT")) {
            this.setInputText((String)this.cbVoiceExampleText.getSelectedItem());
        } else {
            try {
                String exampleText = this.processor.getServerExampleText(inputType.name(), defaultVoice.getLocale().toString());
                this.setInputText(exampleText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fillExampleTexts() {
        MaryClient.Voice defaultVoice = (MaryClient.Voice)this.cbDefaultVoice.getSelectedItem();
        if (defaultVoice == null || !defaultVoice.isLimitedDomain()) {
            return;
        }
        Vector<String> sentences = this.limDomVoices.get(defaultVoice.name());
        assert (sentences != null);
        this.cbVoiceExampleText.removeAllItems();
        int i = 0;
        while (i < sentences.size()) {
            this.cbVoiceExampleText.addItem(sentences.get(i));
            ++i;
        }
        this.cbVoiceExampleText.setSelectedIndex(0);
    }

    private void verifyExamplesVisible() {
        MaryClient.Voice defaultVoice = (MaryClient.Voice)this.cbDefaultVoice.getSelectedItem();
        MaryClient.DataType inputType = (MaryClient.DataType)this.cbInputType.getSelectedItem();
        if (defaultVoice != null && defaultVoice.isLimitedDomain() && inputType.name().startsWith("TEXT")) {
            this.cbVoiceExampleText.setVisible(true);
        } else {
            this.cbVoiceExampleText.setVisible(false);
        }
    }

    private void verifyEnableButtons() {
        if (((MaryClient.DataType)this.cbOutputType.getSelectedItem()).isTextType()) {
            this.buttonPanel.setVisible(true);
            if (!this.cbOutputType.hasFocus()) {
                this.bProcess.requestFocusInWindow();
            }
        } else {
            this.buttonPanel.setVisible(false);
            if (!this.cbOutputType.hasFocus()) {
                this.bPlay.requestFocusInWindow();
            }
        }
        if (this.showingTextOutput) {
            if (this.outputText.getText().length() == 0) {
                if (this.allowSave) {
                    this.bSaveOutput.setEnabled(false);
                }
                this.bEdit.setEnabled(false);
            } else {
                if (this.allowSave) {
                    this.bSaveOutput.setEnabled(true);
                }
                this.bEdit.setEnabled(true);
            }
        } else if (this.allowSave) {
            this.bSaveOutput.setEnabled(true);
        }
        if (((MaryClient.DataType)this.cbOutputType.getSelectedItem()).isTextType() && this.outputText.getText().length() > 0) {
            this.bCompare.setEnabled(true);
        } else {
            this.bCompare.setEnabled(false);
        }
    }

    private void verifyDefaultVoices() throws IOException {
        MaryClient.DataType cfr_ignored_0 = (MaryClient.DataType)this.cbInputType.getSelectedItem();
        MaryClient.Voice defaultVoice = (MaryClient.Voice)this.cbDefaultVoice.getSelectedItem();
        this.cbDefaultVoice.removeAllItems();
        Vector<MaryClient.Voice> voices = this.processor.getVoices();
        if (voices != null) {
            for (MaryClient.Voice v : this.processor.getVoices()) {
                this.cbDefaultVoice.addItem(v);
            }
            if (defaultVoice != null) {
                this.cbDefaultVoice.setSelectedItem(defaultVoice);
            } else {
                this.cbDefaultVoice.setSelectedIndex(0);
            }
        }
    }

    private void setOutputTypeItems() throws IOException {
        MaryClient.DataType cfr_ignored_0 = (MaryClient.DataType)this.cbInputType.getSelectedItem();
        MaryClient.DataType selectedItem = (MaryClient.DataType)this.cbOutputType.getSelectedItem();
        this.cbOutputType.removeAllItems();
        for (MaryClient.DataType d : this.processor.getOutputDataTypes()) {
            this.cbOutputType.addItem(d);
        }
        this.cbOutputType.setSelectedItem(selectedItem);
    }

    private void verifyOutputDisplay() {
        if (((MaryClient.DataType)this.cbOutputType.getSelectedItem()).isTextType()) {
            this.setOutputText("");
            if (!this.showingTextOutput) {
                this.audioPanel.setVisible(false);
                if (this.effectsBox != null) {
                    if (this.effectsBox.mainPanel != null) {
                        this.effectsBox.mainPanel.setVisible(false);
                    }
                    if (this.showHidePanel != null) {
                        this.showHidePanel.setVisible(false);
                    }
                }
                this.outputScrollPane.setVisible(true);
                this.showingTextOutput = true;
                this.revalidate();
            }
        } else if (this.showingTextOutput) {
            this.outputScrollPane.setVisible(false);
            this.audioPanel.setVisible(true);
            if (this.effectsBox != null && this.effectsBox.mainPanel != null) {
                if (this.showHidePanel != null) {
                    this.showHidePanel.setVisible(true);
                }
                if (this.effectsBox.mainPanel != null && this.isButtonHide) {
                    this.effectsBox.mainPanel.setVisible(true);
                }
            }
            this.showingTextOutput = false;
            this.revalidate();
        }
    }

    private void saveOutput() throws IOException, InterruptedException {
        if (!this.allowSave) {
            return;
        }
        try {
            if (this.showingTextOutput) {
                int returnVal;
                JFileChooser fc = new JFileChooser();
                if (this.lastDirectory != null) {
                    fc.setCurrentDirectory(this.lastDirectory);
                }
                if ((returnVal = fc.showSaveDialog(this)) == 0) {
                    File saveFile = fc.getSelectedFile();
                    this.lastDirectory = saveFile.getParentFile();
                    PrintWriter w = new PrintWriter(new FileWriter(saveFile));
                    w.print(this.outputText.getText());
                    w.close();
                }
            } else {
                JFileChooser fc = new JFileChooser();
                if (this.lastDirectory != null) {
                    fc.setCurrentDirectory(this.lastDirectory);
                }
                Vector<String> knownAudioTypes = this.processor.getAudioFileFormatTypes();
                String[] extensions = new String[knownAudioTypes.size()];
                String[] typeNames = new String[knownAudioTypes.size()];
                SimpleFileFilter defaultFilter = null;
                int i = 0;
                while (i < knownAudioTypes.size()) {
                    int iSpace = knownAudioTypes.get(i).indexOf(32);
                    typeNames[i] = knownAudioTypes.get(i).substring(0, iSpace);
                    extensions[i] = knownAudioTypes.get(i).substring(iSpace + 1);
                    SimpleFileFilter ff = new SimpleFileFilter(extensions[i], String.valueOf(typeNames[i]) + " (." + extensions[i] + ")");
                    fc.addChoosableFileFilter(ff);
                    if (this.lastExtension != null && this.lastExtension.equals(extensions[i])) {
                        defaultFilter = ff;
                    }
                    if (defaultFilter != null) {
                        fc.setFileFilter(defaultFilter);
                    }
                    ++i;
                }
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    File saveFile = fc.getSelectedFile();
                    String ext = MaryUtils.getExtension(saveFile);
                    if (ext == null) {
                        ext = ((SimpleFileFilter)fc.getFileFilter()).getExtension();
                        saveFile = new File(String.valueOf(saveFile.getAbsolutePath()) + "." + ext);
                    }
                    this.lastDirectory = saveFile.getParentFile();
                    this.lastExtension = ext;
                    String audioType = null;
                    int i2 = 0;
                    while (i2 < knownAudioTypes.size()) {
                        if (extensions[i2].equals(ext)) {
                            audioType = typeNames[i2];
                            break;
                        }
                        ++i2;
                    }
                    if (audioType == null) {
                        this.showErrorMessage("Unknown audio type", "Cannot write file of type `." + ext + "'");
                    } else {
                        FileOutputStream fos = new FileOutputStream(saveFile);
                        this.processor.process(this.inputText.getText(), ((MaryClient.DataType)this.cbInputType.getSelectedItem()).name(), "AUDIO", ((MaryClient.Voice)this.cbDefaultVoice.getSelectedItem()).getLocale().toString(), audioType, ((MaryClient.Voice)this.cbDefaultVoice.getSelectedItem()).name(), "", this.getAudioEffectsString(), null, fos);
                        fos.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showErrorMessage("IOException", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeTextPlain(StyledDocument doc) {
        SimpleAttributeSet emptyAttributes = new SimpleAttributeSet();
        doc.setCharacterAttributes(0, doc.getLength(), emptyAttributes, true);
    }

    private void highlightText(StyledDocument doc) {
        SimpleAttributeSet highlighted = new SimpleAttributeSet();
        StyleConstants.setBold(highlighted, true);
        boolean insideTag = false;
        int beginText = -1;
        int i = 0;
        while (i < doc.getLength()) {
            int c = 32;
            try {
                c = doc.getText(i, 1).charAt(0);
            }
            catch (BadLocationException badLocationException) {}
            if (insideTag) {
                if (c == 62) {
                    insideTag = false;
                }
            } else if (c == 60) {
                if (beginText != -1) {
                    doc.setCharacterAttributes(beginText, i - beginText, highlighted, false);
                    beginText = -1;
                }
                insideTag = true;
            } else if (beginText == -1) {
                beginText = i;
            }
            ++i;
        }
        if (beginText != -1) {
            doc.setCharacterAttributes(beginText, doc.getLength() - beginText, highlighted, false);
        }
    }

    private void processInput() {
        MaryClient.DataType outputType = (MaryClient.DataType)this.cbOutputType.getSelectedItem();
        if (outputType.name().equals("AUDIO")) {
            try {
                this.audioPlayer = new AudioPlayer();
                this.processor.streamAudio(this.inputText.getText(), ((MaryClient.DataType)this.cbInputType.getSelectedItem()).name(), ((MaryClient.Voice)this.cbDefaultVoice.getSelectedItem()).getLocale().toString(), this.streamMp3 ? "MP3" : "AU", ((MaryClient.Voice)this.cbDefaultVoice.getSelectedItem()).name(), "", this.getAudioEffectsString(), this.audioPlayer, new MaryClient.AudioPlayerListener(){

                    @Override
                    public void playerFinished() {
                        MaryGUIClient.this.resetPlayButton();
                    }

                    @Override
                    public void playerException(Exception e) {
                        MaryGUIClient.this.showErrorMessage(e.getClass().getName(), e.getMessage());
                        MaryGUIClient.this.resetPlayButton();
                    }
                });
                this.bPlay.setText("Stop");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showErrorMessage(e.getClass().getName(), e.getMessage());
                this.resetPlayButton();
            }
        } else {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                MaryClient.Voice voice = (MaryClient.Voice)this.cbDefaultVoice.getSelectedItem();
                String voiceName = voice != null ? voice.name() : null;
                String locale = voice != null ? voice.getLocale().toString() : null;
                this.processor.process(this.inputText.getText(), ((MaryClient.DataType)this.cbInputType.getSelectedItem()).name(), outputType.name(), locale, null, voiceName, "", this.getAudioEffectsString(), null, os);
                try {
                    this.setOutputText(os.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    uee.printStackTrace();
                }
                this.bEdit.setEnabled(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showErrorMessage(e.getClass().getName(), e.getMessage());
            }
        }
    }

    private void editOutput() {
        MaryClient.DataType type = (MaryClient.DataType)this.cbOutputType.getSelectedItem();
        if (type == null || !type.isTextType() || !type.isInputType()) {
            return;
        }
        this.setInputText(this.outputText.getText());
        this.setOutputText("");
        if (!this.cbInputType.getSelectedItem().equals(this.cbOutputType.getSelectedItem())) {
            this.doReplaceInput = false;
            this.cbInputType.setSelectedItem(this.cbOutputType.getSelectedItem());
        }
    }

    private void compareTexts() {
        if (!((MaryClient.DataType)this.cbOutputType.getSelectedItem()).isTextType() || this.inputText.getText().length() == 0 || this.outputText.getText().length() == 0) {
            return;
        }
        try {
            this.makeTextPlain(this.inputText.getStyledDocument());
            this.makeTextPlain(this.outputText.getStyledDocument());
            this.highlightText(this.inputText.getStyledDocument());
            this.highlightText(this.outputText.getStyledDocument());
            SimpleAttributeSet removed = new SimpleAttributeSet();
            SimpleAttributeSet added = new SimpleAttributeSet();
            StyleConstants.setBold(removed, true);
            StyleConstants.setBold(added, true);
            StyleConstants.setItalic(removed, true);
            StyleConstants.setItalic(added, true);
            StyleConstants.setUnderline(added, true);
            StyleConstants.setForeground(removed, Color.red);
            StyleConstants.setForeground(added, Color.green.darker());
            String input = this.inputText.getStyledDocument().getText(0, this.inputText.getStyledDocument().getLength());
            String[] inputWords = MaryUtils.splitIntoSensibleXMLUnits(input);
            int[] inputIndex = new int[inputWords.length + 1];
            int total = 0;
            int i = 0;
            while (i < inputWords.length) {
                inputIndex[i] = total;
                total += inputWords[i].length();
                ++i;
            }
            inputIndex[inputWords.length] = total;
            String output = this.outputText.getStyledDocument().getText(0, this.outputText.getStyledDocument().getLength());
            String[] outputWords = MaryUtils.splitIntoSensibleXMLUnits(output);
            int[] outputIndex = new int[outputWords.length + 1];
            total = 0;
            int i2 = 0;
            while (i2 < outputWords.length) {
                outputIndex[i2] = total;
                total += outputWords[i2].length();
                ++i2;
            }
            outputIndex[outputWords.length] = total;
            List<Difference> diffs = new Diff<String>(inputWords, outputWords).diff();
            for (Difference diff : diffs) {
                int delStart = diff.getDeletedStart();
                int delEnd = diff.getDeletedEnd();
                int addStart = diff.getAddedStart();
                int addEnd = diff.getAddedEnd();
                if (delEnd != -1) {
                    this.inputText.getStyledDocument().setCharacterAttributes(inputIndex[delStart], inputIndex[delEnd + 1] - inputIndex[delStart], removed, false);
                }
                if (addEnd == -1) continue;
                this.outputText.getStyledDocument().setCharacterAttributes(outputIndex[addStart], outputIndex[addEnd + 1] - outputIndex[addStart], added, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setInputText(String text) {
        this.inputText.setText(text);
        this.makeTextPlain(this.inputText.getStyledDocument());
        this.inputText.setCaretPosition(0);
    }

    protected void setOutputText(String text) {
        this.outputText.setText(text);
        this.makeTextPlain(this.outputText.getStyledDocument());
        this.outputText.setCaretPosition(0);
    }

    private MaryClient.Voice getPrevVoice() {
        return this.prevVoice;
    }

    private void setPrevVoice(MaryClient.Voice prevVoice) {
        this.prevVoice = prevVoice;
    }

    public void resetPlayButton() {
        this.bPlay.setText("Play");
        if (this.audioPlayer != null) {
            this.audioPlayer.cancel();
            this.audioPlayer = null;
        }
    }

    protected void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(this, String.valueOf(message) + "\n\nIf you think this is a bug in the MARY system,\n" + "please help improve the system by filing a bug report\n" + "on the MARY development page: \n" + "http://mary.opendfki.de/newticket\n", title, 0);
    }

    public static void main(String[] args) throws Exception {
        mainFrame = new JFrame("Mary GUI Client");
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MaryGUIClient m = new MaryGUIClient();
        mainFrame.setContentPane(m);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    class MaryGUIFocusTraversalPolicy
    extends FocusTraversalPolicy {
        MaryGUIFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(MaryGUIClient.this.cbInputType)) {
                return MaryGUIClient.this.cbOutputType;
            }
            if (aComponent.equals(MaryGUIClient.this.cbOutputType)) {
                return MaryGUIClient.this.cbDefaultVoice;
            }
            if (aComponent.equals(MaryGUIClient.this.cbDefaultVoice)) {
                if (MaryGUIClient.this.cbVoiceExampleText.isVisible()) {
                    return MaryGUIClient.this.cbVoiceExampleText;
                }
                return MaryGUIClient.this.inputText;
            }
            if (aComponent.equals(MaryGUIClient.this.cbVoiceExampleText)) {
                return MaryGUIClient.this.inputText;
            }
            if (aComponent.equals(MaryGUIClient.this.inputText)) {
                if (MaryGUIClient.this.audioPanel.isVisible()) {
                    return MaryGUIClient.this.bPlay;
                }
                return MaryGUIClient.this.bProcess;
            }
            if (aComponent.equals(MaryGUIClient.this.bProcess)) {
                if (MaryGUIClient.this.bEdit.isEnabled()) {
                    return MaryGUIClient.this.bEdit;
                }
                if (MaryGUIClient.this.allowSave && MaryGUIClient.this.bSaveOutput.isEnabled()) {
                    return MaryGUIClient.this.bSaveOutput;
                }
                return MaryGUIClient.this.cbInputType;
            }
            if (aComponent.equals(MaryGUIClient.this.bPlay)) {
                if (MaryGUIClient.this.allowSave) {
                    return MaryGUIClient.this.bSaveOutput;
                }
                return MaryGUIClient.this.cbInputType;
            }
            if (aComponent.equals(MaryGUIClient.this.outputText)) {
                if (MaryGUIClient.this.bEdit.isEnabled()) {
                    return MaryGUIClient.this.bEdit;
                }
                return MaryGUIClient.this.cbInputType;
            }
            if (aComponent.equals(MaryGUIClient.this.bEdit)) {
                return MaryGUIClient.this.bCompare;
            }
            if (aComponent.equals(MaryGUIClient.this.bCompare)) {
                if (MaryGUIClient.this.allowSave) {
                    return MaryGUIClient.this.bSaveOutput;
                }
                return MaryGUIClient.this.cbInputType;
            }
            if (aComponent.equals(MaryGUIClient.this.bSaveOutput)) {
                return MaryGUIClient.this.cbInputType;
            }
            return MaryGUIClient.this.cbInputType;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(MaryGUIClient.this.bSaveOutput)) {
                if (!MaryGUIClient.this.buttonPanel.isVisible()) {
                    return MaryGUIClient.this.bPlay;
                }
                if (MaryGUIClient.this.bCompare.isEnabled()) {
                    return MaryGUIClient.this.bCompare;
                }
                return MaryGUIClient.this.bProcess;
            }
            if (aComponent.equals(MaryGUIClient.this.bCompare)) {
                return MaryGUIClient.this.bEdit;
            }
            if (aComponent.equals(MaryGUIClient.this.bEdit)) {
                return MaryGUIClient.this.bProcess;
            }
            if (aComponent.equals(MaryGUIClient.this.outputText)) {
                return MaryGUIClient.this.bProcess;
            }
            if (aComponent.equals(MaryGUIClient.this.bPlay)) {
                return MaryGUIClient.this.inputText;
            }
            if (aComponent.equals(MaryGUIClient.this.bProcess)) {
                return MaryGUIClient.this.inputText;
            }
            if (aComponent.equals(MaryGUIClient.this.inputText)) {
                if (MaryGUIClient.this.cbVoiceExampleText.isVisible()) {
                    return MaryGUIClient.this.cbVoiceExampleText;
                }
                return MaryGUIClient.this.cbDefaultVoice;
            }
            if (aComponent.equals(MaryGUIClient.this.cbVoiceExampleText)) {
                return MaryGUIClient.this.cbDefaultVoice;
            }
            if (aComponent.equals(MaryGUIClient.this.cbDefaultVoice)) {
                return MaryGUIClient.this.cbOutputType;
            }
            if (aComponent.equals(MaryGUIClient.this.cbOutputType)) {
                return MaryGUIClient.this.cbInputType;
            }
            if (aComponent.equals(MaryGUIClient.this.cbInputType)) {
                if (MaryGUIClient.this.allowSave && MaryGUIClient.this.bSaveOutput.isEnabled()) {
                    return MaryGUIClient.this.bSaveOutput;
                }
                if (MaryGUIClient.this.buttonPanel.isVisible()) {
                    return MaryGUIClient.this.bProcess;
                }
                return MaryGUIClient.this.bPlay;
            }
            return MaryGUIClient.this.cbInputType;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return MaryGUIClient.this.cbInputType;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return MaryGUIClient.this.bSaveOutput;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return MaryGUIClient.this.cbInputType;
        }
    }
}

