/*
 * Decompiled with CFR 0.152.
 */
package marytts.client.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.client.AudioFormatOutputStream;
import marytts.client.MaryClient;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.http.Address;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;

public class MaryHttpClient
extends MaryClient {
    public MaryHttpClient() throws IOException {
    }

    public MaryHttpClient(boolean quiet) throws IOException {
        super(quiet);
    }

    public MaryHttpClient(Address serverAddress) throws IOException {
        super(serverAddress);
    }

    public MaryHttpClient(Address serverAddress, boolean profile, boolean quiet) throws IOException {
        super(serverAddress, profile, quiet);
    }

    @Override
    protected void fillAudioFileFormatAndOutTypes() throws IOException {
        String audioFormatInfo = this.serverInfoRequest("audioformats", null);
        this.data.audioOutTypes = new Vector<String>(Arrays.asList(StringUtils.toStringArray(audioFormatInfo)));
        this.data.audioFileFormatTypes = new Vector();
        for (String af : this.data.audioOutTypes) {
            if (!af.endsWith("_FILE")) continue;
            String typeName = af.substring(0, af.indexOf("_"));
            try {
                AudioFileFormat.Type type = MaryClient.getAudioFileFormatType(typeName);
                this.data.audioFileFormatTypes.add(String.valueOf(typeName) + " " + type.getExtension());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void fillServerVersion() throws IOException {
        this.data.toServerVersionInfo(this.serverInfoRequest("version", null));
    }

    @Override
    protected void fillDataTypes() throws IOException {
        this.data.toDataTypes(this.serverInfoRequest("datatypes", null));
    }

    @Override
    protected void fillVoices() throws IOException {
        this.data.toVoices(this.serverInfoRequest("voices", null));
    }

    @Override
    protected void fillLocales() throws IOException {
        this.data.toLocales(this.serverInfoRequest("locales", null));
    }

    @Override
    protected void fillVoiceExampleTexts(String voicename) throws IOException {
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("voice", voicename);
        String info = this.serverInfoRequest("exampletext", queryItems);
        if (info.length() == 0) {
            throw new IOException("Could not get example text from Mary server");
        }
        StringTokenizer st = new StringTokenizer(info, "\n");
        Vector<String> sentences = new Vector<String>();
        while (st.hasMoreTokens()) {
            sentences.add(st.nextToken());
        }
        this.data.voiceExampleTextsLimitedDomain.put(voicename, sentences);
    }

    @Override
    protected void fillServerExampleText(String dataType, String locale) throws IOException {
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("datatype", dataType);
        queryItems.put("locale", locale);
        String info = this.serverInfoRequest("exampletext", queryItems);
        if (info.length() == 0) {
            throw new IOException("Could not get example text from Mary server");
        }
        this.data.serverExampleTexts.put(String.valueOf(dataType) + " " + locale, info.replaceAll("\n", System.getProperty("line.separator")));
    }

    @Override
    protected String getDefaultAudioEffects() throws IOException {
        return this.serverInfoRequest("audioeffects", null);
    }

    @Override
    public String requestDefaultEffectParameters(String effectName) throws IOException {
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("effect", effectName);
        String info = this.serverInfoRequest("audioeffect-default-param", queryItems);
        if (info == null || info.length() == 0) {
            return "";
        }
        return info.replaceAll("\n", System.getProperty("line.separator"));
    }

    @Override
    public String requestFullEffect(String effectName, String currentEffectParameters) throws IOException {
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("effect", effectName);
        queryItems.put("params", currentEffectParameters);
        String info = this.serverInfoRequest("audioeffect-full", queryItems);
        if (info.length() == 0) {
            return "";
        }
        return info.replaceAll("\n", System.getProperty("line.separator"));
    }

    @Override
    protected void fillEffectHelpText(String effectName) throws IOException {
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("effect", effectName);
        String info = this.serverInfoRequest("audioeffect-help", queryItems);
        this.data.audioEffectHelpTextsMap.put(effectName, info.replaceAll("\n", System.getProperty("line.separator")));
    }

    @Override
    public boolean isHMMEffect(String effectName) throws IOException {
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("effect", effectName);
        String info = this.serverInfoRequest("audioeffect-is-hmm-effect", queryItems);
        if (info.length() == 0) {
            return false;
        }
        boolean bRet = false;
        if ((info = info.toLowerCase()).indexOf("yes") > -1) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public String getFeatures(String locale) throws IOException {
        return this.serverInfoRequest("features?locale=" + locale, null);
    }

    public String getDiscreteFeatures(String locale) throws IOException {
        return this.serverInfoRequest("features-discrete?locale=" + locale, null);
    }

    @Override
    public String getFeaturesForVoice(String voice) throws IOException {
        return this.serverInfoRequest("features?voice=" + voice, null);
    }

    private String serverInfoRequest(String request, Map<String, String> queryItems) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append(this.data.hostAddress.getHttpAddress()).append("/").append(request);
        if (queryItems != null) {
            url.append("?");
            boolean first = true;
            for (String key : queryItems.keySet()) {
                if (first) {
                    first = false;
                } else {
                    url.append("&");
                }
                url.append(key).append("=");
                url.append(URLEncoder.encode(queryItems.get(key), "UTF-8"));
            }
        }
        return this.serverInfoRequest(new URL(url.toString()));
    }

    private String serverInfoRequest(URL url) throws IOException {
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestMethod("GET");
        http.connect();
        if (http.getResponseCode() != 200) {
            String errorData = "";
            try {
                errorData = FileUtils.getStreamAsString(http.getErrorStream(), "UTF-8");
            }
            catch (Exception exception) {}
            throw new IOException(String.valueOf(http.getResponseCode()) + ":" + http.getResponseMessage() + "\n" + errorData);
        }
        return FileUtils.getStreamAsString(http.getInputStream(), "UTF-8");
    }

    private InputStream requestInputStream(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, String defaultStyle, Map<String, String> effects, boolean streamingAudio, String outputTypeParams) throws IOException {
        StringBuilder params = new StringBuilder();
        params.append("INPUT_TEXT=").append(URLEncoder.encode(input, "UTF-8"));
        params.append("&INPUT_TYPE=").append(URLEncoder.encode(inputType, "UTF-8"));
        params.append("&OUTPUT_TYPE=").append(URLEncoder.encode(outputType, "UTF-8"));
        if (locale != null) {
            params.append("&LOCALE=").append(URLEncoder.encode(locale, "UTF-8"));
        }
        if (audioType != null) {
            params.append("&AUDIO=").append(URLEncoder.encode(streamingAudio && this.data.serverCanStream ? String.valueOf(audioType) + "_STREAM" : String.valueOf(audioType) + "_FILE", "UTF-8"));
        }
        if (outputTypeParams != null) {
            params.append("&OUTPUT_TYPE_PARAMS=").append(URLEncoder.encode(outputTypeParams, "UTF-8"));
        }
        if (defaultVoiceName != null) {
            params.append("&VOICE=").append(URLEncoder.encode(defaultVoiceName, "UTF-8"));
        }
        if (defaultStyle != null) {
            params.append("&STYLE=").append(URLEncoder.encode(defaultStyle, "UTF-8"));
        }
        if (effects != null) {
            for (String key : effects.keySet()) {
                params.append("&").append(key).append("=").append(URLEncoder.encode(effects.get(key), "UTF-8"));
            }
        }
        URL url = new URL(String.valueOf(this.data.hostAddress.getHttpAddress()) + "/process");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setAllowUserInteraction(false);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        OutputStream ost = conn.getOutputStream();
        PrintWriter pw = new PrintWriter(ost);
        pw.print(params.toString());
        pw.flush();
        pw.close();
        try {
            return conn.getInputStream();
        }
        catch (IOException e) {
            String error;
            try {
                error = FileUtils.getStreamAsString(conn.getErrorStream(), "UTF-8");
            }
            catch (IOException iOException) {
                throw new IOException("No detailed error message available", e);
            }
            throw new IOException("Error message from server:\n" + error, e);
        }
    }

    private Map<String, String> effectsString2EffectsMap(String effectsString) {
        if (effectsString == null) {
            return null;
        }
        HashMap<String, String> effectsMap = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(effectsString, ",");
        while (st.hasMoreTokens()) {
            String params;
            String name;
            String oneEffect = st.nextToken().trim();
            int iBracket = oneEffect.indexOf(40);
            if (iBracket > -1) {
                name = oneEffect.substring(0, iBracket);
                params = oneEffect.substring(iBracket + 1, oneEffect.indexOf(41, iBracket + 1));
            } else {
                name = oneEffect;
                params = "";
            }
            effectsMap.put("effect_" + name + "_selected", "on");
            effectsMap.put("effect_" + name + "_parameters", params);
        }
        return effectsMap;
    }

    @Override
    protected void _process(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, String defaultStyle, String defaultEffects, Object output, long timeout, boolean streamingAudio, String outputTypeParams, MaryClient.AudioPlayerListener playerListener) throws IOException {
        Timer timer;
        boolean isMaryAudioPlayer = false;
        if (output instanceof AudioPlayer) {
            isMaryAudioPlayer = true;
        } else if (!(output instanceof OutputStream)) {
            throw new IllegalArgumentException("Expected OutputStream or AudioPlayer, got " + output.getClass().getName());
        }
        final long startTime = System.currentTimeMillis();
        final InputStream fromServerStream = this.requestInputStream(input, inputType, outputType, locale, audioType, defaultVoiceName, defaultStyle, this.effectsString2EffectsMap(defaultEffects), streamingAudio, outputTypeParams);
        if (timeout <= 0L) {
            timer = null;
        } else {
            timer = new Timer();
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Timer closes connection");
                }
            };
            timer.schedule(timerTask, timeout);
        }
        if (isMaryAudioPlayer) {
            final AudioPlayer player = (AudioPlayer)output;
            final MaryClient.AudioPlayerListener listener = playerListener;
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        AudioFormat audioFormat;
                        InputStream in = fromServerStream;
                        if (MaryHttpClient.this.doProfile) {
                            System.err.println("After " + (System.currentTimeMillis() - startTime) + " ms: Trying to read data from server");
                        }
                        in = new BufferedInputStream(in);
                        in.mark(1000);
                        AudioInputStream fromServerAudio = AudioSystem.getAudioInputStream(in);
                        if (fromServerAudio.getFrameLength() == 0L) {
                            fromServerAudio = new AudioInputStream(in, fromServerAudio.getFormat(), -1L);
                        }
                        if (MaryHttpClient.this.doProfile) {
                            System.err.println("After " + (System.currentTimeMillis() - startTime) + " ms: Audio available: " + in.available());
                        }
                        if (!(audioFormat = fromServerAudio.getFormat()).getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                            audioFormat = new AudioFormat(fromServerAudio.getFormat().getSampleRate(), 16, 1, true, false);
                            fromServerAudio = AudioSystem.getAudioInputStream(audioFormat, fromServerAudio);
                        }
                        player.setAudio(fromServerAudio);
                        player.run();
                        if (timer != null) {
                            timer.cancel();
                        }
                        if (listener != null) {
                            listener.playerFinished();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (MaryHttpClient.this.doProfile) {
                        long endTime = System.currentTimeMillis();
                        long processingTime = endTime - startTime;
                        System.err.println("Processed request in " + processingTime + " ms.");
                    }
                }
            };
            if (streamingAudio) {
                t.start();
            } else {
                t.run();
            }
        } else {
            int nr;
            OutputStream os = (OutputStream)output;
            BufferedInputStream bis = new BufferedInputStream(fromServerStream);
            if (os instanceof AudioFormatOutputStream) {
                AudioFormatOutputStream afos = (AudioFormatOutputStream)os;
                try {
                    AudioFileFormat format = AudioSystem.getAudioFileFormat(bis);
                    afos.setFormat(format.getFormat());
                }
                catch (UnsupportedAudioFileException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            byte[] bbuf = new byte[1024];
            while ((nr = ((InputStream)bis).read(bbuf, 0, bbuf.length)) != -1) {
                os.write(bbuf, 0, nr);
            }
            os.flush();
            if (timeout > 0L) {
                timer.cancel();
            }
            if (this.doProfile) {
                long endTime = System.currentTimeMillis();
                long processingTime = endTime - startTime;
                System.err.println("Processed request in " + processingTime + " ms.");
            }
        }
    }
}

