/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import marytts.machinelearning.Cluster;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.signalproc.analysis.distance.DistanceComputer;
import marytts.util.math.MathUtils;

public class KMeansClusteringTrainer {
    public Cluster[] clusters;
    public int[] totalObservationsInClusters;
    public int[] clusterIndices;
    public double[][] covMatrixGlobal;
    public double[][] invCovMatrixGlobal;

    public void train(double[][] x, KMeansClusteringTrainerParams kmeansParams) {
        int d2;
        int d1;
        int[] inds;
        int i;
        int d;
        if (kmeansParams.globalVariances == null) {
            double[] meanVector = MathUtils.mean(x, true);
            kmeansParams.globalVariances = MathUtils.variance(x, meanVector, true);
        }
        int observations = x.length;
        int dimension = x[0].length;
        int ind = -1;
        double minDist = Double.MIN_VALUE;
        double[][] m_new = new double[kmeansParams.numClusters][];
        int k = 0;
        while (k < kmeansParams.numClusters) {
            m_new[k] = new double[dimension];
            ++k;
        }
        int[][] b = new int[observations][];
        int t = 0;
        while (t < observations) {
            b[t] = new int[kmeansParams.numClusters];
            ++t;
        }
        int[][] b_old = new int[observations][];
        t = 0;
        while (t < observations) {
            b_old[t] = new int[kmeansParams.numClusters];
            ++t;
        }
        int[] prev_totals = new int[kmeansParams.numClusters];
        double[] mAll = new double[dimension];
        this.clusters = new Cluster[kmeansParams.numClusters];
        k = 0;
        while (k < kmeansParams.numClusters) {
            this.clusters[k] = new Cluster(dimension, kmeansParams.isDiagonalOutputCovariance);
            ++k;
        }
        k = 1;
        while (k <= kmeansParams.numClusters) {
            d = 1;
            while (d <= dimension) {
                this.clusters[k - 1].meanVector[d - 1] = 0.0;
                ++d;
            }
            t = 1;
            while (t <= observations) {
                b[t - 1][k - 1] = 0;
                ++t;
            }
            ++k;
        }
        mAll = MathUtils.mean(x, true);
        k = 1;
        double[] dists = new double[observations];
        double[] tmp = new double[kmeansParams.numClusters + 1];
        double maxD = Double.MAX_VALUE;
        int maxInd = -1;
        while (k <= kmeansParams.numClusters) {
            t = 1;
            while (t <= observations) {
                if (k > 1) {
                    i = 1;
                    while (i <= k - 1) {
                        tmp[i - 1] = DistanceComputer.getNormalizedEuclideanDistance(this.clusters[i - 1].meanVector, x[t - 1], kmeansParams.globalVariances);
                        ++i;
                    }
                    tmp[k - 1] = DistanceComputer.getNormalizedEuclideanDistance(mAll, x[t - 1], kmeansParams.globalVariances);
                    dists[t - 1] = MathUtils.mean(tmp, 0, k - 1);
                } else {
                    dists[t - 1] = DistanceComputer.getNormalizedEuclideanDistance(mAll, x[t - 1], kmeansParams.globalVariances);
                }
                ++t;
            }
            t = 1;
            while (t <= observations) {
                if (t == 1 || dists[t - 1] > maxD) {
                    maxD = dists[t - 1];
                    maxInd = t;
                }
                ++t;
            }
            d = 0;
            while (d < dimension) {
                this.clusters[k - 1].meanVector[d] = x[maxInd - 1][d];
                ++d;
            }
            ++k;
        }
        int[] tinyClusterInds = new int[kmeansParams.numClusters];
        int numTinyClusters = 0;
        double[] tmps = new double[kmeansParams.numClusters];
        this.totalObservationsInClusters = new int[kmeansParams.numClusters];
        this.clusterIndices = new int[observations];
        int iter = 0;
        boolean bCont = true;
        while (bCont) {
            t = 1;
            while (t <= observations) {
                i = 1;
                while (i <= kmeansParams.numClusters) {
                    double tmpDist = DistanceComputer.getNormalizedEuclideanDistance(this.clusters[i - 1].meanVector, x[t - 1], kmeansParams.globalVariances);
                    b[t - 1][i - 1] = 0;
                    if (i == 1 || tmpDist < minDist) {
                        minDist = tmpDist;
                        ind = i;
                    }
                    ++i;
                }
                i = 1;
                while (i <= kmeansParams.numClusters) {
                    if (i == ind) {
                        b[t - 1][i - 1] = 1;
                    }
                    ++i;
                }
                ++t;
            }
            i = 1;
            while (i <= kmeansParams.numClusters) {
                this.totalObservationsInClusters[i - 1] = 0;
                tinyClusterInds[i - 1] = 0;
                ++i;
            }
            int c = 1;
            i = 1;
            while (i <= kmeansParams.numClusters) {
                d = 1;
                while (d <= dimension) {
                    m_new[i - 1][d - 1] = 0.0;
                    ++d;
                }
                t = 1;
                while (t <= observations) {
                    if (b[t - 1][i - 1] == 1) {
                        d = 1;
                        while (d <= dimension) {
                            m_new[i - 1][d - 1] = m_new[i - 1][d - 1] + x[t - 1][d - 1];
                            ++d;
                        }
                        this.clusterIndices[t - 1] = i - 1;
                        int n = i - 1;
                        this.totalObservationsInClusters[n] = this.totalObservationsInClusters[n] + 1;
                    }
                    ++t;
                }
                if ((double)this.totalObservationsInClusters[i - 1] < (double)kmeansParams.minSamplesInOneCluster) {
                    tinyClusterInds[c - 1] = i;
                    ++numTinyClusters;
                    ++c;
                }
                ++i;
            }
            c = 0;
            i = 0;
            while (i < this.totalObservationsInClusters.length) {
                tmps[i] = this.totalObservationsInClusters[i];
                ++i;
            }
            inds = MathUtils.quickSort(tmps, 0, kmeansParams.numClusters - 1);
            i = 1;
            while (i <= kmeansParams.numClusters) {
                if (this.totalObservationsInClusters[i - 1] >= kmeansParams.minSamplesInOneCluster) {
                    d = 1;
                    while (d <= dimension) {
                        this.clusters[i - 1].meanVector[d - 1] = m_new[i - 1][d - 1] / (double)this.totalObservationsInClusters[i - 1];
                        ++d;
                    }
                } else {
                    d = 1;
                    while (d <= dimension) {
                        double rnd = Math.random() * Math.abs(this.clusters[inds[kmeansParams.numClusters - c - 1]].meanVector[d - 1]) * 0.01;
                        this.clusters[i - 1].meanVector[d - 1] = this.clusters[inds[kmeansParams.numClusters - c - 1]].meanVector[d - 1] + rnd;
                        ++d;
                    }
                    ++c;
                }
                ++i;
            }
            i = 1;
            while (i <= kmeansParams.numClusters) {
                prev_totals[i - 1] = this.totalObservationsInClusters[i - 1];
                ++i;
            }
            int totChanged = 0;
            if (++iter > 1) {
                if (iter >= kmeansParams.maxIterations) {
                    bCont = false;
                }
                t = 1;
                while (t <= observations) {
                    i = 1;
                    while (i <= kmeansParams.numClusters) {
                        if (b_old[t - 1][i - 1] != b[t - 1][i - 1]) {
                            ++totChanged;
                            break;
                        }
                        ++i;
                    }
                    ++t;
                }
                double changedPerc = (double)totChanged / (double)observations * 100.0;
                if (changedPerc < kmeansParams.minClusterChangePercent) {
                    bCont = false;
                }
            }
            t = 1;
            while (t <= observations) {
                int k2 = 1;
                while (k2 <= kmeansParams.numClusters) {
                    b_old[t - 1][k2 - 1] = b[t - 1][k2 - 1];
                    ++k2;
                }
                ++t;
            }
        }
        double[][] tmpCov = null;
        double[] diag = null;
        i = 0;
        while (i < kmeansParams.numClusters) {
            if (this.totalObservationsInClusters[i] > 0) {
                int[] indices = new int[this.totalObservationsInClusters[i]];
                int count = 0;
                t = 0;
                while (t < observations) {
                    if (this.clusterIndices[t] == i) {
                        indices[count++] = t;
                    }
                    ++t;
                }
                if (kmeansParams.isDiagonalOutputCovariance) {
                    tmpCov = MathUtils.covariance(x, this.clusters[i].meanVector, true, indices);
                    diag = MathUtils.diagonal(tmpCov);
                    d1 = 0;
                    while (d1 < diag.length) {
                        diag[d1] = Math.max(diag[d1], kmeansParams.minCovarianceAllowed);
                        ++d1;
                    }
                    System.arraycopy(diag, 0, this.clusters[i].covMatrix[0], 0, diag.length);
                    this.clusters[i].invCovMatrix[0] = MathUtils.inverse(this.clusters[i].covMatrix[0]);
                } else {
                    this.clusters[i].covMatrix = MathUtils.covariance(x, this.clusters[i].meanVector, true, indices);
                    d1 = 0;
                    while (d1 < this.clusters[i].covMatrix.length) {
                        d2 = 0;
                        while (d2 < this.clusters[i].covMatrix[d1].length) {
                            this.clusters[i].covMatrix[d1][d2] = Math.max(this.clusters[i].covMatrix[d1][d2], kmeansParams.minCovarianceAllowed);
                            ++d2;
                        }
                        ++d1;
                    }
                    this.clusters[i].invCovMatrix = MathUtils.inverse(this.clusters[i].covMatrix);
                }
            }
            ++i;
        }
        i = 0;
        while (i < kmeansParams.numClusters) {
            tmps[i] = this.totalObservationsInClusters[i];
            ++i;
        }
        inds = MathUtils.quickSort(tmps, 0, kmeansParams.numClusters - 1);
        int largestClusterInd = inds[kmeansParams.numClusters - 1];
        i = 0;
        while (i < kmeansParams.numClusters) {
            if (this.totalObservationsInClusters[i] < kmeansParams.minSamplesInOneCluster) {
                System.arraycopy(this.clusters[largestClusterInd].meanVector, 0, this.clusters[i].meanVector, 0, dimension);
                if (kmeansParams.isDiagonalOutputCovariance) {
                    System.arraycopy(this.clusters[largestClusterInd].covMatrix[0], 0, this.clusters[i].covMatrix[0], 0, dimension);
                    System.arraycopy(this.clusters[largestClusterInd].invCovMatrix[0], 0, this.clusters[i].invCovMatrix[0], 0, dimension);
                } else {
                    int j = 0;
                    while (j < dimension) {
                        System.arraycopy(this.clusters[largestClusterInd].covMatrix[j], 0, this.clusters[i].covMatrix[j], 0, dimension);
                        System.arraycopy(this.clusters[largestClusterInd].invCovMatrix[j], 0, this.clusters[i].invCovMatrix[j], 0, dimension);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (kmeansParams.isDiagonalOutputCovariance) {
            tmpCov = MathUtils.covariance(x, true);
            this.covMatrixGlobal = new double[1][tmpCov.length];
            this.covMatrixGlobal[0] = MathUtils.diagonal(tmpCov);
            d1 = 0;
            while (d1 < this.covMatrixGlobal[0].length) {
                this.covMatrixGlobal[0][d1] = Math.max(this.covMatrixGlobal[0][d1], kmeansParams.minCovarianceAllowed);
                ++d1;
            }
            this.invCovMatrixGlobal = new double[1][tmpCov.length];
            this.invCovMatrixGlobal[0] = MathUtils.inverse(this.covMatrixGlobal[0]);
        } else {
            this.covMatrixGlobal = MathUtils.covariance(x);
            d1 = 0;
            while (d1 < this.covMatrixGlobal[0].length) {
                d2 = 0;
                while (d2 < this.covMatrixGlobal[d1].length) {
                    this.covMatrixGlobal[d1][d2] = Math.max(this.covMatrixGlobal[d1][d2], kmeansParams.minCovarianceAllowed);
                    ++d2;
                }
                ++d1;
            }
            this.invCovMatrixGlobal = MathUtils.inverse(this.covMatrixGlobal);
        }
    }

    public int getFeatureDimension() {
        if (this.clusters != null && this.clusters[0].meanVector != null) {
            return this.clusters[0].meanVector.length;
        }
        return 0;
    }

    public int getTotalClusters() {
        if (this.clusters != null) {
            return this.clusters.length;
        }
        return 0;
    }

    public boolean isDiagonalCovariance() {
        if (this.clusters != null) {
            return this.clusters[0].isDiagonalCovariance;
        }
        return false;
    }
}

