/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.gmm.jointgmm;

import java.io.IOException;
import marytts.machinelearning.GMM;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.analysis.FeatureFileHeader;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.math.MathUtils;

public class JointGMM {
    public GMM source;
    public GMM targetMeans;
    public GMM covarianceTerms;
    public int featureType;
    public FeatureFileHeader featureParams;

    public JointGMM(JointGMM existing) {
        if (existing != null) {
            this.source = new GMM(existing.source);
            this.targetMeans = new GMM(existing.targetMeans);
            this.covarianceTerms = new GMM(existing.covarianceTerms);
            this.featureType = existing.featureType;
            if (existing.featureType == BaselineFeatureExtractor.LSF_FEATURES) {
                this.featureParams = new LsfFileHeader((LsfFileHeader)existing.featureParams);
            } else if (existing.featureType == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                this.featureParams = new MfccFileHeader((MfccFileHeader)existing.featureParams);
            }
        } else {
            this.source = null;
            this.targetMeans = null;
            this.covarianceTerms = null;
            this.featureType = BaselineFeatureExtractor.NOT_DEFINED;
            this.featureParams = null;
        }
    }

    public JointGMM(GMM gmm, FeatureFileHeader featureParamsIn) {
        if (gmm != null && gmm.featureDimension > 0) {
            int actualFeatureDimension = (int)Math.floor((double)gmm.featureDimension * 0.5 + 0.5);
            this.source = new GMM(actualFeatureDimension, gmm.totalComponents, gmm.isDiagonalCovariance);
            this.targetMeans = new GMM(actualFeatureDimension, gmm.totalComponents, true);
            this.covarianceTerms = new GMM(actualFeatureDimension, gmm.totalComponents, gmm.isDiagonalCovariance);
            this.source.info = gmm.info;
            this.targetMeans.info = gmm.info;
            this.covarianceTerms.info = gmm.info;
            if (featureParamsIn instanceof LsfFileHeader) {
                this.featureType = BaselineFeatureExtractor.LSF_FEATURES;
            } else if (featureParamsIn instanceof MfccFileHeader) {
                this.featureType = BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES;
            }
            int i = 0;
            while (i < gmm.totalComponents) {
                this.source.components[i].setMeanVector(gmm.components[i].meanVector, 0, actualFeatureDimension);
                this.source.components[i].setCovMatrix(gmm.components[i].covMatrix, 0, 0, actualFeatureDimension);
                this.targetMeans.components[i].setMeanVector(gmm.components[i].meanVector, actualFeatureDimension, actualFeatureDimension);
                this.covarianceTerms.components[i].setCovMatrix(gmm.components[i].covMatrix, actualFeatureDimension, 0, actualFeatureDimension);
                this.covarianceTerms.components[i].covMatrix = MathUtils.matrixProduct(this.covarianceTerms.components[i].covMatrix, this.source.components[i].getInvCovMatrix());
                ++i;
            }
            if (this.featureType == BaselineFeatureExtractor.LSF_FEATURES) {
                this.featureParams = new LsfFileHeader((LsfFileHeader)featureParamsIn);
            } else if (this.featureType == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                this.featureParams = new MfccFileHeader((MfccFileHeader)featureParamsIn);
            }
        } else {
            this.source = null;
            this.targetMeans = null;
            this.covarianceTerms = null;
            this.featureType = BaselineFeatureExtractor.NOT_DEFINED;
            this.featureParams = null;
        }
    }

    public JointGMM(MaryRandomAccessFile stream) {
        this.read(stream);
    }

    public void write(MaryRandomAccessFile stream) {
        if (stream != null) {
            try {
                stream.writeIntEndian(this.featureType);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.featureParams.writeHeader(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                try {
                    this.source.write(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    this.targetMeans.write(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    this.covarianceTerms.write(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void read(MaryRandomAccessFile stream) {
        if (stream != null) {
            try {
                this.featureType = stream.readIntEndian();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.featureParams = this.featureType == BaselineFeatureExtractor.LSF_FEATURES ? new LsfFileHeader() : (this.featureType == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES ? new MfccFileHeader() : null);
            if (this.featureParams != null) {
                try {
                    this.featureParams.readHeader(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                if (this.source == null) {
                    this.source = new GMM();
                }
                try {
                    this.source.read(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.targetMeans == null) {
                    this.targetMeans = new GMM();
                }
                try {
                    this.targetMeans.read(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.covarianceTerms == null) {
                    this.covarianceTerms = new GMM();
                }
                try {
                    this.covarianceTerms.read(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

