/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import java.util.Arrays;
import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchStatisticsCollection;
import marytts.util.math.MathUtils;

public class PitchStatisticsMapping {
    public PitchStatistics sourceGlobalStatisticsHz;
    public PitchStatistics targetGlobalStatisticsHz;
    public PitchStatisticsCollection sourceLocalStatisticsHz;
    public PitchStatisticsCollection targetLocalStatisticsHz;
    public PitchStatistics sourceGlobalStatisticsLogHz;
    public PitchStatistics targetGlobalStatisticsLogHz;
    public PitchStatisticsCollection sourceLocalStatisticsLogHz;
    public PitchStatisticsCollection targetLocalStatisticsLogHz;
    public double[] sourceVariancesHz;
    public double[] targetVariancesHz;
    public double[] sourceVariancesLogHz;
    public double[] targetVariancesLogHz;

    public PitchStatisticsMapping(PitchStatisticsCollection allFromTraining) {
        this.sourceGlobalStatisticsHz = new PitchStatistics(allFromTraining.getGlobalStatisticsSourceHz());
        this.targetGlobalStatisticsHz = new PitchStatistics(allFromTraining.getGlobalStatisticsTargetHz());
        this.sourceLocalStatisticsHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsSourceHz());
        this.targetLocalStatisticsHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsTargetHz());
        this.sourceVariancesHz = this.setVariances(this.sourceLocalStatisticsHz);
        this.targetVariancesHz = this.setVariances(this.targetLocalStatisticsHz);
        this.sourceGlobalStatisticsLogHz = new PitchStatistics(allFromTraining.getGlobalStatisticsSourceLogHz());
        this.targetGlobalStatisticsLogHz = new PitchStatistics(allFromTraining.getGlobalStatisticsTargetLogHz());
        this.sourceLocalStatisticsLogHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsSourceLogHz());
        this.targetLocalStatisticsLogHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsTargetLogHz());
        this.sourceVariancesLogHz = this.setVariances(this.sourceLocalStatisticsLogHz);
        this.targetVariancesLogHz = this.setVariances(this.targetLocalStatisticsLogHz);
    }

    private double[] setVariances(PitchStatisticsCollection p) {
        double[] variances = new double[5];
        if (p.entries != null) {
            if (p.entries.length < 2) {
                Arrays.fill(variances, 1.0);
            } else {
                double[][] vals = new double[variances.length][];
                int i = 0;
                while (i < variances.length) {
                    vals[i] = new double[p.entries.length];
                    ++i;
                }
                int j = 0;
                while (j < p.entries.length) {
                    vals[0][j] = p.entries[j].mean;
                    ++j;
                }
                j = 0;
                while (j < p.entries.length) {
                    vals[1][j] = p.entries[j].standardDeviation;
                    ++j;
                }
                j = 0;
                while (j < p.entries.length) {
                    vals[2][j] = p.entries[j].range;
                    ++j;
                }
                j = 0;
                while (j < p.entries.length) {
                    vals[3][j] = p.entries[j].intercept;
                    ++j;
                }
                j = 0;
                while (j < p.entries.length) {
                    vals[4][j] = p.entries[j].slope;
                    ++j;
                }
                variances = MathUtils.getVarianceRows(vals);
            }
        }
        return variances;
    }
}

