/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FeatureFileHeader {
    public int numfrm;
    public int dimension;
    public float winsize;
    public float skipsize;
    public int samplingRate;

    public FeatureFileHeader() {
        this.numfrm = 0;
        this.dimension = 0;
        this.winsize = 0.02f;
        this.skipsize = 0.01f;
        this.samplingRate = 0;
    }

    public FeatureFileHeader(FeatureFileHeader existingHeader) {
        this.numfrm = existingHeader.numfrm;
        this.dimension = existingHeader.dimension;
        this.winsize = existingHeader.winsize;
        this.skipsize = existingHeader.skipsize;
        this.samplingRate = existingHeader.samplingRate;
    }

    public FeatureFileHeader(String featureFile) {
        try {
            this.readHeader(featureFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isIdenticalAnalysisParams(FeatureFileHeader hdr) {
        if (this.numfrm != hdr.numfrm) {
            return false;
        }
        if (this.dimension != hdr.dimension) {
            return false;
        }
        if (this.winsize != hdr.winsize) {
            return false;
        }
        if (this.skipsize != hdr.skipsize) {
            return false;
        }
        return this.samplingRate == hdr.samplingRate;
    }

    public void readHeader(String file) throws IOException {
        this.readHeader(file, false);
    }

    public DataInputStream readHeader(String file, boolean bLeaveStreamOpen) throws IOException {
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        if (stream != null) {
            this.readHeader(stream);
            if (!bLeaveStreamOpen) {
                stream.close();
            }
        }
        return stream;
    }

    public void readHeader(DataInput stream) throws IOException {
        this.numfrm = stream.readInt();
        this.dimension = stream.readInt();
        this.winsize = stream.readFloat();
        this.skipsize = stream.readFloat();
        this.samplingRate = stream.readInt();
    }

    public void writeHeader(String file) throws IOException {
        this.writeHeader(file, false);
    }

    public DataOutputStream writeHeader(String file, boolean bLeaveStreamOpen) throws IOException {
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        if (stream != null) {
            this.writeHeader(stream);
            if (!bLeaveStreamOpen) {
                stream.close();
                stream = null;
            }
        }
        return stream;
    }

    public void writeHeader(DataOutput ler) throws IOException {
        ler.writeInt(this.numfrm);
        ler.writeInt(this.dimension);
        ler.writeFloat(this.winsize);
        ler.writeFloat(this.skipsize);
        ler.writeInt(this.samplingRate);
    }
}

