/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.PolarFrequencyProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class Whisperiser
extends PolarFrequencyProcessor {
    public Whisperiser(int fftSize, double amount) {
        super(fftSize, amount);
    }

    public Whisperiser(int fftSize) {
        super(fftSize, 1.0);
    }

    @Override
    protected void processPolar(double[] r, double[] phi) {
        int i = 0;
        while (i < r.length) {
            phi[i] = Math.PI * 2 * Math.random();
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            int frameLength = Integer.getInteger("signalproc.whisperiser.framelength", 64);
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, frameLength, samplingRate, new Whisperiser(frameLength));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_whisperised.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

