/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis.pitch;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechSignal;
import marytts.signalproc.sinusoidal.PitchSynchronousSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.pitch.BaseSinusoidalPitchTracker;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class HarmonicPitchTracker
extends BaseSinusoidalPitchTracker {
    @Override
    public double performanceCriterion(NonharmonicSinusoidalSpeechFrame sinFrame, float f0Candidate, int samplingRate) {
        double Q = 0.0;
        double maxFreqInHz = Math.max(1000.0, (double)f0Candidate + 50.0);
        double maxFreqInRadians = SignalProcUtils.hz2radian(maxFreqInHz, samplingRate);
        int Kw0 = Math.max(0, (int)Math.floor(maxFreqInHz / (double)f0Candidate + 0.5 + 1.0));
        int K = 0;
        while ((double)sinFrame.sinusoids[K].freq < maxFreqInRadians) {
            if (++K < sinFrame.sinusoids.length - 1) continue;
            K = sinFrame.sinusoids.length - 1;
            break;
        }
        if (K < 1) {
            Q = -1.0E50;
        } else {
            int kw0Ind;
            double kw0;
            int k;
            double tempSum;
            int l = 1;
            while (l <= K) {
                tempSum = 0.0;
                double freqHz = SignalProcUtils.radian2hz(sinFrame.sinusoids[l - 1].freq, samplingRate);
                k = 1;
                while (k <= K) {
                    kw0 = (float)k * f0Candidate;
                    kw0Ind = SignalProcUtils.freq2index(kw0, (double)samplingRate, sinFrame.systemAmps.length - 1);
                    tempSum += sinFrame.systemAmps[kw0Ind] * Math.abs(MathUtils.sinc(freqHz - kw0, (double)(10 * sinFrame.systemAmps.length)));
                    ++k;
                }
                Q += (double)sinFrame.sinusoids[l - 1].amp * tempSum;
                ++l;
            }
            tempSum = 0.0;
            k = 1;
            while (k <= Kw0) {
                kw0 = (float)k * f0Candidate;
                kw0Ind = SignalProcUtils.freq2index(kw0, (double)samplingRate, sinFrame.systemAmps.length - 1);
                tempSum += sinFrame.systemAmps[kw0Ind] * sinFrame.systemAmps[kw0Ind];
                ++k;
            }
            Q -= 0.5 * tempSum;
        }
        return Q;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        float searchStepInHz = 0.5f;
        float minFreqInHz = 40.0f;
        float maxFreqInHz = 400.0f;
        float windowSizeInSeconds = 0.02f;
        float skipSizeInSeconds = 0.01f;
        float deltaInHz = 50.0f;
        int spectralEnvelopeType = 1;
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        int windowType = 1;
        boolean bRefinePeakEstimatesParabola = false;
        boolean bRefinePeakEstimatesBias = false;
        boolean bSpectralReassignment = false;
        boolean bAdjustNeighFreqDependent = false;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        String strPitchFileIn = String.valueOf(args[0].substring(0, args[0].length() - 4)) + ".ptc";
        PitchReaderWriter f0 = new PitchReaderWriter(strPitchFileIn);
        SignalProcUtils.pitchContour2pitchMarks(f0.contour, samplingRate, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, 0);
        PitchSynchronousSinusoidalAnalyzer sa = new PitchSynchronousSinusoidalAnalyzer(params);
        NonharmonicSinusoidalSpeechSignal ss = sa.extractSinusoidsFixedRate(x, windowSizeInSeconds, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, f0.contour, (float)f0.header.windowSizeInSeconds, (float)f0.header.skipSizeInSeconds);
        HarmonicPitchTracker p = new HarmonicPitchTracker();
        float[] f0s = p.pitchTrack(ss, samplingRate, searchStepInHz, minFreqInHz, maxFreqInHz);
        String strPitchFileOut = String.valueOf(args[0].substring(0, args[0].length() - 4)) + ".ptcSin";
        PitchReaderWriter.write_pitch_file(strPitchFileOut, f0s, windowSizeInSeconds, skipSizeInSeconds, samplingRate);
        int i = 0;
        while (i < f0s.length) {
            System.out.println(String.valueOf(String.valueOf((float)i * skipSizeInSeconds + 0.5f * windowSizeInSeconds)) + " sec. = " + String.valueOf(f0s[i]));
            ++i;
        }
    }
}

