/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.LogSpectrum;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;

public class HanningWindow
extends Window {
    public HanningWindow(int length) {
        super(length);
    }

    public HanningWindow(int length, double prescalingFactor) {
        super(length, prescalingFactor);
    }

    @Override
    protected void initialise() {
        boolean prescale = this.prescalingFactor != 1.0;
        int i = 0;
        while (i < this.window.length) {
            this.window[i] = 0.5 * (1.0 - Math.cos((double)(i * 2) * Math.PI / (double)(this.window.length - 1)));
            if (prescale) {
                int n = i;
                this.window[n] = this.window[n] * this.prescalingFactor;
            }
            ++i;
        }
    }

    public String toString() {
        return "Hann window";
    }

    public static void main(String[] args) {
        int samplingRate = Integer.getInteger("samplingrate", 1);
        int windowLengthMs = Integer.getInteger("windowlength.ms", 0);
        int windowLength = Integer.getInteger("windowlength.samples", 512);
        if (windowLengthMs != 0) {
            windowLength = windowLengthMs * samplingRate / 1000;
        }
        int fftSize = Math.max(4096, MathUtils.closestPowerOfTwoAbove(windowLength));
        HanningWindow w = new HanningWindow(windowLength);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0 / (double)samplingRate, w.window);
        timeGraph.showInJFrame(String.valueOf(((Object)w).toString()) + " in time domain", true, false);
        double[] fftSignal = new double[fftSize];
        double sum = MathUtils.sum(w.window);
        int i = 0;
        while (i < w.window.length) {
            fftSignal[i] = w.window[i] / sum;
            ++i;
        }
        LogSpectrum freqGraph = new LogSpectrum(fftSignal, samplingRate);
        freqGraph.showInJFrame(String.valueOf(((Object)w).toString()) + " log frequency response", true, false);
    }
}

