/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.util.NoSuchElementException;
import java.util.Vector;
import marytts.util.data.text.PraatInterval;
import marytts.util.data.text.PraatTier;

public class PraatIntervalTier
implements PraatTier {
    private final String tierClass = "IntervalTier";
    private double xmin = Double.NaN;
    private double xmax = Double.NaN;
    private String name = null;
    private Vector<PraatInterval> intervals = new Vector();

    public PraatIntervalTier() {
        this.setIntervals(new Vector<PraatInterval>());
    }

    public PraatIntervalTier(String name) {
        this();
        this.setName(name);
    }

    public PraatIntervalTier(Vector<PraatInterval> intervals) {
        this.setIntervals(intervals);
    }

    public String getTierClass() {
        return "IntervalTier";
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public double getXmin() {
        try {
            return this.intervals.firstElement().getXmin();
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.xmin;
        }
    }

    @Override
    public double getXmax() {
        try {
            return this.intervals.lastElement().getXmax();
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.xmax;
        }
    }

    public int getNumberOfIntervals() {
        return this.intervals.size();
    }

    public PraatInterval getInterval(int index) {
        return this.intervals.get(index);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIntervals(Vector<PraatInterval> intervals) {
        this.intervals = intervals;
    }

    public void appendInterval(PraatInterval interval) {
        this.intervals.add(interval);
    }

    public void updateBoundaries() {
        PraatInterval prevInterval = null;
        int index = 0;
        while (index < this.getNumberOfIntervals()) {
            PraatInterval interval = this.getInterval(index);
            if (!interval.isComplete()) {
                if (prevInterval == null) {
                    interval.setXmin(0.0);
                } else {
                    interval.setXmin(prevInterval.getXmax());
                }
                if (interval.getDuration() == 0.0) {
                    interval.setDuration(1.0E-15);
                }
                interval.setXmax(interval.getXmin() + interval.getDuration());
            }
            prevInterval = interval;
            ++index;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("class = \"" + this.getTierClass() + "\" \n");
        str.append("name = \"" + this.getName() + "\" \n");
        str.append("xmin = " + this.getXmin() + " \n");
        str.append("xmax = " + this.getXmax() + " \n");
        str.append("intervals: size = " + this.getNumberOfIntervals() + " \n");
        int i = 0;
        while (i < this.getNumberOfIntervals()) {
            str.append("intervals [" + (i + 1) + "]:\n");
            str.append(this.getInterval(i).toString());
            ++i;
        }
        return str.toString();
    }
}

