/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.modules.InternalModule;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.apache.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class Preprocess
extends InternalModule {
    public Preprocess() {
        super("Preprocess", MaryDataType.TOKENS, MaryDataType.WORDS, Locale.GERMAN);
    }

    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.logger.info((Object)"Expanding say-as elements...");
        this.expandSayasElements(doc);
        this.logger.info((Object)"Matching and expanding patterns...");
        this.matchAndExpandPatterns(doc);
        this.logger.info((Object)"Done.");
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    private void expandSayasElements(Document doc) {
        NodeList sayasElements = doc.getElementsByTagName("say-as");
        int i = 0;
        while (i < sayasElements.getLength()) {
            Element sayas = (Element)sayasElements.item(i);
            String type = sayas.getAttribute("type");
            ExpansionPattern ep = ExpansionPattern.getPattern(type);
            if (ep != null) {
                if (this.logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    this.logger.debug((Object)("Expanding say-as element of type " + type + ", containing text `" + MaryDomUtils.getPlainTextBelow((Node)sayas) + "'"));
                }
                ep.match(sayas, type);
            } else {
                this.logger.info((Object)("Don't know how to expand say-as type=\"" + type + "\""));
            }
            ++i;
        }
    }

    private void matchAndExpandPatterns(Document doc) {
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
        Element t = null;
        while ((t = (Element)tw.nextNode()) != null) {
            if (MaryDomUtils.hasAncestor((Node)t, (String)"say-as") || t.hasAttribute("ph") || t.hasAttribute("sounds_like")) continue;
            Iterator<ExpansionPattern> it = ExpansionPattern.allPatterns().iterator();
            boolean fullyExpanded = false;
            while (!fullyExpanded && it.hasNext()) {
                ExpansionPattern ep = it.next();
                this.logger.debug((Object)("Now applying ep " + ep + " to token " + MaryDomUtils.getPlainTextBelow((Node)t)));
                ArrayList<Element> expanded = new ArrayList<Element>();
                fullyExpanded = ep.process(t, expanded);
                if (fullyExpanded) {
                    this.logger.debug((Object)"fully expanded");
                    assert (!expanded.isEmpty());
                    Element lastToken = this.getLastToken(expanded);
                    assert (lastToken != null);
                    tw.setCurrentNode(lastToken);
                    this.logger.debug((Object)("set treewalker position:" + MaryDomUtils.getPlainTextBelow((Node)((Element)tw.getCurrentNode()))));
                    continue;
                }
                if (expanded.isEmpty()) continue;
                this.logger.debug((Object)"non-final expansion");
                t = this.getFirstToken(expanded);
                assert (t != null);
                tw.setCurrentNode(t);
            }
        }
    }

    private Element getLastToken(List<Element> l) {
        if (l == null) {
            throw new NullPointerException("Received null argument");
        }
        if (l.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        int i = l.size() - 1;
        while (i >= 0) {
            Element e = l.get(i);
            Element t = null;
            t = e.getTagName().equals("t") ? e : MaryDomUtils.getLastElementByTagName((Element)e, (String)"t");
            if (t != null) {
                return t;
            }
            --i;
        }
        return null;
    }

    private Element getFirstToken(List<Element> l) {
        if (l == null) {
            throw new NullPointerException("Received null argument");
        }
        if (l.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        int i = 0;
        while (i < l.size()) {
            Element e = l.get(i);
            Element t = null;
            t = e.getTagName().equals("t") ? e : MaryDomUtils.getFirstElementByTagName((Node)e, (String)"t");
            if (t != null) {
                return t;
            }
            ++i;
        }
        return null;
    }
}

