/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.phonemiser;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class Inflection {
    private final Map<String, String> endingTable = Collections.synchronizedMap(new HashMap());
    private Logger logger;

    public Inflection() throws IOException {
        this.endingTable.put("1d", "");
        this.endingTable.put("1i", "r");
        this.endingTable.put("1", "r");
        this.endingTable.put("2d", "n");
        this.endingTable.put("2i", "n");
        this.endingTable.put("2", "n");
        this.endingTable.put("3d", "n");
        this.endingTable.put("3i", "n");
        this.endingTable.put("3", "m");
        this.endingTable.put("4d", "n");
        this.endingTable.put("4", "");
        this.endingTable.put("5d", "n");
        this.endingTable.put("5", "r");
        this.endingTable.put("6d", "n");
        this.endingTable.put("6", "n");
        this.endingTable.put("7d", "");
        this.endingTable.put("7i", "");
        this.endingTable.put("7", "");
        this.endingTable.put("8d", "n");
        this.endingTable.put("8i", "n");
        this.endingTable.put("8", "r");
        this.endingTable.put("9d", "");
        this.endingTable.put("9i", "s");
        this.endingTable.put("9", "s");
        this.logger = MaryUtils.getLogger((String)"Inflection");
    }

    public void determineEndings(Document doc) {
        NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (!(n instanceof Element)) {
                    return 3;
                }
                Element e = (Element)n;
                if (e.getTagName().equals("t") && e.hasAttribute("ending")) {
                    return 1;
                }
                return 3;
            }
        }, true);
        Element toInflect = null;
        while ((toInflect = (Element)ni.nextNode()) != null) {
            Element t;
            this.logger.debug((Object)("Token `" + MaryDomUtils.tokenText((Element)toInflect) + "' needs an inflection ending."));
            if (!toInflect.hasAttribute("sounds_like")) {
                this.logger.warn((Object)("Token `" + MaryDomUtils.tokenText((Element)toInflect) + "' has an `ending' attribute, but no `sounds_like' attribute. Ignoring."));
                continue;
            }
            if (toInflect.getAttribute("ending").equals("ordinal") && toInflect.getAttribute("pos").equals("ADV")) {
                toInflect.setAttribute("sounds_like", String.valueOf(toInflect.getAttribute("sounds_like")) + "ns");
                this.logger.debug((Object)"...added adverbial ending.");
                continue;
            }
            HashSet<String> endingClasses = new HashSet<String>(Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9"));
            String detType = null;
            TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), true);
            tw.setCurrentNode(toInflect);
            if (!toInflect.getAttribute("syn_attach").equals("1")) {
                Element t2;
                boolean foundStart = false;
                while (!foundStart && (t2 = (Element)tw.previousNode()) != null) {
                    String synAttach = t2.getAttribute("syn_attach");
                    if (synAttach.equals("1") || t2.getAttribute("syn_phrase").equals("CNP") || t2.getAttribute("syn_phrase").equals("CPP")) {
                        foundStart = true;
                    }
                    if (synAttach.equals("2") || detType != null) continue;
                    detType = this.getDeterminerType(t2);
                }
            }
            tw.setCurrentNode(toInflect);
            boolean haveSeenNoun = false;
            while (!((t = (Element)tw.nextNode()) == null || t.getAttribute("syn_attach").equals("1") || (t.getAttribute("syn_phrase").equals("CNP") || t.getAttribute("syn_phrase").equals("CPP")) && haveSeenNoun)) {
                if (t.getAttribute("syn_attach").equals("2") || !t.getAttribute("pos").equals("NN")) continue;
                haveSeenNoun = true;
            }
            HashSet<String> endings = new HashSet<String>();
            for (String endingClass : endingClasses) {
                String key = detType == null ? endingClass : String.valueOf(endingClass) + detType;
                String ending = this.endingTable.get(key);
                assert (ending != null);
                endings.add(ending);
                this.logger.debug((Object)("...ending class " + endingClass + " with " + (detType == null ? "no" : (detType.equals("d") ? "definite" : "indefinite")) + " determiner: Ending `e" + ending + "'"));
            }
            if (endings.size() == 1) {
                String ending = (String)endings.iterator().next();
                this.logger.debug((Object)("...correct ending should be `e" + ending + "'"));
                StringBuilder soundsLike = new StringBuilder(toInflect.getAttribute("sounds_like"));
                if (toInflect.getAttribute("ending").equals("adjadv")) {
                    soundsLike.append("e");
                }
                soundsLike.append(ending);
                toInflect.setAttribute("sounds_like", soundsLike.toString());
                continue;
            }
            this.logger.debug((Object)"...cannot determine right ending, using default `e'.");
        }
    }

    private String getDeterminerType(Element t) {
        if (t.getAttribute("pos").equals("APPRART")) {
            return "d";
        }
        return null;
    }
}

