/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MeasureEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"measure"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    private final String[] _nuDeFeMeasureSymbolNames = new String[]{"s", "Sekunde", "sec", "Sekunde", "ms", "Millisekunde", "msec", "Millisekunde", "min", "Minute", "kcal", "Kilokalorie", "oz.", "Unze", "oz", "Unze"};
    private final String[] _maMeasureSymbolNames = new String[]{"km", "Kilometer", "dm", "Dezimeter", "cm", "Zentimeter", "mm", "Millimeter", "g", "Gramm", "kg", "Kilogramm", "mg", "Milligramm", "A", "Ampere[am-'pe:6]", "V", "Volt", "K", "Kelvin['kEl-vi:n]", String.valueOf(new Character('\u00b0').toString()) + "C", "Grad Celsius['tsEl-zi:-Us]", String.valueOf(new Character('\u02da').toString()) + "C", "Grad Celsius['tsEl-zi:-Us]", "\u2103", "Grad Celsius['tsEl-zi:-Us]", String.valueOf(new Character('\u00b0').toString()) + "F", "Grad Fahrenheit", String.valueOf(new Character('\u02da').toString()) + "F", "Grad Fahrenheit", "\u2109", "Grad Fahrenheit", "Hz", "Hertz", "kHz", "Kilohertz", "MHz", "Megahertz", "GHz", "GigaHertz", "N", "Newton['nju:-t@n]", "Pa", "Pascal", "J", "Joule['dZu:l]", "kJ", "Kilojoule['ki:-lo:-dZu:l]", "W", "Watt", "kW", "Kilowatt", "MW", "Megawatt", "GW", "Gigawatt", "mW", "Milliwatt", "l", "Liter", "dl", "Deziliter", "cl", "Zentiliter", "ml", "Milliliter", "Bq", "Becquerel[bE-k@-'rEl]", "EL", "Essl\u00f6ffel", "TL", "Teel\u00f6ffel", "qm", "Quadratmeter", "m" + new Character('\u00b2').toString(), "Quadratmeter", "m" + new Character('\u00b3').toString(), "Kubikmeter", "ccm", "Kubikzentimeter", "m", "Meter", "%", "Prozent"};
    private final Map<String, String> nuDeFeMeasureSymbolNames = MaryUtils.arrayToMap((String[])this._nuDeFeMeasureSymbolNames);
    private final Map<String, String> maMeasureSymbolNames = MaryUtils.arrayToMap((String[])this._maMeasureSymbolNames);
    protected final String sMeasureSymbol = this.getMeasureSymbols();
    protected final Pattern reMeasureSymbol = Pattern.compile("(" + this.sMeasureSymbol + ")");
    protected final Pattern reMeasure = Pattern.compile("((?:-?[1-9][0-9]{0,8}|0)|(?:-?(?:[1-9][0-9]{0,8}|0)?(?:\\.|,)[0-9]+))(" + this.sMeasureSymbol + ")");
    private final Pattern reMatchingChars = null;

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    private String getMeasureSymbols() {
        StringBuilder _sMeasureSymbol = new StringBuilder("(?:");
        if (this._nuDeFeMeasureSymbolNames.length > 0) {
            _sMeasureSymbol.append(this._nuDeFeMeasureSymbolNames[0]);
        }
        int i = 2;
        while (i < this._nuDeFeMeasureSymbolNames.length) {
            _sMeasureSymbol.append("|" + this._nuDeFeMeasureSymbolNames[i]);
            i += 2;
        }
        if (this._maMeasureSymbolNames.length > 0) {
            _sMeasureSymbol.append(this._maMeasureSymbolNames[0]);
        }
        i = 2;
        while (i < this._maMeasureSymbolNames.length) {
            _sMeasureSymbol.append("|" + this._maMeasureSymbolNames[i]);
            i += 2;
        }
        _sMeasureSymbol.append(")");
        return _sMeasureSymbol.toString();
    }

    @Override
    protected boolean isCandidate(Element t) {
        String s = MaryDomUtils.tokenText((Element)t);
        return this.reMeasureSymbol.matcher(s).matches() || number.isCandidate(t) || this.reMeasure.matcher(s).matches();
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (!this.reMeasure.matcher(s).matches()) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 0: {
                expanded = this.expandMeasure(doc, s);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected List<Element> expandMeasure(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        StringBuilder sb = new StringBuilder();
        String measure = null;
        String amount = null;
        Matcher reMatcher = this.reMeasure.matcher(s);
        if (!reMatcher.find()) {
            return null;
        }
        amount = reMatcher.group(1);
        measure = reMatcher.group(2);
        boolean measureIsMasculine = false;
        String measureName = this.nuDeFeMeasureSymbolNames.get(measure);
        if (measureName == null) {
            measureName = this.maMeasureSymbolNames.get(measure);
            measureIsMasculine = true;
            if (amount.equals("1")) {
                sb.append("ein");
            } else {
                sb.append(number.expandFloat(amount));
            }
        } else if (amount.equals("1")) {
            sb.append("eine");
        } else {
            sb.append(number.expandFloat(amount));
        }
        sb.append(" ");
        sb.append(measureName);
        if (!measureIsMasculine && !amount.equals("1")) {
            sb.append("n");
        }
        exp.addAll(this.makeNewTokens(doc, sb.toString(), true, s));
        return exp;
    }
}

