/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.te.phonemiser;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TeluguLTS {
    private HashMap<String, String> UTF8toPhoneSymbols;
    private HashMap<String, String> UTF8toPhoneTypes;
    private ArrayList<String> listPhoneSym;
    private ArrayList<String> listPhoneTypes;

    public TeluguLTS(InputStream utf8toit3mapStream) throws IOException {
        this.loadPhoneSymbolsAndTypes(utf8toit3mapStream);
    }

    public String phonemise(String word) throws IOException {
        ArrayList<String> utf8CharList = this.readUTF8String(word);
        this.listPhoneSym = new ArrayList();
        this.listPhoneTypes = new ArrayList();
        for (String utf8Char : utf8CharList) {
            String phoneSymbol = this.UTF8toPhoneSymbols.get(utf8Char);
            String phoneType = this.UTF8toPhoneTypes.get(utf8Char);
            if (phoneSymbol == null) {
                phoneSymbol = this.getAsciiChar(utf8Char);
            }
            if (phoneType == null) {
                phoneType = "#";
            }
            this.listPhoneSym.add(phoneSymbol);
            this.listPhoneTypes.add(phoneType);
        }
        this.removeUnknownSymbols();
        this.schwaHandler();
        this.removeHal();
        this.syllabify();
        this.putStressMark();
        return this.getStringfromArrayList(this.listPhoneSym);
    }

    private ArrayList<String> putStressMark() {
        this.listPhoneSym.add(0, "'");
        return this.listPhoneSym;
    }

    private void syllabify() {
        int i = 0;
        while (i < this.listPhoneTypes.size()) {
            if (this.isVowel(i)) {
                boolean isVowelLater = this.isVowelLater(i);
                boolean isNextSemiCon = this.isNextSemiConsonant(i);
                if (isVowelLater) {
                    if (isNextSemiCon) {
                        this.listPhoneSym.add(i + 2, "-");
                        this.listPhoneTypes.add(i + 2, "SYM");
                    } else {
                        this.listPhoneSym.add(i + 1, "-");
                        this.listPhoneTypes.add(i + 1, "SYM");
                    }
                }
            }
            ++i;
        }
    }

    private boolean isVowel(int pos) {
        return this.listPhoneTypes.get(pos).equals("VOW");
    }

    private boolean isVowelLater(int pos) {
        int i = pos + 1;
        while (i < this.listPhoneTypes.size()) {
            if (this.listPhoneTypes.get(i).equals("VOW")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isNextSemiConsonant(int pos) {
        if (pos + 1 >= this.listPhoneSym.size()) {
            return false;
        }
        return this.listPhoneSym.get(pos + 1).equals("n:") || this.listPhoneSym.get(pos + 1).equals("a:");
    }

    private String getStringfromArrayList(ArrayList<String> aList) {
        Iterator<String> listrun = aList.iterator();
        StringBuilder result = new StringBuilder();
        while (listrun.hasNext()) {
            result.append(listrun.next());
        }
        return result.toString();
    }

    private String toHex4(int ch) {
        String hex = Integer.toHexString(ch).toUpperCase();
        switch (hex.length()) {
            case 3: {
                return "0" + hex;
            }
            case 2: {
                return "00" + hex;
            }
            case 1: {
                return "000" + hex;
            }
        }
        return hex;
    }

    private void loadPhoneSymbolsAndTypes(InputStream inStream) throws IOException {
        String line;
        BufferedReader bfr = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        this.UTF8toPhoneSymbols = new HashMap();
        this.UTF8toPhoneTypes = new HashMap();
        while ((line = bfr.readLine()) != null) {
            String[] words = line.split("\\|");
            this.UTF8toPhoneSymbols.put(words[0], words[1]);
            this.UTF8toPhoneTypes.put(words[0], words[2]);
        }
        bfr.close();
    }

    public ArrayList<String> readUTF8String(String word) throws IOException {
        CharBuffer cbuf = CharBuffer.wrap(word);
        ArrayList<String> utf8CharList = new ArrayList<String>();
        int i = 0;
        while (i < cbuf.length()) {
            char ch = cbuf.get(i);
            utf8CharList.add(this.toHex4(ch));
            ++i;
        }
        return utf8CharList;
    }

    public ArrayList<String> readUTF8File(String filename) throws IOException {
        int ch;
        ArrayList<String> utf8CharList = new ArrayList<String>();
        InputStreamReader ins = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8");
        while ((ch = ins.read()) >= 0) {
            utf8CharList.add(this.toHex4(ch));
        }
        return utf8CharList;
    }

    private void printData(String filename) throws IOException {
        ArrayList<String> utf8CharList = this.readUTF8File(filename);
        for (String utf8Char : utf8CharList) {
            String phoneSymbol = this.UTF8toPhoneSymbols.get(utf8Char);
            String phoneType = this.UTF8toPhoneTypes.get(utf8Char);
            if (phoneSymbol == null) {
                phoneSymbol = "SPACE";
            }
            if (phoneType == null) {
                phoneType = "#";
            }
            System.out.println(String.valueOf(utf8Char) + " " + phoneSymbol + " " + phoneType);
        }
    }

    public void makeProperIt3(String filename) throws IOException {
        ArrayList<String> utf8CharList = this.readUTF8File(filename);
        ArrayList<String> lPhoneSym = new ArrayList<String>();
        ArrayList<String> lPhoneTypes = new ArrayList<String>();
        for (String utf8Char : utf8CharList) {
            String phoneSymbol = this.UTF8toPhoneSymbols.get(utf8Char);
            String phoneType = this.UTF8toPhoneTypes.get(utf8Char);
            if (phoneSymbol == null) {
                phoneSymbol = this.getAsciiChar(utf8Char);
            }
            if (phoneType == null) {
                phoneType = "#";
            }
            lPhoneSym.add(phoneSymbol);
            lPhoneTypes.add(phoneType);
            System.out.println(String.valueOf(utf8Char) + " " + phoneSymbol + " " + phoneType);
        }
        this.printArrayList(lPhoneSym);
        this.printArrayList(lPhoneTypes);
        lPhoneSym = this.schwaHandler(lPhoneSym, lPhoneTypes);
        lPhoneSym = this.removeHal(lPhoneSym, lPhoneTypes);
        this.printArrayList(lPhoneSym);
    }

    private ArrayList<String> removeHal(ArrayList<String> lPhoneSym, ArrayList<String> lPhoneTypes) {
        int i = 0;
        while (i < lPhoneTypes.size()) {
            if (lPhoneTypes.get(i).equals("HLT")) {
                lPhoneTypes.remove(i);
                lPhoneSym.remove(i);
                --i;
            }
            ++i;
        }
        return lPhoneSym;
    }

    private void removeHal() {
        int i = 0;
        while (i < this.listPhoneTypes.size()) {
            if (this.listPhoneTypes.get(i).equals("HLT")) {
                this.listPhoneTypes.remove(i);
                this.listPhoneSym.remove(i);
                --i;
            }
            ++i;
        }
    }

    private void removeUnknownSymbols() {
        int i = 0;
        while (i < this.listPhoneTypes.size()) {
            if (this.listPhoneTypes.get(i).equals("#")) {
                this.listPhoneTypes.remove(i);
                this.listPhoneSym.remove(i);
                --i;
            }
            ++i;
        }
    }

    private String getAsciiChar(String utf8Char) {
        int intValue = Integer.parseInt(utf8Char, 16);
        char dec = (char)intValue;
        return Character.toString(dec);
    }

    private ArrayList<String> schwaHandler(ArrayList<String> lPhoneSym, ArrayList<String> lPhoneTypes) {
        int i = 0;
        while (i < lPhoneTypes.size()) {
            String prev = lPhoneTypes.get(i);
            String next = i + 1 < lPhoneTypes.size() ? lPhoneTypes.get(i + 1) : lPhoneTypes.get(i);
            if (prev.equals("CON") && next.equals("CON") || prev.equals("CON") && next.equals("SYM") || prev.equals("CON") && next.equals("#")) {
                lPhoneTypes.add(i + 1, "VOW");
                lPhoneSym.add(i + 1, "a");
            }
            ++i;
        }
        return lPhoneSym;
    }

    private void schwaHandler() {
        int i = 0;
        while (i < this.listPhoneTypes.size()) {
            String prev = this.listPhoneTypes.get(i);
            String next = i + 1 < this.listPhoneTypes.size() ? this.listPhoneTypes.get(i + 1) : this.listPhoneTypes.get(i);
            if (prev.equals("CON") && next.equals("CON") || prev.equals("CON") && next.equals("SYM") || prev.equals("CON") && next.equals("#")) {
                this.listPhoneTypes.add(i + 1, "VOW");
                this.listPhoneSym.add(i + 1, "a");
            }
            ++i;
        }
    }

    private void printArrayList(ArrayList<String> aList) {
        Iterator<String> listrun = aList.iterator();
        System.out.println();
        while (listrun.hasNext()) {
            System.out.print(listrun.next());
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        TeluguLTS utf8r = new TeluguLTS(new FileInputStream("~/openmary/lib/modules/te/lexicon/UTF8phone.te.list"));
        System.out.println("Result : " + utf8r.phonemise("\u0c2a\u0c4d\u0c30\u0c15\u0c3e\u0c30\u0c02"));
    }
}

